/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.history.v1.History;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondQueryTaskCompletedRequest;
import io.temporal.common.WorkflowExecutionHistory;
import io.temporal.internal.worker.WorkflowTaskHandler;
import java.util.List;
import java.util.Optional;

public class QueryReplayHelper {
    private final WorkflowTaskHandler handler;

    public QueryReplayHelper(WorkflowTaskHandler nonStickyHandler) {
        this.handler = nonStickyHandler;
    }

    public Optional<Payloads> queryWorkflowExecution(String jsonSerializedHistory, String queryType, Optional<Payloads> args) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson(jsonSerializedHistory);
        return this.queryWorkflowExecution(queryType, args, history, ByteString.EMPTY);
    }

    public Optional<Payloads> queryWorkflowExecution(io.temporal.internal.common.WorkflowExecutionHistory history, String queryType, Optional<Payloads> args) throws Exception {
        return this.queryWorkflowExecution(queryType, args, history, ByteString.EMPTY);
    }

    private Optional<Payloads> queryWorkflowExecution(String queryType, Optional<Payloads> args, io.temporal.internal.common.WorkflowExecutionHistory history, ByteString nextPageToken) throws Exception {
        WorkflowQuery.Builder query = WorkflowQuery.newBuilder().setQueryType(queryType);
        args.ifPresent(arg_0 -> ((WorkflowQuery.Builder)query).setQueryArgs(arg_0));
        PollWorkflowTaskQueueResponse.Builder task = PollWorkflowTaskQueueResponse.newBuilder().setWorkflowExecution(history.getWorkflowExecution()).setStartedEventId(Long.MAX_VALUE).setPreviousStartedEventId(Long.MAX_VALUE).setNextPageToken(nextPageToken).setQuery(query);
        List<HistoryEvent> events = history.getEvents();
        HistoryEvent startedEvent = events.get(0);
        if (!startedEvent.hasWorkflowExecutionStartedEventAttributes()) {
            throw new IllegalStateException("First event of the history is not WorkflowExecutionStarted: " + startedEvent);
        }
        WorkflowExecutionStartedEventAttributes started = startedEvent.getWorkflowExecutionStartedEventAttributes();
        WorkflowType workflowType = started.getWorkflowType();
        task.setWorkflowType(workflowType);
        task.setHistory(History.newBuilder().addAllEvents(events));
        WorkflowTaskHandler.Result result = this.handler.handleWorkflowTask(task.build());
        if (result.getQueryCompleted() != null) {
            RespondQueryTaskCompletedRequest r = result.getQueryCompleted();
            if (!r.getErrorMessage().isEmpty()) {
                throw new RuntimeException("query failure for " + history.getWorkflowExecution() + ", queryType=" + queryType + ", args=" + args + ", error=" + r.getErrorMessage());
            }
            if (r.hasQueryResult()) {
                return Optional.of(r.getQueryResult());
            }
            return Optional.empty();
        }
        throw new RuntimeException("Query returned wrong response: " + result);
    }
}

