/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import com.google.common.base.MoreObjects;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.common.SearchAttribute;
import io.temporal.common.SearchAttributeKey;
import io.temporal.common.SearchAttributeUpdate;
import io.temporal.common.SearchAttributes;
import io.temporal.internal.common.SearchAttributePayloadConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchAttributesUtil {
    private static final SearchAttributePayloadConverter converter = SearchAttributePayloadConverter.INSTANCE;

    @Nullable
    public static io.temporal.api.common.v1.SearchAttributes encodeTyped(@Nullable SearchAttributes searchAttributes) {
        if (searchAttributes == null || searchAttributes.size() == 0) {
            return null;
        }
        SearchAttributes.Builder builder = io.temporal.api.common.v1.SearchAttributes.newBuilder();
        searchAttributes.getUntypedValues().forEach((key, value) -> builder.putIndexedFields(key.getName(), converter.encodeTyped((SearchAttributeKey<?>)key, value)));
        return builder.build();
    }

    @Nonnull
    public static SearchAttributes decodeTyped(@Nullable io.temporal.api.common.v1.SearchAttributes searchAttributes) {
        if (searchAttributes == null || searchAttributes.getIndexedFieldsCount() == 0) {
            return SearchAttributes.EMPTY;
        }
        SearchAttributes.Builder builder = SearchAttributes.newBuilder();
        searchAttributes.getIndexedFieldsMap().forEach((key, value) -> converter.decodeTyped(builder, (String)key, (Payload)value));
        return builder.build();
    }

    @Nonnull
    public static io.temporal.api.common.v1.SearchAttributes encodeTypedUpdates(SearchAttributeUpdate<?> ... searchAttributeUpdates) {
        if (searchAttributeUpdates == null || searchAttributeUpdates.length == 0) {
            throw new IllegalArgumentException("At least one update required");
        }
        SearchAttributes.Builder builder = io.temporal.api.common.v1.SearchAttributes.newBuilder();
        for (SearchAttributeUpdate<?> update : searchAttributeUpdates) {
            builder.putIndexedFields(update.getKey().getName(), converter.encodeTyped(update.getKey(), update.getValue()));
        }
        return builder.build();
    }

    @Nonnull
    public static io.temporal.api.common.v1.SearchAttributes encode(@Nonnull Map<String, ?> searchAttributes) {
        SearchAttributes.Builder builder = io.temporal.api.common.v1.SearchAttributes.newBuilder();
        searchAttributes.forEach((key, value) -> builder.putIndexedFields(key, converter.encode(MoreObjects.firstNonNull((Object)value, SearchAttribute.UNSET_VALUE))));
        return builder.build();
    }

    @Nonnull
    public static Map<String, List<?>> decode(@Nonnull io.temporal.api.common.v1.SearchAttributes searchAttributes) {
        if (SearchAttributesUtil.isEmpty(searchAttributes)) {
            return Collections.emptyMap();
        }
        Map searchAttributesMap = searchAttributes.getIndexedFieldsMap();
        HashMap deserializedMap = new HashMap(searchAttributesMap.size() * 4 / 3);
        searchAttributesMap.forEach((key, payload) -> {
            List<?> data = converter.decode((Payload)payload);
            if (data.size() > 0) {
                deserializedMap.put((String)key, data);
            }
        });
        return deserializedMap;
    }

    @Nullable
    public static <T> List<T> decode(@Nonnull io.temporal.api.common.v1.SearchAttributes searchAttributes, @Nonnull String attributeName) {
        if (SearchAttributesUtil.isEmpty(searchAttributes) || !searchAttributes.containsIndexedFields(attributeName)) {
            return null;
        }
        Payload payload = searchAttributes.getIndexedFieldsOrThrow(attributeName);
        List<?> data = converter.decode(payload);
        if (data.size() == 0) {
            return null;
        }
        return data;
    }

    @Nullable
    public static <T> List<T> decodeAsType(@Nonnull io.temporal.api.common.v1.SearchAttributes searchAttributes, @Nonnull String attributeName, @Nonnull IndexedValueType indexType) {
        if (SearchAttributesUtil.isEmpty(searchAttributes) || !searchAttributes.containsIndexedFields(attributeName)) {
            return null;
        }
        Payload payload = searchAttributes.getIndexedFieldsOrThrow(attributeName);
        List<?> data = converter.decodeAsType(payload, indexType);
        if (data.size() == 0) {
            return null;
        }
        return data;
    }

    private static boolean isEmpty(io.temporal.api.common.v1.SearchAttributes searchAttributes) {
        return searchAttributes.getIndexedFieldsCount() == 0;
    }
}

