/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.client;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.client.UpdateHandle;
import io.temporal.client.WorkflowException;
import io.temporal.client.WorkflowServiceException;
import io.temporal.common.Experimental;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Experimental
public final class LazyUpdateHandleImpl<T>
implements UpdateHandle<T> {
    private final WorkflowClientCallsInterceptor workflowClientInvoker;
    private final String workflowType;
    private final String updateName;
    private final String id;
    private final WorkflowExecution execution;
    private final Class<T> resultClass;
    private final Type resultType;
    private WorkflowClientCallsInterceptor.PollWorkflowUpdateOutput<T> waitCompletedPollCall;

    public LazyUpdateHandleImpl(WorkflowClientCallsInterceptor workflowClientInvoker, String workflowType, String updateName, String id, WorkflowExecution execution, Class<T> resultClass, Type resultType) {
        this.workflowClientInvoker = workflowClientInvoker;
        this.workflowType = workflowType;
        this.updateName = updateName;
        this.id = id;
        this.execution = execution;
        this.resultClass = resultClass;
        this.resultType = resultType;
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.execution;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<T> getResultAsync(long timeout, TimeUnit unit) {
        WorkflowClientCallsInterceptor.PollWorkflowUpdateOutput<T> pollCall = null;
        LazyUpdateHandleImpl lazyUpdateHandleImpl = this;
        synchronized (lazyUpdateHandleImpl) {
            if (this.waitCompletedPollCall != null) {
                pollCall = this.waitCompletedPollCall;
                this.waitCompletedPollCall = null;
            }
        }
        if (pollCall == null) {
            pollCall = this.pollUntilComplete(timeout, unit);
        }
        return pollCall.getResult().exceptionally(failure -> {
            if (failure instanceof CompletionException) {
                failure = failure.getCause();
            }
            if ((failure = CheckedExceptionWrapper.unwrap((Throwable)failure)) instanceof Error) {
                throw (Error)failure;
            }
            if (failure instanceof StatusRuntimeException) {
                StatusRuntimeException sre = (StatusRuntimeException)((Object)failure);
                if (Status.Code.NOT_FOUND.equals((Object)sre.getStatus().getCode())) {
                    throw sre;
                }
                throw sre;
            }
            if (failure instanceof WorkflowException) {
                throw (WorkflowException)failure;
            }
            if (failure instanceof TimeoutException) {
                throw new CompletionException((Throwable)failure);
            }
            throw new WorkflowServiceException(this.execution, this.workflowType, (Throwable)failure);
        });
    }

    @Override
    public CompletableFuture<T> getResultAsync() {
        return this.getResultAsync(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    void waitCompleted() {
        this.waitCompletedPollCall = this.pollUntilComplete(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private WorkflowClientCallsInterceptor.PollWorkflowUpdateOutput<T> pollUntilComplete(long timeout, TimeUnit unit) {
        return this.workflowClientInvoker.pollWorkflowUpdate(new WorkflowClientCallsInterceptor.PollWorkflowUpdateInput<T>(this.execution, this.updateName, this.id, this.resultClass, this.resultType, timeout, unit));
    }
}

