/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common.kotlin;

import java.lang.annotation.Annotation;

public abstract class KotlinDetector {
    private static final Class<? extends Annotation> kotlinMetadata;
    private static final boolean kotlinReflectPresent;

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isKotlinPresent() {
        return kotlinMetadata != null;
    }

    public static boolean isKotlinReflectPresent() {
        return kotlinReflectPresent;
    }

    public static boolean isKotlinType(Class<?> clazz) {
        return kotlinMetadata != null && clazz.getDeclaredAnnotation(kotlinMetadata) != null;
    }

    static {
        Class<?> metadata;
        ClassLoader classLoader = KotlinDetector.class.getClassLoader();
        try {
            metadata = Class.forName("kotlin.Metadata", false, classLoader);
        }
        catch (ClassNotFoundException ex) {
            metadata = null;
        }
        kotlinMetadata = metadata;
        kotlinReflectPresent = KotlinDetector.isPresent("kotlin.reflect.full.KClasses", classLoader);
    }
}

