/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import io.temporal.internal.worker.LocalActivityAttemptTask;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.workflow.Functions;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalActivitySlotSupplierQueue {
    private final PriorityBlockingQueue<QueuedLARequest> requestQueue;
    private final Semaphore newExecutionsBackpressureSemaphore;
    private final TrackingSlotSupplier<LocalActivitySlotInfo> slotSupplier;
    private final Functions.Proc1<LocalActivityAttemptTask> afterReservedCallback;
    private final Thread queueThread;
    private static final Logger log = LoggerFactory.getLogger((String)LocalActivitySlotSupplierQueue.class.getName());
    private volatile boolean running = true;

    LocalActivitySlotSupplierQueue(TrackingSlotSupplier<LocalActivitySlotInfo> slotSupplier, Functions.Proc1<LocalActivityAttemptTask> afterReservedCallback) {
        this.afterReservedCallback = afterReservedCallback;
        int maximumSlots = slotSupplier.maximumSlots().orElse(50) * 2;
        this.newExecutionsBackpressureSemaphore = new Semaphore(maximumSlots);
        this.requestQueue = new PriorityBlockingQueue(maximumSlots, (r1, r2) -> {
            if (r1.isRetry && !r2.isRetry) {
                return -1;
            }
            if (!r1.isRetry && r2.isRetry) {
                return 1;
            }
            return 0;
        });
        this.slotSupplier = slotSupplier;
        this.queueThread = new Thread(this::processQueue, "LocalActivitySlotSupplierQueue");
        this.queueThread.start();
    }

    private void processQueue() {
        try {
            while (this.running) {
                SlotPermit slotPermit;
                QueuedLARequest request = this.requestQueue.take();
                try {
                    slotPermit = this.slotSupplier.reserveSlot(request.data);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception e) {
                    log.error("Error reserving local activity slot, dropped activity id {}", (Object)request.task.getActivityId(), (Object)e);
                    continue;
                }
                request.task.getExecutionContext().setPermit(slotPermit);
                this.afterReservedCallback.apply(request.task);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void shutdown() {
        this.running = false;
        this.queueThread.interrupt();
    }

    boolean waitOnBackpressure(@Nullable Long acceptanceTimeoutMs) throws InterruptedException {
        boolean accepted;
        if (acceptanceTimeoutMs == null) {
            this.newExecutionsBackpressureSemaphore.acquire();
            accepted = true;
        } else {
            accepted = acceptanceTimeoutMs > 0L ? this.newExecutionsBackpressureSemaphore.tryAcquire(acceptanceTimeoutMs, TimeUnit.MILLISECONDS) : this.newExecutionsBackpressureSemaphore.tryAcquire();
        }
        return accepted;
    }

    void submitAttempt(SlotReservationData data, boolean isRetry, LocalActivityAttemptTask task) {
        QueuedLARequest request = new QueuedLARequest(isRetry, data, task);
        this.requestQueue.add(request);
        if (!isRetry) {
            this.newExecutionsBackpressureSemaphore.release();
        }
    }

    static final class QueuedLARequest {
        final boolean isRetry;
        final SlotReservationData data;
        final LocalActivityAttemptTask task;

        QueuedLARequest(boolean isRetry, SlotReservationData data, LocalActivityAttemptTask task) {
            this.isRetry = isRetry;
            this.data = data;
            this.task = task;
        }
    }
}

