/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.common.base.Preconditions;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.Duration;
import com.uber.m3.util.ImmutableMap;
import io.grpc.Deadline;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.enums.v1.TimeoutType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.failure.v1.TimeoutFailureInfo;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.common.RetryOptions;
import io.temporal.failure.ApplicationFailure;
import io.temporal.internal.activity.ActivityPollResponseToInfo;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.RetryOptionsUtils;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.internal.worker.LocalActivityAttemptTask;
import io.temporal.internal.worker.LocalActivityDispatcher;
import io.temporal.internal.worker.LocalActivityExecutionContext;
import io.temporal.internal.worker.LocalActivityResult;
import io.temporal.internal.worker.LocalActivitySlotSupplierQueue;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.Shutdownable;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.Startable;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerLifecycleState;
import io.temporal.internal.worker.WorkerThreadsNameHelper;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.worker.WorkerMetricsTag;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.workflow.Functions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class LocalActivityWorker
implements Startable,
Shutdownable {
    private static final Logger log = LoggerFactory.getLogger(LocalActivityWorker.class);
    private final ActivityTaskHandler handler;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final LocalActivityDispatcherImpl laScheduler;
    private final PollerOptions pollerOptions;
    private final Scope workerMetricsScope;
    private ScheduledExecutorService scheduledExecutor;
    private PollTaskExecutor<LocalActivityAttemptTask> activityAttemptTaskExecutor;
    private final TrackingSlotSupplier<LocalActivitySlotInfo> slotSupplier;
    private final LocalActivitySlotSupplierQueue slotQueue;

    public LocalActivityWorker(@Nonnull String namespace, @Nonnull String taskQueue, @Nonnull SingleWorkerOptions options, @Nonnull ActivityTaskHandler handler, @Nonnull SlotSupplier<LocalActivitySlotInfo> slotSupplier) {
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.handler = handler;
        this.options = Objects.requireNonNull(options);
        this.pollerOptions = this.getPollerOptions(options);
        this.workerMetricsScope = MetricsTag.tagged((Scope)options.getMetricsScope(), (MetricsTag.TagValue)WorkerMetricsTag.WorkerType.LOCAL_ACTIVITY_WORKER);
        this.slotSupplier = new TrackingSlotSupplier<LocalActivitySlotInfo>(Objects.requireNonNull(slotSupplier), this.workerMetricsScope);
        this.slotQueue = new LocalActivitySlotSupplierQueue(this.slotSupplier, t -> this.activityAttemptTaskExecutor.process((LocalActivityAttemptTask)t));
        this.laScheduler = new LocalActivityDispatcherImpl();
    }

    private void submitRetry(@Nonnull LocalActivityExecutionContext executionContext, @Nonnull PollActivityTaskQueueResponse.Builder activityTask) {
        this.submitAttempt(executionContext, activityTask, true);
    }

    private void submitAttempt(@Nonnull LocalActivityExecutionContext executionContext, @Nonnull PollActivityTaskQueueResponse.Builder activityTask, boolean isRetry) {
        java.time.Duration scheduleToStartTimeout = executionContext.getScheduleToStartTimeout();
        ScheduledFuture<?> scheduleToStartFuture = scheduleToStartTimeout != null ? this.scheduledExecutor.schedule(new FinalTimeoutHandler(TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_START, executionContext), scheduleToStartTimeout.toMillis(), TimeUnit.MILLISECONDS) : null;
        SlotReservationData reservationDat = new SlotReservationData(this.taskQueue, this.options.getIdentity(), this.options.getBuildId());
        activityTask.setCurrentAttemptScheduledTime(ProtobufTimeUtils.getCurrentProtoTime());
        LocalActivityAttemptTask task = new LocalActivityAttemptTask(executionContext, activityTask, scheduleToStartFuture);
        this.slotQueue.submitAttempt(reservationDat, isRetry, task);
    }

    @Nonnull
    private RetryDecision shouldRetry(LocalActivityExecutionContext executionContext, PollActivityTaskQueueResponseOrBuilder activityTask, @Nullable Throwable attemptThrowable) {
        int currentAttempt = activityTask.getAttempt();
        if (LocalActivityWorker.isNonRetryableApplicationFailure(attemptThrowable)) {
            return new RetryDecision(RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, null);
        }
        if (attemptThrowable instanceof Error) {
            throw (Error)attemptThrowable;
        }
        if (LocalActivityWorker.isRetryPolicyNotSet(activityTask)) {
            return new RetryDecision(RetryState.RETRY_STATE_RETRY_POLICY_NOT_SET, null);
        }
        RetryOptions retryOptions = RetryOptionsUtils.toRetryOptions(activityTask.getRetryPolicy());
        if (RetryOptionsUtils.isNotRetryable(retryOptions, attemptThrowable)) {
            return new RetryDecision(RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, null);
        }
        if (RetryOptionsUtils.areAttemptsReached(retryOptions, currentAttempt)) {
            return new RetryDecision(RetryState.RETRY_STATE_MAXIMUM_ATTEMPTS_REACHED, null);
        }
        Optional<java.time.Duration> nextRetryDelay = LocalActivityWorker.getNextRetryDelay(attemptThrowable);
        long sleepMillis = retryOptions.calculateSleepTime(currentAttempt);
        java.time.Duration sleep = nextRetryDelay.orElse(java.time.Duration.ofMillis(sleepMillis));
        if (RetryOptionsUtils.isDeadlineReached(executionContext.getScheduleToCloseDeadline(), sleepMillis)) {
            return new RetryDecision(RetryState.RETRY_STATE_TIMEOUT, null);
        }
        if (sleep.compareTo(executionContext.getLocalRetryThreshold()) > 0) {
            return new RetryDecision(RetryState.RETRY_STATE_IN_PROGRESS, sleep);
        }
        return new RetryDecision(sleep);
    }

    private void scheduleNextAttempt(LocalActivityExecutionContext executionContext, @Nonnull java.time.Duration backoff, @Nullable Failure failure) {
        PollActivityTaskQueueResponse.Builder nextActivityTask = executionContext.getNextAttemptActivityTask(failure);
        Deadline.after((long)backoff.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).runOnExpiration((Runnable)new LocalActivityRetryHandler(executionContext, nextActivityTask), this.scheduledExecutor);
    }

    @Override
    public boolean start() {
        if (this.handler.isAnyTypeSupported()) {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread thread = new Thread(r);
                thread.setName(WorkerThreadsNameHelper.getLocalActivitySchedulerThreadPrefix(this.namespace, this.taskQueue));
                return thread;
            });
            this.activityAttemptTaskExecutor = new PollTaskExecutor<LocalActivityAttemptTask>(this.namespace, this.taskQueue, this.options.getIdentity(), new AttemptTaskHandlerImpl(this.handler), this.pollerOptions, this.slotSupplier.maximumSlots().orElse(Integer.MAX_VALUE), false);
            this.workerMetricsScope.counter("temporal_worker_start").inc(1L);
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        if (this.activityAttemptTaskExecutor != null && !this.activityAttemptTaskExecutor.isShutdown()) {
            this.slotQueue.shutdown();
            return ((CompletableFuture)this.activityAttemptTaskExecutor.shutdown(shutdownManager, interruptTasks).thenCompose(r -> shutdownManager.shutdownExecutor(this.scheduledExecutor, this + "#scheduledExecutor", java.time.Duration.ofSeconds(1L)))).exceptionally(e -> {
                log.error("[BUG] Unexpected exception during shutdown", e);
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        this.slotQueue.shutdown();
        long timeoutMillis = unit.toMillis(timeout);
        ShutdownManager.awaitTermination(this.scheduledExecutor, timeoutMillis);
    }

    @Override
    public boolean isShutdown() {
        return this.activityAttemptTaskExecutor != null && this.activityAttemptTaskExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.activityAttemptTaskExecutor != null && this.activityAttemptTaskExecutor.isTerminated() && this.scheduledExecutor.isTerminated();
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        if (this.activityAttemptTaskExecutor == null) {
            return WorkerLifecycleState.NOT_STARTED;
        }
        if (this.activityAttemptTaskExecutor.isShutdown()) {
            if (this.activityAttemptTaskExecutor.isTerminated() && this.scheduledExecutor.isTerminated()) {
                return WorkerLifecycleState.TERMINATED;
            }
            return WorkerLifecycleState.SHUTDOWN;
        }
        return WorkerLifecycleState.ACTIVE;
    }

    private PollerOptions getPollerOptions(SingleWorkerOptions options) {
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix(WorkerThreadsNameHelper.getLocalActivityPollerThreadPrefix(this.namespace, this.taskQueue)).build();
        }
        return pollerOptions;
    }

    public LocalActivityDispatcher getLocalActivityScheduler() {
        return this.laScheduler;
    }

    private static Failure newTimeoutFailure(TimeoutType timeoutType, @Nullable Failure cause) {
        TimeoutFailureInfo.Builder info = TimeoutFailureInfo.newBuilder().setTimeoutType(timeoutType);
        Failure.Builder result = Failure.newBuilder().setTimeoutFailureInfo(info);
        if (cause != null) {
            result.setCause(cause);
        }
        return result.build();
    }

    private static boolean isRetryPolicyNotSet(PollActivityTaskQueueResponseOrBuilder pollActivityTask) {
        return !pollActivityTask.hasScheduleToCloseTimeout() && (!pollActivityTask.hasRetryPolicy() || pollActivityTask.getRetryPolicy().getMaximumAttempts() <= 0);
    }

    private static boolean isNonRetryableApplicationFailure(@Nullable Throwable executionThrowable) {
        return executionThrowable instanceof ApplicationFailure && ((ApplicationFailure)executionThrowable).isNonRetryable();
    }

    private static Optional<java.time.Duration> getNextRetryDelay(@Nullable Throwable executionThrowable) {
        if (executionThrowable instanceof ApplicationFailure) {
            return Optional.ofNullable(((ApplicationFailure)executionThrowable).getNextRetryDelay());
        }
        return Optional.empty();
    }

    private static class RetryDecision {
        @Nullable
        private final RetryState retryState;
        @Nullable
        private final java.time.Duration nextAttemptBackoff;

        public RetryDecision(@Nonnull RetryState retryState, @Nullable java.time.Duration nextAttemptBackoff) {
            this.retryState = retryState;
            this.nextAttemptBackoff = nextAttemptBackoff;
        }

        public RetryDecision(@Nonnull java.time.Duration nextAttemptBackoff) {
            this.retryState = null;
            this.nextAttemptBackoff = Objects.requireNonNull(nextAttemptBackoff);
        }

        public boolean doNextAttempt() {
            return this.retryState == null;
        }

        public boolean failWorkflowTask() {
            return RetryState.RETRY_STATE_INTERNAL_SERVER_ERROR.equals((Object)this.retryState);
        }
    }

    private class StartToCloseTimeoutHandler
    implements Runnable {
        private final LocalActivityAttemptTask attemptTask;

        private StartToCloseTimeoutHandler(LocalActivityAttemptTask attemptTask) {
            this.attemptTask = attemptTask;
        }

        @Override
        public void run() {
            LocalActivityExecutionContext executionContext = this.attemptTask.getExecutionContext();
            PollActivityTaskQueueResponse.Builder activityTask = this.attemptTask.getAttemptTask();
            String activityId = activityTask.getActivityId();
            int timingOutAttempt = activityTask.getAttempt();
            RetryDecision retryDecision = LocalActivityWorker.this.shouldRetry(executionContext, (PollActivityTaskQueueResponseOrBuilder)activityTask, null);
            if (retryDecision.doNextAttempt()) {
                LocalActivityWorker.this.scheduleNextAttempt(executionContext, Objects.requireNonNull(retryDecision.nextAttemptBackoff, "nextAttemptBackoff is expected to not be null"), LocalActivityWorker.newTimeoutFailure(TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE, null));
            } else {
                TimeoutType timeoutType = RetryState.RETRY_STATE_TIMEOUT.equals((Object)retryDecision.retryState) ? TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE : TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE;
                executionContext.callback(LocalActivityResult.failed(activityId, timingOutAttempt, retryDecision.retryState, LocalActivityWorker.newTimeoutFailure(timeoutType, executionContext.getLastAttemptFailure()), retryDecision.nextAttemptBackoff));
            }
        }
    }

    private static class FinalTimeoutHandler
    implements Runnable {
        private final LocalActivityExecutionContext executionContext;
        private final TimeoutType timeoutType;

        public FinalTimeoutHandler(TimeoutType timeoutType, LocalActivityExecutionContext executionContext) {
            this.executionContext = executionContext;
            this.timeoutType = timeoutType;
        }

        @Override
        public void run() {
            this.executionContext.callback(LocalActivityResult.failed(this.executionContext.getActivityId(), this.executionContext.getCurrentAttempt(), RetryState.RETRY_STATE_TIMEOUT, LocalActivityWorker.newTimeoutFailure(this.timeoutType, this.executionContext.getLastAttemptFailure()), null));
        }
    }

    private class LocalActivityRetryHandler
    implements Runnable {
        @Nonnull
        private final LocalActivityExecutionContext executionContext;
        @Nonnull
        private final PollActivityTaskQueueResponse.Builder activityTask;

        private LocalActivityRetryHandler(@Nonnull LocalActivityExecutionContext executionContext, PollActivityTaskQueueResponse.Builder activityTask) {
            this.executionContext = Objects.requireNonNull(executionContext, "executionContext");
            this.activityTask = Objects.requireNonNull(activityTask, "activityTask");
        }

        @Override
        public void run() {
            LocalActivityWorker.this.submitRetry(this.executionContext, this.activityTask);
        }
    }

    private class AttemptTaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<LocalActivityAttemptTask> {
        private final ActivityTaskHandler handler;

        private AttemptTaskHandlerImpl(ActivityTaskHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(LocalActivityAttemptTask attemptTask) throws Exception {
            SlotReleaseReason reason = SlotReleaseReason.taskComplete();
            ScheduledFuture<?> scheduleToStartFuture = attemptTask.getScheduleToStartFuture();
            boolean scheduleToStartFired = scheduleToStartFuture != null && !scheduleToStartFuture.cancel(false);
            LocalActivityExecutionContext executionContext = attemptTask.getExecutionContext();
            executionContext.newAttempt();
            PollActivityTaskQueueResponse.Builder activityTask = attemptTask.getAttemptTask();
            try {
                boolean shouldDiscardTheResult;
                ActivityTaskHandler.Result activityHandlerResult;
                boolean shouldDiscardTheAttempt;
                boolean bl = shouldDiscardTheAttempt = scheduleToStartFired || executionContext.isCompleted();
                if (shouldDiscardTheAttempt) {
                    return;
                }
                Scope metricsScope = LocalActivityWorker.this.workerMetricsScope.tagged((Map)ImmutableMap.of((Object)"activity_type", (Object)activityTask.getActivityType().getName(), (Object)"workflow_type", (Object)activityTask.getWorkflowType().getName()));
                MDC.put((String)"ActivityId", (String)activityTask.getActivityId());
                MDC.put((String)"ActivityType", (String)activityTask.getActivityType().getName());
                MDC.put((String)"WorkflowId", (String)activityTask.getWorkflowExecution().getWorkflowId());
                MDC.put((String)"WorkflowType", (String)activityTask.getWorkflowType().getName());
                MDC.put((String)"RunId", (String)activityTask.getWorkflowExecution().getRunId());
                LocalActivityWorker.this.slotSupplier.markSlotUsed(new LocalActivitySlotInfo(ActivityPollResponseToInfo.toActivityInfoImpl((PollActivityTaskQueueResponseOrBuilder)activityTask, LocalActivityWorker.this.namespace, LocalActivityWorker.this.taskQueue, true), LocalActivityWorker.this.options.getIdentity(), LocalActivityWorker.this.options.getBuildId()), executionContext.getPermit());
                ScheduledFuture<?> startToCloseTimeoutFuture = null;
                if (activityTask.hasStartToCloseTimeout()) {
                    startToCloseTimeoutFuture = LocalActivityWorker.this.scheduledExecutor.schedule(new StartToCloseTimeoutHandler(attemptTask), ProtobufTimeUtils.toJavaDuration(attemptTask.getAttemptTask().getStartToCloseTimeout()).toMillis(), TimeUnit.MILLISECONDS);
                }
                metricsScope.counter("temporal_local_activity_total").inc(1L);
                Stopwatch sw = metricsScope.timer("temporal_local_activity_execution_latency").start();
                try {
                    activityHandlerResult = this.handler.handle(new ActivityTask((PollActivityTaskQueueResponseOrBuilder)activityTask, executionContext.getPermit(), () -> {}), metricsScope, true);
                }
                finally {
                    sw.stop();
                }
                boolean startToCloseTimeoutFired = startToCloseTimeoutFuture != null && !startToCloseTimeoutFuture.cancel(false);
                boolean bl2 = shouldDiscardTheResult = startToCloseTimeoutFired || executionContext.isCompleted();
                if (shouldDiscardTheResult) {
                    return;
                }
                reason = this.handleResult(activityHandlerResult, attemptTask, metricsScope);
            }
            catch (Throwable ex) {
                log.error("[BUG] Code that expected to never throw an exception threw an exception", ex);
                executionContext.callback(LocalActivityResult.processingFailed(activityTask.getActivityId(), activityTask.getAttempt(), ex));
                throw ex;
            }
            finally {
                LocalActivityWorker.this.slotSupplier.releaseSlot(reason, executionContext.getPermit());
                MDC.remove((String)"ActivityId");
                MDC.remove((String)"ActivityType");
                MDC.remove((String)"WorkflowId");
                MDC.remove((String)"WorkflowType");
                MDC.remove((String)"RunId");
            }
        }

        private SlotReleaseReason handleResult(ActivityTaskHandler.Result activityHandlerResult, LocalActivityAttemptTask attemptTask, Scope metricsScope) {
            LocalActivityExecutionContext executionContext = attemptTask.getExecutionContext();
            PollActivityTaskQueueResponse.Builder activityTask = attemptTask.getAttemptTask();
            int currentAttempt = activityTask.getAttempt();
            SlotReleaseReason releaseReason = SlotReleaseReason.taskComplete();
            if (activityHandlerResult.getTaskCompleted() != null) {
                boolean completedByThisInvocation = executionContext.callback(LocalActivityResult.completed(activityHandlerResult, currentAttempt));
                if (completedByThisInvocation) {
                    Duration e2eDuration = Duration.ofMillis((double)(System.currentTimeMillis() - executionContext.getOriginalScheduledTimestamp()));
                    metricsScope.timer("temporal_local_activity_succeed_endtoend_latency").record(e2eDuration);
                }
                return releaseReason;
            }
            if (activityHandlerResult.getTaskCanceled() != null) {
                executionContext.callback(LocalActivityResult.cancelled(activityHandlerResult, currentAttempt));
                return releaseReason;
            }
            Preconditions.checkState((activityHandlerResult.getTaskFailed() != null ? 1 : 0) != 0, (Object)"One of taskCompleted, taskCanceled or taskFailed must be set");
            Failure executionFailure = activityHandlerResult.getTaskFailed().getTaskFailedRequest().getFailure();
            Throwable executionThrowable = activityHandlerResult.getTaskFailed().getFailure();
            RetryDecision retryDecision = LocalActivityWorker.this.shouldRetry(executionContext, (PollActivityTaskQueueResponseOrBuilder)activityTask, activityHandlerResult.getTaskFailed().getFailure());
            if (retryDecision.doNextAttempt()) {
                releaseReason = SlotReleaseReason.willRetry();
                LocalActivityWorker.this.scheduleNextAttempt(executionContext, Objects.requireNonNull(retryDecision.nextAttemptBackoff, "nextAttemptBackoff is expected to not be null"), executionFailure);
            } else if (retryDecision.failWorkflowTask()) {
                releaseReason = SlotReleaseReason.error(new Exception(executionThrowable));
                executionContext.callback(LocalActivityResult.processingFailed(executionContext.getActivityId(), currentAttempt, executionThrowable));
            } else {
                executionContext.callback(LocalActivityResult.failed(executionContext.getActivityId(), currentAttempt, retryDecision.retryState, executionFailure, retryDecision.nextAttemptBackoff));
            }
            return releaseReason;
        }

        @Override
        public Throwable wrapFailure(LocalActivityAttemptTask task, Throwable failure) {
            return new RuntimeException("Failure processing local activity task.", failure);
        }
    }

    private class LocalActivityDispatcherImpl
    implements LocalActivityDispatcher {
        private LocalActivityDispatcherImpl() {
        }

        @Override
        public boolean dispatch(@Nonnull ExecuteLocalActivityParameters params, @Nonnull Functions.Proc1<LocalActivityResult> resultCallback, @Nullable Deadline acceptanceDeadline) {
            PollActivityTaskQueueResponse.Builder activityTask;
            LocalActivityExecutionContext executionContext;
            boolean retryIsNotAllowed;
            WorkerLifecycleState lifecycleState = LocalActivityWorker.this.getLifecycleState();
            switch (lifecycleState) {
                case NOT_STARTED: {
                    throw new IllegalStateException("Local Activity Worker is not started, no activities were registered");
                }
                case SHUTDOWN: {
                    throw new IllegalStateException("Local Activity Worker is shutdown");
                }
                case TERMINATED: {
                    throw new IllegalStateException("Local Activity Worker is terminated");
                }
                case SUSPENDED: {
                    throw new IllegalStateException("[BUG] Local Activity Worker is suspended. Suspension is not supported for Local Activity Worker");
                }
            }
            Preconditions.checkArgument((boolean)LocalActivityWorker.this.handler.isTypeSupported(params.getActivityType().getName()), (String)"Activity type %s is not supported by the local activity worker", (Object)params.getActivityType().getName());
            long passedFromOriginalSchedulingMs = System.currentTimeMillis() - params.getOriginalScheduledTimestamp();
            java.time.Duration scheduleToCloseTimeout = params.getScheduleToCloseTimeout();
            Deadline scheduleToCloseDeadline = null;
            if (scheduleToCloseTimeout != null) {
                scheduleToCloseDeadline = Deadline.after((long)(scheduleToCloseTimeout.toMillis() - passedFromOriginalSchedulingMs), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            if (retryIsNotAllowed = this.failIfRetryIsNotAllowedByNewPolicy(executionContext = new LocalActivityExecutionContext(params, resultCallback, scheduleToCloseDeadline), (PollActivityTaskQueueResponseOrBuilder)(activityTask = executionContext.getInitialTask()))) {
                return true;
            }
            return this.submitANewExecution(executionContext, activityTask, acceptanceDeadline);
        }

        private boolean submitANewExecution(@Nonnull LocalActivityExecutionContext executionContext, @Nonnull PollActivityTaskQueueResponse.Builder activityTask, @Nullable Deadline acceptanceDeadline) {
            try {
                Long acceptanceTimeoutMs = acceptanceDeadline != null ? Long.valueOf(acceptanceDeadline.timeRemaining(TimeUnit.MILLISECONDS)) : null;
                boolean accepted = LocalActivityWorker.this.slotQueue.waitOnBackpressure(acceptanceTimeoutMs);
                if (!accepted) {
                    log.warn("LocalActivity queue is full and submitting timed out for activity {} with acceptanceTimeoutMs: {}", (Object)activityTask.getActivityId(), (Object)acceptanceTimeoutMs);
                }
                if (accepted) {
                    Deadline scheduleToCloseDeadline = executionContext.getScheduleToCloseDeadline();
                    if (scheduleToCloseDeadline != null) {
                        ScheduledFuture<?> scheduleToCloseFuture = LocalActivityWorker.this.scheduledExecutor.schedule(new FinalTimeoutHandler(TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE, executionContext), scheduleToCloseDeadline.timeRemaining(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                        executionContext.setScheduleToCloseFuture(scheduleToCloseFuture);
                    }
                    LocalActivityWorker.this.submitAttempt(executionContext, activityTask, false);
                    log.trace("LocalActivity queued: {}", (Object)activityTask.getActivityId());
                }
                return accepted;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        private boolean failIfRetryIsNotAllowedByNewPolicy(LocalActivityExecutionContext executionContext, PollActivityTaskQueueResponseOrBuilder attemptTask) {
            RetryState retryState;
            Failure previousExecutionFailure = executionContext.getPreviousExecutionFailure();
            if (previousExecutionFailure != null && !RetryState.RETRY_STATE_IN_PROGRESS.equals((Object)(retryState = this.shouldStillRetry(executionContext, attemptTask, previousExecutionFailure)))) {
                Failure failure = RetryState.RETRY_STATE_TIMEOUT.equals((Object)retryState) ? (previousExecutionFailure.hasTimeoutFailureInfo() && TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE.equals((Object)previousExecutionFailure.getTimeoutFailureInfo().getTimeoutType()) ? LocalActivityWorker.newTimeoutFailure(TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE, previousExecutionFailure.getCause()) : LocalActivityWorker.newTimeoutFailure(TimeoutType.TIMEOUT_TYPE_SCHEDULE_TO_CLOSE, previousExecutionFailure)) : previousExecutionFailure;
                executionContext.callback(LocalActivityResult.failed(executionContext.getActivityId(), attemptTask.getAttempt(), retryState, failure, null));
                return true;
            }
            return false;
        }

        @Nonnull
        private RetryState shouldStillRetry(LocalActivityExecutionContext executionContext, PollActivityTaskQueueResponseOrBuilder activityTask, @Nullable Failure previousLocalExecutionFailure) {
            int currentAttempt = activityTask.getAttempt();
            if (LocalActivityWorker.isRetryPolicyNotSet(activityTask)) {
                return RetryState.RETRY_STATE_RETRY_POLICY_NOT_SET;
            }
            RetryOptions retryOptions = RetryOptionsUtils.toRetryOptions(activityTask.getRetryPolicy());
            if (previousLocalExecutionFailure != null && previousLocalExecutionFailure.hasApplicationFailureInfo() && RetryOptionsUtils.isNotRetryable(retryOptions, previousLocalExecutionFailure.getApplicationFailureInfo().getType())) {
                return RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE;
            }
            if (RetryOptionsUtils.areAttemptsReached(retryOptions, currentAttempt - 1)) {
                return RetryState.RETRY_STATE_MAXIMUM_ATTEMPTS_REACHED;
            }
            long sleepMillis = retryOptions.calculateSleepTime(currentAttempt);
            if (RetryOptionsUtils.isDeadlineReached(executionContext.getScheduleToCloseDeadline(), sleepMillis)) {
                return RetryState.RETRY_STATE_TIMEOUT;
            }
            return RetryState.RETRY_STATE_IN_PROGRESS;
        }
    }
}

