/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryRequest;
import io.temporal.api.workflowservice.v1.GetWorkflowExecutionHistoryResponse;
import io.temporal.client.EagerPaginator;
import io.temporal.internal.client.external.GenericWorkflowClient;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class GetWorkflowExecutionHistoryIterator
extends EagerPaginator<GetWorkflowExecutionHistoryResponse, HistoryEvent> {
    @Nonnull
    private final String namespace;
    @Nonnull
    private final WorkflowExecution workflowExecution;
    private final Integer pageSize;
    @Nonnull
    private final GenericWorkflowClient genericClient;

    public GetWorkflowExecutionHistoryIterator(@Nonnull String namespace, @Nonnull WorkflowExecution workflowExecution, @Nullable Integer pageSize, @Nonnull GenericWorkflowClient genericClient) {
        this.namespace = namespace;
        this.workflowExecution = workflowExecution;
        this.pageSize = pageSize;
        this.genericClient = genericClient;
    }

    @Override
    CompletableFuture<GetWorkflowExecutionHistoryResponse> performRequest(@Nonnull ByteString nextPageToken) {
        GetWorkflowExecutionHistoryRequest.Builder requestBuilder = GetWorkflowExecutionHistoryRequest.newBuilder().setNamespace(this.namespace).setExecution(this.workflowExecution).setNextPageToken(nextPageToken);
        if (this.pageSize != null) {
            requestBuilder.setMaximumPageSize(this.pageSize.intValue());
        }
        return this.genericClient.getWorkflowExecutionHistoryAsync(requestBuilder.build());
    }

    @Override
    ByteString getNextPageToken(GetWorkflowExecutionHistoryResponse response) {
        return response.getNextPageToken();
    }

    @Override
    List<HistoryEvent> toElements(GetWorkflowExecutionHistoryResponse response) {
        return response.getHistory().getEventsList();
    }
}

