/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.history;

import com.google.common.base.Preconditions;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.internal.history.MarkerUtils;
import java.util.HashMap;
import javax.annotation.Nullable;

public class VersionMarkerUtils {
    public static final String MARKER_NAME = "Version";
    public static final String MARKER_CHANGE_ID_KEY = "changeId";
    public static final String MARKER_VERSION_KEY = "version";

    @Nullable
    public static String tryGetChangeIdFromVersionMarkerEvent(HistoryEvent event) {
        if (!VersionMarkerUtils.hasVersionMarkerStructure(event)) {
            return null;
        }
        return VersionMarkerUtils.getChangeId(event.getMarkerRecordedEventAttributes());
    }

    public static boolean hasVersionMarkerStructure(HistoryEvent event) {
        return MarkerUtils.verifyMarkerName(event, MARKER_NAME);
    }

    @Nullable
    public static String getChangeId(MarkerRecordedEventAttributes markerAttributes) {
        return MarkerUtils.getValueFromMarker(markerAttributes, MARKER_CHANGE_ID_KEY, String.class);
    }

    @Nullable
    public static Integer getVersion(MarkerRecordedEventAttributes markerAttributes) {
        return MarkerUtils.getValueFromMarker(markerAttributes, MARKER_VERSION_KEY, Integer.class);
    }

    public static RecordMarkerCommandAttributes createMarkerAttributes(String changeId, Integer version) {
        Preconditions.checkNotNull((Object)version, (Object)MARKER_VERSION_KEY);
        HashMap<String, Payloads> details = new HashMap<String, Payloads>();
        details.put(MARKER_CHANGE_ID_KEY, DefaultDataConverter.STANDARD_INSTANCE.toPayloads(changeId).get());
        details.put(MARKER_VERSION_KEY, DefaultDataConverter.STANDARD_INSTANCE.toPayloads(version).get());
        return RecordMarkerCommandAttributes.newBuilder().setMarkerName(MARKER_NAME).putAllDetails(details).build();
    }
}

