/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.enums.v1.ParentClosePolicy;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.client.WorkflowException;
import io.temporal.common.RetryOptions;
import io.temporal.common.SearchAttributeUpdate;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.ChildWorkflowFailure;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.common.ActivityOptionUtils;
import io.temporal.internal.common.HeaderUtils;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.common.RetryOptionsUtils;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.common.SearchAttributesUtil;
import io.temporal.internal.replay.ChildWorkflowTaskFailedException;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.replay.WorkflowContext;
import io.temporal.internal.statemachines.ExecuteActivityParameters;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.LocalActivityCallback;
import io.temporal.internal.statemachines.StartChildWorkflowExecutionParameters;
import io.temporal.internal.statemachines.UnsupportedVersion;
import io.temporal.internal.sync.BaseRootWorkflowInboundCallsInterceptor;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.QueryDispatcher;
import io.temporal.internal.sync.SignalDispatcher;
import io.temporal.internal.sync.SignalHandlerInfo;
import io.temporal.internal.sync.UpdateDispatcher;
import io.temporal.internal.sync.UpdateHandlerInfo;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.payload.context.ActivitySerializationContext;
import io.temporal.payload.context.WorkflowSerializationContext;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.UpdateInfo;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowThreadLocal;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncWorkflowContext
implements WorkflowContext,
WorkflowOutboundCallsInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SyncWorkflowContext.class);
    private final String namespace;
    private final WorkflowExecution workflowExecution;
    private final WorkflowImplementationOptions workflowImplementationOptions;
    private final DataConverter dataConverter;
    private final DataConverter dataConverterWithCurrentWorkflowContext;
    private final List<ContextPropagator> contextPropagators;
    private final SignalDispatcher signalDispatcher;
    private final QueryDispatcher queryDispatcher;
    private final UpdateDispatcher updateDispatcher;
    private ReplayWorkflowContext replayContext;
    private DeterministicRunner runner;
    private WorkflowInboundCallsInterceptor headInboundInterceptor;
    private WorkflowOutboundCallsInterceptor headOutboundInterceptor;
    private ActivityOptions defaultActivityOptions = null;
    private Map<String, ActivityOptions> activityOptionsMap;
    private LocalActivityOptions defaultLocalActivityOptions = null;
    private Map<String, LocalActivityOptions> localActivityOptionsMap;
    private boolean readOnly = false;
    private final WorkflowThreadLocal<UpdateInfo> currentUpdateInfo = new WorkflowThreadLocal();
    private Map<String, UpdateHandlerInfo> runningUpdateHandlers = new HashMap<String, UpdateHandlerInfo>();
    private Map<Long, SignalHandlerInfo> runningSignalHandlers = new HashMap<Long, SignalHandlerInfo>();

    public SyncWorkflowContext(@Nonnull String namespace, @Nonnull WorkflowExecution workflowExecution, SignalDispatcher signalDispatcher, QueryDispatcher queryDispatcher, UpdateDispatcher updateDispatcher, @Nullable WorkflowImplementationOptions workflowImplementationOptions, DataConverter dataConverter, List<ContextPropagator> contextPropagators) {
        this.namespace = namespace;
        this.workflowExecution = workflowExecution;
        this.dataConverter = dataConverter;
        this.dataConverterWithCurrentWorkflowContext = dataConverter.withContext(new WorkflowSerializationContext(namespace, workflowExecution.getWorkflowId()));
        this.contextPropagators = contextPropagators;
        this.signalDispatcher = signalDispatcher;
        this.queryDispatcher = queryDispatcher;
        this.updateDispatcher = updateDispatcher;
        if (workflowImplementationOptions != null) {
            this.defaultActivityOptions = workflowImplementationOptions.getDefaultActivityOptions();
            this.activityOptionsMap = new HashMap<String, ActivityOptions>(workflowImplementationOptions.getActivityOptions());
            this.defaultLocalActivityOptions = workflowImplementationOptions.getDefaultLocalActivityOptions();
            this.localActivityOptionsMap = new HashMap<String, LocalActivityOptions>(workflowImplementationOptions.getLocalActivityOptions());
        }
        this.workflowImplementationOptions = workflowImplementationOptions == null ? WorkflowImplementationOptions.getDefaultInstance() : workflowImplementationOptions;
        this.headInboundInterceptor = new InitialWorkflowInboundCallsInterceptor(this);
        this.headOutboundInterceptor = this;
    }

    public void setReplayContext(ReplayWorkflowContext context) {
        this.replayContext = context;
    }

    public void setRunner(DeterministicRunner runner) {
        this.runner = runner;
    }

    public DeterministicRunner getRunner() {
        return this.runner;
    }

    public WorkflowOutboundCallsInterceptor getWorkflowOutboundInterceptor() {
        return this.headOutboundInterceptor;
    }

    public WorkflowInboundCallsInterceptor getWorkflowInboundInterceptor() {
        return this.headInboundInterceptor;
    }

    public void initHeadOutboundCallsInterceptor(WorkflowOutboundCallsInterceptor head) {
        this.headOutboundInterceptor = head;
    }

    public void initHeadInboundCallsInterceptor(WorkflowInboundCallsInterceptor head) {
        this.headInboundInterceptor = head;
        this.signalDispatcher.setInboundCallsInterceptor(head);
        this.queryDispatcher.setInboundCallsInterceptor(head);
        this.updateDispatcher.setInboundCallsInterceptor(head);
    }

    public ActivityOptions getDefaultActivityOptions() {
        return this.defaultActivityOptions;
    }

    @Nonnull
    public Map<String, ActivityOptions> getActivityOptions() {
        return this.activityOptionsMap != null ? Collections.unmodifiableMap(this.activityOptionsMap) : Collections.emptyMap();
    }

    public LocalActivityOptions getDefaultLocalActivityOptions() {
        return this.defaultLocalActivityOptions;
    }

    @Nonnull
    public Map<String, LocalActivityOptions> getLocalActivityOptions() {
        return this.localActivityOptionsMap != null ? Collections.unmodifiableMap(this.localActivityOptionsMap) : Collections.emptyMap();
    }

    public void setDefaultActivityOptions(ActivityOptions defaultActivityOptions) {
        this.defaultActivityOptions = this.defaultActivityOptions == null ? defaultActivityOptions : this.defaultActivityOptions.toBuilder().mergeActivityOptions(defaultActivityOptions).build();
    }

    public void applyActivityOptions(Map<String, ActivityOptions> activityTypeToOption) {
        Objects.requireNonNull(activityTypeToOption);
        if (this.activityOptionsMap == null) {
            this.activityOptionsMap = new HashMap<String, ActivityOptions>(activityTypeToOption);
            return;
        }
        ActivityOptionUtils.mergePredefinedActivityOptions(this.activityOptionsMap, activityTypeToOption);
    }

    public void setDefaultLocalActivityOptions(LocalActivityOptions defaultLocalActivityOptions) {
        this.defaultLocalActivityOptions = this.defaultLocalActivityOptions == null ? defaultLocalActivityOptions : this.defaultLocalActivityOptions.toBuilder().mergeActivityOptions(defaultLocalActivityOptions).build();
    }

    public void applyLocalActivityOptions(Map<String, LocalActivityOptions> activityTypeToOption) {
        Objects.requireNonNull(activityTypeToOption);
        if (this.localActivityOptionsMap == null) {
            this.localActivityOptionsMap = new HashMap<String, LocalActivityOptions>(activityTypeToOption);
            return;
        }
        ActivityOptionUtils.mergePredefinedLocalActivityOptions(this.localActivityOptionsMap, activityTypeToOption);
    }

    public <T> WorkflowOutboundCallsInterceptor.ActivityOutput<T> executeActivity(WorkflowOutboundCallsInterceptor.ActivityInput<T> input) {
        ActivitySerializationContext serializationContext = new ActivitySerializationContext(this.replayContext.getNamespace(), this.replayContext.getWorkflowId(), this.replayContext.getWorkflowType().getName(), input.getActivityName(), (String)MoreObjects.firstNonNull((Object)input.getOptions().getTaskQueue(), (Object)this.replayContext.getTaskQueue()), false);
        DataConverter dataConverterWithActivityContext = this.dataConverter.withContext(serializationContext);
        Optional<Payloads> args = dataConverterWithActivityContext.toPayloads(input.getArgs());
        WorkflowOutboundCallsInterceptor.ActivityOutput<Optional<Payloads>> output = this.executeActivityOnce(input.getActivityName(), input.getOptions(), input.getHeader(), args);
        return new WorkflowOutboundCallsInterceptor.ActivityOutput<Object>(output.getActivityId(), output.getResult().handle((r, f) -> {
            if (f == null) {
                return input.getResultType() != Void.TYPE ? dataConverterWithActivityContext.fromPayloads(0, (Optional<Payloads>)r, input.getResultClass(), input.getResultType()) : null;
            }
            throw dataConverterWithActivityContext.failureToException(((FailureWrapperException)f).getFailure());
        }));
    }

    private WorkflowOutboundCallsInterceptor.ActivityOutput<Optional<Payloads>> executeActivityOnce(String activityTypeName, ActivityOptions options, io.temporal.common.interceptors.Header header, Optional<Payloads> input) {
        ExecuteActivityParameters params = this.constructExecuteActivityParameters(activityTypeName, options, header, input);
        ActivityCallback callback = new ActivityCallback();
        ReplayWorkflowContext.ScheduleActivityTaskOutput activityOutput = this.replayContext.scheduleActivityTask(params, callback::invoke);
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            activityOutput.getCancellationHandle().apply(new CanceledFailure((String)reason));
            return null;
        });
        return new WorkflowOutboundCallsInterceptor.ActivityOutput<Optional<Payloads>>(activityOutput.getActivityId(), callback.result);
    }

    public void handleInterceptedSignal(WorkflowInboundCallsInterceptor.SignalInput input) {
        this.signalDispatcher.handleInterceptedSignal(input);
    }

    public void handleSignal(String signalName, Optional<Payloads> input, long eventId, io.temporal.common.interceptors.Header header) {
        this.signalDispatcher.handleSignal(signalName, input, eventId, header);
    }

    public void handleValidateUpdate(String updateName, String updateId, Optional<Payloads> input, long eventId, io.temporal.common.interceptors.Header header) {
        this.updateDispatcher.handleValidateUpdate(updateName, updateId, input, eventId, header);
    }

    public Optional<Payloads> handleExecuteUpdate(String updateName, String updateId, Optional<Payloads> input, long eventId, io.temporal.common.interceptors.Header header) {
        return this.updateDispatcher.handleExecuteUpdate(updateName, updateId, input, eventId, header);
    }

    public void handleInterceptedValidateUpdate(WorkflowInboundCallsInterceptor.UpdateInput input) {
        this.updateDispatcher.handleInterceptedValidateUpdate(input);
    }

    public WorkflowInboundCallsInterceptor.UpdateOutput handleInterceptedExecuteUpdate(WorkflowInboundCallsInterceptor.UpdateInput input) {
        return this.updateDispatcher.handleInterceptedExecuteUpdate(input);
    }

    public WorkflowInboundCallsInterceptor.QueryOutput handleInterceptedQuery(WorkflowInboundCallsInterceptor.QueryInput input) {
        return this.queryDispatcher.handleInterceptedQuery(input);
    }

    public Optional<Payloads> handleQuery(String queryName, io.temporal.common.interceptors.Header header, Optional<Payloads> input) {
        return this.queryDispatcher.handleQuery(queryName, header, input);
    }

    public boolean isEveryHandlerFinished() {
        return this.updateDispatcher.getRunningUpdateHandlers().isEmpty() && this.signalDispatcher.getRunningSignalHandlers().isEmpty();
    }

    @Override
    public <R> WorkflowOutboundCallsInterceptor.LocalActivityOutput<R> executeLocalActivity(WorkflowOutboundCallsInterceptor.LocalActivityInput<R> input) {
        ActivitySerializationContext serializationContext = new ActivitySerializationContext(this.replayContext.getNamespace(), this.replayContext.getWorkflowId(), this.replayContext.getWorkflowType().getName(), input.getActivityName(), this.replayContext.getTaskQueue(), true);
        DataConverter dataConverterWithActivityContext = this.dataConverter.withContext(serializationContext);
        Optional<Payloads> payloads = dataConverterWithActivityContext.toPayloads(input.getArgs());
        long originalScheduledTime = System.currentTimeMillis();
        CompletablePromise<Optional<Payloads>> serializedResult = WorkflowInternal.newCompletablePromise();
        this.executeLocalActivityOverLocalRetryThreshold(input.getActivityName(), input.getOptions(), input.getHeader(), payloads, originalScheduledTime, 1, null, serializedResult);
        Promise<Object> result = serializedResult.handle((r, f) -> {
            if (f == null) {
                return input.getResultClass() != Void.TYPE ? dataConverterWithActivityContext.fromPayloads(0, (Optional<Payloads>)r, input.getResultClass(), input.getResultType()) : null;
            }
            throw dataConverterWithActivityContext.failureToException(((LocalActivityCallback.LocalActivityFailedException)f).getFailure());
        });
        return new WorkflowOutboundCallsInterceptor.LocalActivityOutput<Object>(result);
    }

    public void executeLocalActivityOverLocalRetryThreshold(String activityTypeName, LocalActivityOptions options, io.temporal.common.interceptors.Header header, Optional<Payloads> input, long originalScheduledTime, int attempt, @Nullable Failure previousExecutionFailure, CompletablePromise<Optional<Payloads>> result) {
        CompletablePromise<Optional<Payloads>> localExecutionResult = this.executeLocalActivityLocally(activityTypeName, options, header, input, originalScheduledTime, attempt, previousExecutionFailure);
        localExecutionResult.handle((r, e) -> {
            if (e == null) {
                result.complete((Optional<Payloads>)r);
            } else if (e instanceof LocalActivityCallback.LocalActivityFailedException) {
                LocalActivityCallback.LocalActivityFailedException laException = (LocalActivityCallback.LocalActivityFailedException)e;
                Duration backoff = laException.getBackoff();
                if (backoff != null) {
                    WorkflowInternal.newTimer(backoff).thenApply(unused -> {
                        this.executeLocalActivityOverLocalRetryThreshold(activityTypeName, options, header, input, originalScheduledTime, laException.getLastAttempt() + 1, laException.getFailure(), result);
                        return null;
                    });
                } else {
                    result.completeExceptionally(laException);
                }
            } else {
                String exceptionMessage = String.format("[BUG] Local Activity State Machine callback for activityType %s returned unexpected exception", activityTypeName);
                log.warn(exceptionMessage, (Throwable)e);
                this.replayContext.failWorkflowTask(new IllegalStateException(exceptionMessage, (Throwable)e));
            }
            return null;
        });
    }

    private CompletablePromise<Optional<Payloads>> executeLocalActivityLocally(String activityTypeName, LocalActivityOptions options, io.temporal.common.interceptors.Header header, Optional<Payloads> input, long originalScheduledTime, int attempt, @Nullable Failure previousExecutionFailure) {
        LocalActivityCallbackImpl callback = new LocalActivityCallbackImpl();
        ExecuteLocalActivityParameters params = this.constructExecuteLocalActivityParameters(activityTypeName, options, header, input, attempt, originalScheduledTime, previousExecutionFailure);
        Functions.Proc cancellationCallback = this.replayContext.scheduleLocalActivityTask(params, callback);
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.apply();
            return null;
        });
        return callback.result;
    }

    private ExecuteActivityParameters constructExecuteActivityParameters(String name, ActivityOptions options, io.temporal.common.interceptors.Header header, Optional<Payloads> input) {
        List<ContextPropagator> propagators;
        String taskQueue = options.getTaskQueue();
        if (taskQueue == null) {
            taskQueue = this.replayContext.getTaskQueue();
        }
        ScheduleActivityTaskCommandAttributes.Builder attributes = ScheduleActivityTaskCommandAttributes.newBuilder().setActivityType(ActivityType.newBuilder().setName(name)).setTaskQueue(TaskQueue.newBuilder().setName(taskQueue)).setScheduleToStartTimeout(ProtobufTimeUtils.toProtoDuration(options.getScheduleToStartTimeout())).setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration(options.getStartToCloseTimeout())).setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration(options.getScheduleToCloseTimeout())).setHeartbeatTimeout(ProtobufTimeUtils.toProtoDuration(options.getHeartbeatTimeout())).setRequestEagerExecution(!options.isEagerExecutionDisabled() && Objects.equals(taskQueue, this.replayContext.getTaskQueue()));
        input.ifPresent(arg_0 -> ((ScheduleActivityTaskCommandAttributes.Builder)attributes).setInput(arg_0));
        RetryOptions retryOptions = options.getRetryOptions();
        if (retryOptions != null) {
            attributes.setRetryPolicy(RetryOptionsUtils.toRetryPolicy(retryOptions));
        }
        if ((propagators = options.getContextPropagators()) == null) {
            propagators = this.contextPropagators;
        }
        Header grpcHeader = HeaderUtils.toHeaderGrpc(header, SyncWorkflowContext.extractContextsAndConvertToBytes(propagators));
        attributes.setHeader(grpcHeader);
        if (options.getVersioningIntent() != null) {
            attributes.setUseWorkflowBuildId(options.getVersioningIntent().determineUseCompatibleFlag(this.replayContext.getTaskQueue().equals(options.getTaskQueue())));
        }
        return new ExecuteActivityParameters(attributes, options.getCancellationType());
    }

    private ExecuteLocalActivityParameters constructExecuteLocalActivityParameters(String name, LocalActivityOptions options, io.temporal.common.interceptors.Header header, Optional<Payloads> input, int attempt, long originalScheduledTime, @Nullable Failure previousExecutionFailure) {
        Duration startToCloseTimeout;
        options = LocalActivityOptions.newBuilder(options).validateAndBuildWithDefaults();
        PollActivityTaskQueueResponse.Builder activityTask = PollActivityTaskQueueResponse.newBuilder().setActivityId(this.replayContext.randomUUID().toString()).setWorkflowNamespace(this.replayContext.getNamespace()).setWorkflowType(this.replayContext.getWorkflowType()).setWorkflowExecution(this.replayContext.getWorkflowExecution()).setScheduledTime(ProtobufTimeUtils.toProtoTimestamp(Instant.ofEpochMilli(originalScheduledTime))).setActivityType(ActivityType.newBuilder().setName(name)).setAttempt(attempt);
        Duration scheduleToCloseTimeout = options.getScheduleToCloseTimeout();
        if (scheduleToCloseTimeout != null) {
            activityTask.setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration(scheduleToCloseTimeout));
        }
        if ((startToCloseTimeout = options.getStartToCloseTimeout()) != null) {
            activityTask.setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration(startToCloseTimeout));
        }
        Header grpcHeader = HeaderUtils.toHeaderGrpc(header, SyncWorkflowContext.extractContextsAndConvertToBytes(this.contextPropagators));
        activityTask.setHeader(grpcHeader);
        input.ifPresent(arg_0 -> ((PollActivityTaskQueueResponse.Builder)activityTask).setInput(arg_0));
        RetryOptions retryOptions = options.getRetryOptions();
        activityTask.setRetryPolicy(RetryOptionsUtils.toRetryPolicy(RetryOptions.newBuilder(retryOptions).validateBuildWithDefaults()));
        Duration localRetryThreshold = options.getLocalRetryThreshold();
        if (localRetryThreshold == null) {
            localRetryThreshold = this.replayContext.getWorkflowTaskTimeout().multipliedBy(3L);
        }
        return new ExecuteLocalActivityParameters(activityTask, options.getScheduleToStartTimeout(), originalScheduledTime, previousExecutionFailure, options.isDoNotIncludeArgumentsIntoMarker(), localRetryThreshold);
    }

    @Override
    public <R> WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> executeChildWorkflow(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        if (CancellationScope.current().isCancelRequested()) {
            CanceledFailure canceledFailure = new CanceledFailure("execute called from a canceled scope");
            return new WorkflowOutboundCallsInterceptor.ChildWorkflowOutput(Workflow.newFailedPromise(canceledFailure), Workflow.newFailedPromise(canceledFailure));
        }
        CompletablePromise<WorkflowExecution> executionPromise = Workflow.newPromise();
        CompletablePromise resultPromise = Workflow.newPromise();
        DataConverter dataConverterWithChildWorkflowContext = this.dataConverter.withContext(new WorkflowSerializationContext(this.replayContext.getNamespace(), input.getWorkflowId()));
        Optional<Payloads> payloads = dataConverterWithChildWorkflowContext.toPayloads(input.getArgs());
        Memo memo = input.getOptions().getMemo() != null ? Memo.newBuilder().putAllFields(HeaderUtils.intoPayloadMap(dataConverterWithChildWorkflowContext, input.getOptions().getMemo())).build() : null;
        StartChildWorkflowExecutionParameters parameters = this.createChildWorkflowParameters(input.getWorkflowId(), input.getWorkflowType(), input.getOptions(), input.getHeader(), payloads, memo);
        Functions.Proc1<Exception> cancellationCallback = this.replayContext.startChildWorkflow(parameters, (execution, failure) -> {
            if (failure != null) {
                this.runner.executeInWorkflowThread("child workflow start failed callback", () -> executionPromise.completeExceptionally(SyncWorkflowContext.mapChildWorkflowException(failure, dataConverterWithChildWorkflowContext)));
            } else {
                this.runner.executeInWorkflowThread("child workflow started callback", () -> executionPromise.complete((WorkflowExecution)execution));
            }
        }, (result, failure) -> {
            if (failure != null) {
                this.runner.executeInWorkflowThread("child workflow failure callback", () -> resultPromise.completeExceptionally(SyncWorkflowContext.mapChildWorkflowException(failure, dataConverterWithChildWorkflowContext)));
            } else {
                this.runner.executeInWorkflowThread("child workflow completion callback", () -> resultPromise.complete(result));
            }
        });
        AtomicBoolean callbackCalled = new AtomicBoolean();
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            if (!callbackCalled.getAndSet(true)) {
                cancellationCallback.apply(new CanceledFailure((String)reason));
            }
            return null;
        });
        Promise<Object> result2 = resultPromise.thenApply(b -> dataConverterWithChildWorkflowContext.fromPayloads(0, (Optional<Payloads>)b, input.getResultClass(), input.getResultType()));
        return new WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<Object>(result2, executionPromise);
    }

    private StartChildWorkflowExecutionParameters createChildWorkflowParameters(String workflowId, String name, ChildWorkflowOptions options, io.temporal.common.interceptors.Header header, Optional<Payloads> input, @Nullable Memo memo) {
        Map<String, Object> searchAttributes;
        RetryOptions retryOptions;
        StartChildWorkflowExecutionCommandAttributes.Builder attributes = StartChildWorkflowExecutionCommandAttributes.newBuilder().setWorkflowType(WorkflowType.newBuilder().setName(name).build());
        attributes.setWorkflowId(workflowId);
        attributes.setNamespace(OptionsUtils.safeGet((String)options.getNamespace()));
        input.ifPresent(arg_0 -> ((StartChildWorkflowExecutionCommandAttributes.Builder)attributes).setInput(arg_0));
        attributes.setWorkflowRunTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowRunTimeout()));
        attributes.setWorkflowExecutionTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowExecutionTimeout()));
        attributes.setWorkflowTaskTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowTaskTimeout()));
        String taskQueue = options.getTaskQueue();
        if (taskQueue != null) {
            attributes.setTaskQueue(TaskQueue.newBuilder().setName(taskQueue));
        }
        if (options.getWorkflowIdReusePolicy() != null) {
            attributes.setWorkflowIdReusePolicy(options.getWorkflowIdReusePolicy());
        }
        if ((retryOptions = options.getRetryOptions()) != null) {
            attributes.setRetryPolicy(RetryOptionsUtils.toRetryPolicy(retryOptions));
        }
        attributes.setCronSchedule(OptionsUtils.safeGet((String)options.getCronSchedule()));
        if (memo != null) {
            attributes.setMemo(memo);
        }
        if ((searchAttributes = options.getSearchAttributes()) != null && !searchAttributes.isEmpty()) {
            if (options.getTypedSearchAttributes() != null) {
                throw new IllegalArgumentException("Cannot have both typed search attributes and search attributes");
            }
            attributes.setSearchAttributes(SearchAttributesUtil.encode(searchAttributes));
        } else if (options.getTypedSearchAttributes() != null) {
            attributes.setSearchAttributes(SearchAttributesUtil.encodeTyped(options.getTypedSearchAttributes()));
        }
        List<ContextPropagator> propagators = options.getContextPropagators();
        if (propagators == null) {
            propagators = this.contextPropagators;
        }
        Header grpcHeader = HeaderUtils.toHeaderGrpc(header, SyncWorkflowContext.extractContextsAndConvertToBytes(propagators));
        attributes.setHeader(grpcHeader);
        ParentClosePolicy parentClosePolicy = options.getParentClosePolicy();
        if (parentClosePolicy != null) {
            attributes.setParentClosePolicy(parentClosePolicy);
        }
        if (options.getVersioningIntent() != null) {
            attributes.setInheritBuildId(options.getVersioningIntent().determineUseCompatibleFlag(this.replayContext.getTaskQueue().equals(options.getTaskQueue())));
        }
        return new StartChildWorkflowExecutionParameters(attributes, options.getCancellationType());
    }

    private static io.temporal.common.interceptors.Header extractContextsAndConvertToBytes(List<ContextPropagator> contextPropagators) {
        if (contextPropagators == null) {
            return null;
        }
        HashMap<String, Payload> result = new HashMap<String, Payload>();
        for (ContextPropagator propagator : contextPropagators) {
            result.putAll(propagator.serializeContext(propagator.getCurrentContext()));
        }
        return new io.temporal.common.interceptors.Header(result);
    }

    private static RuntimeException mapChildWorkflowException(Exception failure, DataConverter dataConverterWithChildWorkflowContext) {
        if (failure == null) {
            return null;
        }
        if (failure instanceof TemporalFailure) {
            ((TemporalFailure)failure).setDataConverter(dataConverterWithChildWorkflowContext);
        }
        if (failure instanceof CanceledFailure) {
            return (CanceledFailure)failure;
        }
        if (failure instanceof WorkflowException) {
            return (RuntimeException)failure;
        }
        if (failure instanceof ChildWorkflowFailure) {
            return (ChildWorkflowFailure)failure;
        }
        if (!(failure instanceof ChildWorkflowTaskFailedException)) {
            return new IllegalArgumentException("Unexpected exception type: ", failure);
        }
        ChildWorkflowTaskFailedException taskFailed = (ChildWorkflowTaskFailedException)failure;
        TemporalFailure cause = dataConverterWithChildWorkflowContext.failureToException(taskFailed.getOriginalCauseFailure());
        ChildWorkflowFailure exception = taskFailed.getException();
        return new ChildWorkflowFailure(exception.getInitiatedEventId(), exception.getStartedEventId(), exception.getWorkflowType(), exception.getExecution(), exception.getNamespace(), exception.getRetryState(), cause);
    }

    @Override
    public Promise<Void> newTimer(Duration delay) {
        CompletablePromise<Void> p = Workflow.newPromise();
        Functions.Proc1<RuntimeException> cancellationHandler = this.replayContext.newTimer(delay, e -> this.runner.executeInWorkflowThread("timer-callback", () -> {
            if (e == null) {
                p.complete(null);
            } else {
                p.completeExceptionally((RuntimeException)e);
            }
        }));
        CancellationScope.current().getCancellationRequest().thenApply(r -> {
            cancellationHandler.apply(new CanceledFailure((String)r));
            return r;
        });
        return p;
    }

    @Override
    public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        try {
            CompletablePromise result = Workflow.newPromise();
            this.replayContext.sideEffect(() -> {
                try {
                    this.readOnly = true;
                    Object r = func.apply();
                    Optional<Payloads> optional = this.dataConverterWithCurrentWorkflowContext.toPayloads(r);
                    return optional;
                }
                finally {
                    this.readOnly = false;
                }
            }, p -> this.runner.executeInWorkflowThread("side-effect-callback", () -> result.complete(Objects.requireNonNull(p))));
            return this.dataConverterWithCurrentWorkflowContext.fromPayloads(0, (Optional)result.get(), resultClass, resultType);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        try {
            return this.mutableSideEffectImpl(id, resultClass, resultType, updated, func);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private <R> R mutableSideEffectImpl(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        CompletablePromise result = Workflow.newPromise();
        AtomicReference unserializedResult = new AtomicReference();
        this.replayContext.mutableSideEffect(id, storedBinary -> {
            Optional<Object> stored = storedBinary.map(b -> this.dataConverterWithCurrentWorkflowContext.fromPayloads(0, Optional.of(b), resultClass, resultType));
            try {
                this.readOnly = true;
                Object funcResult = Objects.requireNonNull(func.apply(), "mutableSideEffect function returned null");
                if (!stored.isPresent() || updated.test(stored.get(), funcResult)) {
                    unserializedResult.set(funcResult);
                    Optional<Payloads> optional = this.dataConverterWithCurrentWorkflowContext.toPayloads(funcResult);
                    return optional;
                }
                Optional optional = Optional.empty();
                return optional;
            }
            finally {
                this.readOnly = false;
            }
        }, p -> this.runner.executeInWorkflowThread("mutable-side-effect-callback", () -> result.complete(Objects.requireNonNull(p))));
        if (!((Optional)result.get()).isPresent()) {
            throw new IllegalArgumentException("No value found for mutableSideEffectId=" + id);
        }
        Object unserialized = unserializedResult.get();
        if (unserialized != null) {
            return (R)unserialized;
        }
        return this.dataConverterWithCurrentWorkflowContext.fromPayloads(0, (Optional)result.get(), resultClass, resultType);
    }

    @Override
    public int getVersion(String changeId, int minSupported, int maxSupported) {
        CompletablePromise result = Workflow.newPromise();
        boolean markerExists = this.replayContext.getVersion(changeId, minSupported, maxSupported, (v, e) -> this.runner.executeInWorkflowThread("version-callback", () -> {
            if (v != null) {
                result.complete(v);
            } else {
                result.completeExceptionally((RuntimeException)e);
            }
        }));
        if (this.replayContext.isReplaying() && !markerExists && this.replayContext.tryUseSdkFlag(SdkFlag.SKIP_YIELD_ON_DEFAULT_VERSION) && minSupported == -1) {
            return -1;
        }
        try {
            return (Integer)result.get();
        }
        catch (UnsupportedVersion.UnsupportedVersionException ex) {
            throw new UnsupportedVersion(ex);
        }
    }

    @Override
    public void registerQuery(WorkflowOutboundCallsInterceptor.RegisterQueryInput request) {
        this.queryDispatcher.registerQueryHandlers(request);
    }

    @Override
    public void registerSignalHandlers(WorkflowOutboundCallsInterceptor.RegisterSignalHandlersInput input) {
        this.signalDispatcher.registerSignalHandlers(input);
    }

    @Override
    public void registerUpdateHandlers(WorkflowOutboundCallsInterceptor.RegisterUpdateHandlersInput input) {
        this.updateDispatcher.registerUpdateHandlers(input);
    }

    @Override
    public void registerDynamicSignalHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicSignalHandlerInput input) {
        this.signalDispatcher.registerDynamicSignalHandler(input);
    }

    @Override
    public void registerDynamicQueryHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicQueryHandlerInput input) {
        this.queryDispatcher.registerDynamicQueryHandler(input);
    }

    @Override
    public void registerDynamicUpdateHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicUpdateHandlerInput input) {
        this.updateDispatcher.registerDynamicUpdateHandler(input);
    }

    @Override
    public UUID randomUUID() {
        return this.replayContext.randomUUID();
    }

    @Override
    public Random newRandom() {
        return this.replayContext.newRandom();
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public DataConverter getDataConverterWithCurrentWorkflowContext() {
        return this.dataConverterWithCurrentWorkflowContext;
    }

    boolean isReplaying() {
        return this.replayContext.isReplaying();
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Map<Long, SignalHandlerInfo> getRunningSignalHandlers() {
        return this.signalDispatcher.getRunningSignalHandlers();
    }

    @Override
    public Map<String, UpdateHandlerInfo> getRunningUpdateHandlers() {
        return this.updateDispatcher.getRunningUpdateHandlers();
    }

    @Override
    public ReplayWorkflowContext getReplayContext() {
        return this.replayContext;
    }

    @Override
    public WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalWorkflow(WorkflowOutboundCallsInterceptor.SignalExternalInput input) {
        WorkflowExecution childExecution = input.getExecution();
        DataConverter dataConverterWithChildWorkflowContext = this.dataConverter.withContext(new WorkflowSerializationContext(this.replayContext.getNamespace(), childExecution.getWorkflowId()));
        SignalExternalWorkflowExecutionCommandAttributes.Builder attributes = SignalExternalWorkflowExecutionCommandAttributes.newBuilder();
        attributes.setSignalName(input.getSignalName());
        attributes.setExecution(childExecution);
        attributes.setHeader(HeaderUtils.toHeaderGrpc(input.getHeader(), null));
        Optional<Payloads> payloads = dataConverterWithChildWorkflowContext.toPayloads(input.getArgs());
        payloads.ifPresent(arg_0 -> ((SignalExternalWorkflowExecutionCommandAttributes.Builder)attributes).setInput(arg_0));
        CompletablePromise<Void> result = Workflow.newPromise();
        Functions.Proc1<Exception> cancellationCallback = this.replayContext.signalExternalWorkflowExecution(attributes, (output, failure) -> {
            if (failure != null) {
                this.runner.executeInWorkflowThread("child workflow failure callback", () -> result.completeExceptionally(dataConverterWithChildWorkflowContext.failureToException((Failure)failure)));
            } else {
                this.runner.executeInWorkflowThread("child workflow completion callback", () -> result.complete((Void)output));
            }
        });
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.apply(new CanceledFailure((String)reason));
            return null;
        });
        return new WorkflowOutboundCallsInterceptor.SignalExternalOutput(result);
    }

    @Override
    public void sleep(Duration duration) {
        this.newTimer(duration).get();
    }

    @Override
    public boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) {
        Promise<Void> timer = this.newTimer(timeout);
        WorkflowThread.await(reason, () -> timer.isCompleted() || (Boolean)unblockCondition.get() != false);
        return !timer.isCompleted();
    }

    @Override
    public void await(String reason, Supplier<Boolean> unblockCondition) {
        WorkflowThread.await(reason, unblockCondition);
    }

    @Override
    public void continueAsNew(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
        ContinueAsNewOptions options;
        ContinueAsNewWorkflowExecutionCommandAttributes.Builder attributes = ContinueAsNewWorkflowExecutionCommandAttributes.newBuilder();
        String workflowType = input.getWorkflowType();
        if (workflowType != null) {
            attributes.setWorkflowType(WorkflowType.newBuilder().setName(workflowType));
        }
        if ((options = input.getOptions()) != null) {
            if (options.getWorkflowRunTimeout() != null) {
                attributes.setWorkflowRunTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowRunTimeout()));
            }
            if (options.getWorkflowTaskTimeout() != null) {
                attributes.setWorkflowTaskTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowTaskTimeout()));
            }
            if (options.getTaskQueue() != null && !options.getTaskQueue().isEmpty()) {
                attributes.setTaskQueue(TaskQueue.newBuilder().setName(options.getTaskQueue()));
            }
            if (options.getRetryOptions() != null) {
                attributes.setRetryPolicy(RetryOptionsUtils.toRetryPolicy(options.getRetryOptions()));
            } else if (this.replayContext.getRetryOptions() != null) {
                attributes.setRetryPolicy(RetryOptionsUtils.toRetryPolicy(this.replayContext.getRetryOptions()));
            }
            Map<String, Object> searchAttributes = options.getSearchAttributes();
            if (searchAttributes != null && !searchAttributes.isEmpty()) {
                if (options.getTypedSearchAttributes() != null) {
                    throw new IllegalArgumentException("Cannot have typed search attributes and search attributes");
                }
                attributes.setSearchAttributes(SearchAttributesUtil.encode(searchAttributes));
            } else if (options.getTypedSearchAttributes() != null) {
                attributes.setSearchAttributes(SearchAttributesUtil.encodeTyped(options.getTypedSearchAttributes()));
            }
            Map<String, Object> memo = options.getMemo();
            if (memo != null) {
                attributes.setMemo(Memo.newBuilder().putAllFields(HeaderUtils.intoPayloadMap(this.dataConverterWithCurrentWorkflowContext, memo)));
            }
            if (options.getVersioningIntent() != null) {
                attributes.setInheritBuildId(options.getVersioningIntent().determineUseCompatibleFlag(this.replayContext.getTaskQueue().equals(options.getTaskQueue())));
            }
        } else if (this.replayContext.getRetryOptions() != null) {
            attributes.setRetryPolicy(RetryOptionsUtils.toRetryPolicy(this.replayContext.getRetryOptions()));
        }
        List<ContextPropagator> propagators = options != null && options.getContextPropagators() != null ? options.getContextPropagators() : this.contextPropagators;
        Header grpcHeader = HeaderUtils.toHeaderGrpc(input.getHeader(), SyncWorkflowContext.extractContextsAndConvertToBytes(propagators));
        attributes.setHeader(grpcHeader);
        Optional<Payloads> payloads = this.dataConverterWithCurrentWorkflowContext.toPayloads(input.getArgs());
        payloads.ifPresent(arg_0 -> ((ContinueAsNewWorkflowExecutionCommandAttributes.Builder)attributes).setInput(arg_0));
        this.replayContext.continueAsNewOnCompletion(attributes.build());
        WorkflowThread.exit();
    }

    @Override
    public WorkflowOutboundCallsInterceptor.CancelWorkflowOutput cancelWorkflow(WorkflowOutboundCallsInterceptor.CancelWorkflowInput input) {
        CompletablePromise<Void> result = Workflow.newPromise();
        this.replayContext.requestCancelExternalWorkflowExecution(input.getExecution(), (r, exception) -> {
            if (exception == null) {
                result.complete(null);
            } else {
                result.completeExceptionally((RuntimeException)exception);
            }
        });
        return new WorkflowOutboundCallsInterceptor.CancelWorkflowOutput(result);
    }

    public Scope getMetricsScope() {
        return this.replayContext.getMetricsScope();
    }

    public boolean isLoggingEnabledInReplay() {
        return this.replayContext.getEnableLoggingInReplay();
    }

    @Override
    public void upsertSearchAttributes(Map<String, ?> searchAttributes) {
        Preconditions.checkArgument((searchAttributes != null ? 1 : 0) != 0, (Object)"null search attributes");
        Preconditions.checkArgument((!searchAttributes.isEmpty() ? 1 : 0) != 0, (Object)"empty search attributes");
        SearchAttributes attr = SearchAttributesUtil.encode(searchAttributes);
        this.replayContext.upsertSearchAttributes(attr);
    }

    @Override
    public void upsertTypedSearchAttributes(SearchAttributeUpdate<?> ... searchAttributeUpdates) {
        SearchAttributes attr = SearchAttributesUtil.encodeTypedUpdates(searchAttributeUpdates);
        this.replayContext.upsertSearchAttributes(attr);
    }

    @Nonnull
    public Object newWorkflowMethodThreadIntercepted(Runnable runnable, @Nullable String name) {
        return this.runner.newWorkflowThread(runnable, false, name);
    }

    @Nonnull
    public Object newWorkflowCallbackThreadIntercepted(Runnable runnable, @Nullable String name) {
        return this.runner.newCallbackThread(runnable, name);
    }

    @Override
    public Object newChildThread(Runnable runnable, boolean detached, String name) {
        return this.runner.newWorkflowThread(runnable, detached, name);
    }

    @Override
    public long currentTimeMillis() {
        return this.replayContext.currentTimeMillis();
    }

    @Override
    @Nonnull
    public WorkflowImplementationOptions getWorkflowImplementationOptions() {
        return this.workflowImplementationOptions;
    }

    @Override
    public Failure mapWorkflowExceptionToFailure(Throwable failure) {
        return this.dataConverterWithCurrentWorkflowContext.exceptionToFailure(failure);
    }

    @Override
    @Nullable
    public <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        return this.dataConverterWithCurrentWorkflowContext.fromPayloads(0, Optional.ofNullable(this.replayContext.getLastCompletionResult()), resultClass, resultType);
    }

    @Override
    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    @Override
    public Map<String, Object> getPropagatedContexts() {
        if (this.contextPropagators == null || this.contextPropagators.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Payload> headerData = new HashMap<String, Payload>(this.replayContext.getHeader());
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (ContextPropagator propagator : this.contextPropagators) {
            contextData.put(propagator.getName(), propagator.deserializeContext(headerData));
        }
        return contextData;
    }

    public void setCurrentUpdateInfo(UpdateInfo updateInfo) {
        this.currentUpdateInfo.set(updateInfo);
    }

    public Optional<UpdateInfo> getCurrentUpdateInfo() {
        return Optional.ofNullable(this.currentUpdateInfo.get());
    }

    private static class FailureWrapperException
    extends RuntimeException {
        private final Failure failure;

        public FailureWrapperException(Failure failure) {
            this.failure = failure;
        }

        public Failure getFailure() {
            return this.failure;
        }
    }

    private static final class InitialWorkflowInboundCallsInterceptor
    extends BaseRootWorkflowInboundCallsInterceptor {
        public InitialWorkflowInboundCallsInterceptor(SyncWorkflowContext workflowContext) {
            super(workflowContext);
        }

        @Override
        public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
            throw new UnsupportedOperationException("SyncWorkflowContext should be initialized with a non-initial WorkflowInboundCallsInterceptor before #execute can be called");
        }
    }

    private class LocalActivityCallbackImpl
    implements LocalActivityCallback {
        private final CompletablePromise<Optional<Payloads>> result = Workflow.newPromise();

        private LocalActivityCallbackImpl() {
        }

        @Override
        public void apply(Optional<Payloads> successOutput, LocalActivityCallback.LocalActivityFailedException exception) {
            if (exception != null) {
                SyncWorkflowContext.this.runner.executeInWorkflowThread("local activity failure callback", () -> this.result.completeExceptionally(exception));
            } else {
                SyncWorkflowContext.this.runner.executeInWorkflowThread("local activity completion callback", () -> this.result.complete(successOutput));
            }
        }
    }

    private class ActivityCallback {
        private final CompletablePromise<Optional<Payloads>> result = Workflow.newPromise();

        private ActivityCallback() {
        }

        public void invoke(Optional<Payloads> output, Failure failure) {
            if (failure != null) {
                SyncWorkflowContext.this.runner.executeInWorkflowThread("activity failure callback", () -> this.result.completeExceptionally(new FailureWrapperException(failure)));
            } else {
                SyncWorkflowContext.this.runner.executeInWorkflowThread("activity completion callback", () -> this.result.complete(output));
            }
        }
    }
}

