/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common;

import io.temporal.common.SearchAttributeKey;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public final class SearchAttributes {
    public static final SearchAttributes EMPTY = new SearchAttributes(Collections.emptySortedMap());
    private final SortedMap<SearchAttributeKey<?>, Object> untypedValues;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SearchAttributes copyFrom) {
        return new Builder(copyFrom);
    }

    private SearchAttributes(SortedMap<SearchAttributeKey<?>, Object> untypedValues) {
        this.untypedValues = untypedValues;
    }

    public <T> T get(SearchAttributeKey<T> key) {
        return (T)this.untypedValues.get(key);
    }

    public boolean containsKey(SearchAttributeKey<?> key) {
        return this.untypedValues.containsKey(key);
    }

    public int size() {
        return this.untypedValues.size();
    }

    public SortedMap<SearchAttributeKey<?>, Object> getUntypedValues() {
        return this.untypedValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchAttributes that = (SearchAttributes)o;
        return this.untypedValues.equals(that.untypedValues);
    }

    public int hashCode() {
        return Objects.hash(this.untypedValues);
    }

    public static class Builder {
        private SortedMap<SearchAttributeKey<?>, Object> untypedValues;

        private Builder() {
            this.untypedValues = new TreeMap();
        }

        private Builder(SearchAttributes copyFrom) {
            this.untypedValues = new TreeMap(copyFrom.untypedValues);
        }

        public <T> Builder set(SearchAttributeKey<T> key, @Nonnull T value) {
            Objects.requireNonNull(this.untypedValues, "Collection already built");
            Objects.requireNonNull(value, "Value cannot be null");
            this.untypedValues.put(key, value);
            return this;
        }

        public Builder unset(SearchAttributeKey<?> key) {
            Objects.requireNonNull(this.untypedValues, "Collection already built");
            this.untypedValues.remove(key);
            return this;
        }

        public SearchAttributes build() {
            SearchAttributes attrs = new SearchAttributes(Collections.unmodifiableSortedMap(this.untypedValues));
            this.untypedValues = null;
            return attrs;
        }
    }
}

