/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.nexusrpc.Link;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;

public class NexusUtil {
    public static Duration parseRequestTimeout(String timeout) {
        try {
            if (timeout.endsWith("m")) {
                return Duration.ofMillis(Math.round(60000.0 * Double.parseDouble(timeout.substring(0, timeout.length() - 1))));
            }
            if (timeout.endsWith("ms")) {
                return Duration.ofMillis(Math.round(Double.parseDouble(timeout.substring(0, timeout.length() - 2))));
            }
            if (timeout.endsWith("s")) {
                return Duration.ofMillis(Math.round(1000.0 * Double.parseDouble(timeout.substring(0, timeout.length() - 1))));
            }
            throw new IllegalArgumentException("Invalid timeout format: " + timeout);
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new IllegalArgumentException("Invalid timeout format: " + timeout);
        }
    }

    public static Link nexusProtoLinkToLink(io.temporal.api.nexus.v1.Link nexusLink) throws URISyntaxException {
        return Link.newBuilder().setType(nexusLink.getType()).setUri(new URI(nexusLink.getUrl())).build();
    }

    private NexusUtil() {
    }
}

