/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.nexus;

import com.google.protobuf.InvalidProtocolBufferException;
import io.nexusrpc.Serializer;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverter;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.annotation.Nullable;

class PayloadSerializer
implements Serializer {
    DataConverter dataConverter;

    PayloadSerializer(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    public Serializer.Content serialize(@Nullable Object o) {
        Optional<Payload> payload = this.dataConverter.toPayload(o);
        Serializer.Content.Builder content = Serializer.Content.newBuilder();
        content.setData(payload.get().toByteArray());
        return content.build();
    }

    @Nullable
    public Object deserialize(Serializer.Content content, Type type) {
        try {
            Payload payload = Payload.parseFrom((byte[])content.getData());
            return this.dataConverter.fromPayload(payload, type.getClass(), type);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }
}

