/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.enums.v1.TimeoutType;
import io.temporal.api.history.v1.ChildWorkflowExecutionCanceledEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionCompletedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionTerminatedEventAttributes;
import io.temporal.api.history.v1.ChildWorkflowExecutionTimedOutEventAttributes;
import io.temporal.api.history.v1.StartChildWorkflowExecutionFailedEventAttributes;
import io.temporal.api.sdk.v1.UserMetadata;
import io.temporal.client.WorkflowExecutionAlreadyStarted;
import io.temporal.common.converter.EncodedValues;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.ChildWorkflowFailure;
import io.temporal.failure.TerminatedFailure;
import io.temporal.failure.TimeoutFailure;
import io.temporal.internal.replay.ChildWorkflowTaskFailedException;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;
import java.util.Optional;

final class ChildWorkflowStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, ChildWorkflowStateMachine> {
    private String workflowType;
    private String namespace;
    private String workflowId;
    public static final StateMachineDefinition<State, ExplicitEvent, ChildWorkflowStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("ChildWorkflow", State.CREATED, State.START_FAILED, State.COMPLETED, State.FAILED, State.CANCELED, State.TIMED_OUT, State.TERMINATED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.START_COMMAND_CREATED, ChildWorkflowStateMachine::createStartChildCommand).add(State.START_COMMAND_CREATED, CommandType.COMMAND_TYPE_START_CHILD_WORKFLOW_EXECUTION, State.START_COMMAND_CREATED).add(State.START_COMMAND_CREATED, EventType.EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_INITIATED, State.START_EVENT_RECORDED, EntityStateMachineInitialCommand::setInitialCommandEventId).add(State.START_COMMAND_CREATED, ExplicitEvent.CANCEL, State.CANCELED, ChildWorkflowStateMachine::cancelStartChildCommand).add(State.START_EVENT_RECORDED, EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_STARTED, State.STARTED, ChildWorkflowStateMachine::notifyStarted).add(State.START_EVENT_RECORDED, EventType.EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_FAILED, State.START_FAILED, ChildWorkflowStateMachine::notifyStartFailed).add(State.STARTED, EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_COMPLETED, State.COMPLETED, ChildWorkflowStateMachine::notifyCompleted).add(State.STARTED, EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_FAILED, State.FAILED, ChildWorkflowStateMachine::notifyFailed).add(State.STARTED, EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_TIMED_OUT, State.TIMED_OUT, ChildWorkflowStateMachine::notifyTimedOut).add(State.STARTED, EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_CANCELED, State.CANCELED, ChildWorkflowStateMachine::notifyCanceled).add(State.STARTED, EventType.EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_TERMINATED, State.TERMINATED, ChildWorkflowStateMachine::notifyTerminated);
    private StartChildWorkflowExecutionCommandAttributes startAttributes;
    private UserMetadata metadata;
    private final Functions.Proc2<WorkflowExecution, Exception> startedCallback;
    private final Functions.Proc2<Optional<Payloads>, Exception> completionCallback;

    public static ChildWorkflowStateMachine newInstance(StartChildWorkflowExecutionCommandAttributes attributes, UserMetadata metadata, Functions.Proc2<WorkflowExecution, Exception> startedCallback, Functions.Proc2<Optional<Payloads>, Exception> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        return new ChildWorkflowStateMachine(attributes, metadata, startedCallback, completionCallback, commandSink, stateMachineSink);
    }

    private ChildWorkflowStateMachine(StartChildWorkflowExecutionCommandAttributes startAttributes, UserMetadata metadata, Functions.Proc2<WorkflowExecution, Exception> startedCallback, Functions.Proc2<Optional<Payloads>, Exception> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.startAttributes = startAttributes;
        this.metadata = metadata;
        this.workflowType = startAttributes.getWorkflowType().getName();
        this.namespace = startAttributes.getNamespace();
        this.workflowId = startAttributes.getWorkflowId();
        this.startedCallback = startedCallback;
        this.completionCallback = completionCallback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    public void createStartChildCommand() {
        Command.Builder command = Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_START_CHILD_WORKFLOW_EXECUTION).setStartChildWorkflowExecutionCommandAttributes(this.startAttributes);
        if (this.metadata != null) {
            command.setUserMetadata(this.metadata);
            this.metadata = null;
        }
        this.addCommand(command.build());
        this.startAttributes = null;
    }

    public boolean isCancellable() {
        return State.START_COMMAND_CREATED == this.getState();
    }

    public void cancel() {
        if (!this.isFinalState()) {
            this.explicitEvent(ExplicitEvent.CANCEL);
        }
    }

    private void cancelStartChildCommand() {
        this.cancelCommand();
        ChildWorkflowFailure failure = new ChildWorkflowFailure(0L, 0L, this.workflowType, WorkflowExecution.newBuilder().setWorkflowId(this.workflowId).build(), this.namespace, RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, new CanceledFailure("Child immediately canceled"));
        this.startedCallback.apply(null, failure);
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyCompleted() {
        ChildWorkflowExecutionCompletedEventAttributes attributes = this.currentEvent.getChildWorkflowExecutionCompletedEventAttributes();
        Optional result = attributes.hasResult() ? Optional.of(attributes.getResult()) : Optional.empty();
        this.completionCallback.apply(result, null);
    }

    private void notifyStartFailed() {
        StartChildWorkflowExecutionFailedEventAttributes attributes = this.currentEvent.getStartChildWorkflowExecutionFailedEventAttributes();
        WorkflowExecutionAlreadyStarted cause = new WorkflowExecutionAlreadyStarted(WorkflowExecution.newBuilder().setWorkflowId(attributes.getWorkflowId()).build(), attributes.getWorkflowType().getName(), null);
        ChildWorkflowFailure failure = new ChildWorkflowFailure(attributes.getInitiatedEventId(), 0L, attributes.getWorkflowType().getName(), WorkflowExecution.newBuilder().setWorkflowId(attributes.getWorkflowId()).build(), attributes.getNamespace(), RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, cause);
        this.startedCallback.apply(null, failure);
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyFailed() {
        ChildWorkflowExecutionFailedEventAttributes attributes = this.currentEvent.getChildWorkflowExecutionFailedEventAttributes();
        ChildWorkflowFailure exception = new ChildWorkflowFailure(attributes.getInitiatedEventId(), attributes.getStartedEventId(), attributes.getWorkflowType().getName(), attributes.getWorkflowExecution(), attributes.getNamespace(), attributes.getRetryState(), null);
        ChildWorkflowTaskFailedException failure = new ChildWorkflowTaskFailedException(exception, attributes.getFailure());
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyTimedOut() {
        ChildWorkflowExecutionTimedOutEventAttributes attributes = this.currentEvent.getChildWorkflowExecutionTimedOutEventAttributes();
        TimeoutFailure timeoutFailure = new TimeoutFailure(null, null, TimeoutType.TIMEOUT_TYPE_START_TO_CLOSE);
        ChildWorkflowFailure failure = new ChildWorkflowFailure(attributes.getInitiatedEventId(), attributes.getStartedEventId(), attributes.getWorkflowType().getName(), attributes.getWorkflowExecution(), attributes.getNamespace(), attributes.getRetryState(), timeoutFailure);
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyCanceled() {
        ChildWorkflowExecutionCanceledEventAttributes attributes = this.currentEvent.getChildWorkflowExecutionCanceledEventAttributes();
        ChildWorkflowFailure failure = new ChildWorkflowFailure(attributes.getInitiatedEventId(), attributes.getStartedEventId(), attributes.getWorkflowType().getName(), attributes.getWorkflowExecution(), attributes.getNamespace(), RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, new CanceledFailure("Child canceled", new EncodedValues(attributes.getDetails()), null));
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyTerminated() {
        ChildWorkflowExecutionTerminatedEventAttributes attributes = this.currentEvent.getChildWorkflowExecutionTerminatedEventAttributes();
        ChildWorkflowFailure failure = new ChildWorkflowFailure(attributes.getInitiatedEventId(), attributes.getStartedEventId(), attributes.getWorkflowType().getName(), attributes.getWorkflowExecution(), attributes.getNamespace(), RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, new TerminatedFailure(null, null));
        this.completionCallback.apply(Optional.empty(), failure);
    }

    private void notifyStarted() {
        this.startedCallback.apply(this.currentEvent.getChildWorkflowExecutionStartedEventAttributes().getWorkflowExecution(), null);
    }

    static enum State {
        CREATED,
        START_COMMAND_CREATED,
        START_EVENT_RECORDED,
        STARTED,
        START_FAILED,
        COMPLETED,
        FAILED,
        CANCELED,
        TIMED_OUT,
        TERMINATED;

    }

    static enum ExplicitEvent {
        SCHEDULE,
        CANCEL;

    }
}

