/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.BaseRootWorkflowInboundCallsInterceptor;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.workflow.DynamicWorkflow;
import io.temporal.workflow.Functions;
import java.util.Optional;

final class DynamicSyncWorkflowDefinition
implements SyncWorkflowDefinition {
    private final Functions.Func1<EncodedValues, ? extends DynamicWorkflow> factory;
    private final WorkerInterceptor[] workerInterceptors;
    private final DataConverter dataConverterWithWorkflowContext;
    private WorkflowInboundCallsInterceptor workflowInvoker;

    public DynamicSyncWorkflowDefinition(Functions.Func1<EncodedValues, ? extends DynamicWorkflow> factory, WorkerInterceptor[] workerInterceptors, DataConverter dataConverterWithWorkflowContext) {
        this.factory = factory;
        this.workerInterceptors = workerInterceptors;
        this.dataConverterWithWorkflowContext = dataConverterWithWorkflowContext;
    }

    @Override
    public void initialize(Optional<Payloads> input) {
        SyncWorkflowContext workflowContext = WorkflowInternal.getRootWorkflowContext();
        this.workflowInvoker = new RootWorkflowInboundCallsInterceptor(workflowContext, input);
        for (WorkerInterceptor workerInterceptor : this.workerInterceptors) {
            this.workflowInvoker = workerInterceptor.interceptWorkflow(this.workflowInvoker);
        }
        workflowContext.initHeadInboundCallsInterceptor(this.workflowInvoker);
        this.workflowInvoker.init(workflowContext);
    }

    @Override
    public Optional<Payloads> execute(Header header, Optional<Payloads> input) {
        EncodedValues args = new EncodedValues(input, this.dataConverterWithWorkflowContext);
        WorkflowInboundCallsInterceptor.WorkflowOutput result = this.workflowInvoker.execute(new WorkflowInboundCallsInterceptor.WorkflowInput(header, new Object[]{args}));
        return this.dataConverterWithWorkflowContext.toPayloads(result.getResult());
    }

    class RootWorkflowInboundCallsInterceptor
    extends BaseRootWorkflowInboundCallsInterceptor {
        private DynamicWorkflow workflow;
        private Optional<Payloads> input;

        public RootWorkflowInboundCallsInterceptor(SyncWorkflowContext workflowContext, Optional<Payloads> input) {
            super(workflowContext);
            this.input = input;
        }

        @Override
        public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
            super.init(outboundCalls);
            this.newInstance(this.input);
            WorkflowInternal.registerListener(this.workflow);
        }

        @Override
        public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
            Object result = this.workflow.execute((EncodedValues)input.getArguments()[0]);
            return new WorkflowInboundCallsInterceptor.WorkflowOutput(result);
        }

        private void newInstance(Optional<Payloads> input) {
            if (this.workflow != null) {
                throw new IllegalStateException("Already called");
            }
            this.workflow = (DynamicWorkflow)DynamicSyncWorkflowDefinition.this.factory.apply(new EncodedValues(input, DynamicSyncWorkflowDefinition.this.dataConverterWithWorkflowContext));
        }
    }
}

