/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.Stopwatch;
import com.uber.m3.util.Duration;
import com.uber.m3.util.ImmutableMap;
import io.temporal.api.nexus.v1.HandlerError;
import io.temporal.api.nexus.v1.Request;
import io.temporal.api.nexus.v1.Response;
import io.temporal.api.workflowservice.v1.PollNexusTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.RespondNexusTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondNexusTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.retryer.GrpcRetryer;
import io.temporal.internal.worker.NexusPollTask;
import io.temporal.internal.worker.NexusTask;
import io.temporal.internal.worker.NexusTaskHandler;
import io.temporal.internal.worker.NoopWorker;
import io.temporal.internal.worker.PollTaskExecutor;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.PollerOptions;
import io.temporal.internal.worker.ShutdownManager;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkerLifecycleState;
import io.temporal.internal.worker.WorkerThreadsNameHelper;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.rpcretry.DefaultStubServiceOperationRpcRetryOptions;
import io.temporal.worker.WorkerMetricsTag;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.SlotSupplier;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class NexusWorker
implements SuspendableWorker {
    private static final Logger log = LoggerFactory.getLogger(NexusWorker.class);
    private SuspendableWorker poller = new NoopWorker();
    private PollTaskExecutor<NexusTask> pollTaskExecutor;
    private final NexusTaskHandler handler;
    private final WorkflowServiceStubs service;
    private final String namespace;
    private final String taskQueue;
    private final SingleWorkerOptions options;
    private final PollerOptions pollerOptions;
    private final Scope workerMetricsScope;
    private final GrpcRetryer grpcRetryer;
    private final GrpcRetryer.GrpcRetryerOptions replyGrpcRetryerOptions;
    private final TrackingSlotSupplier<NexusSlotInfo> slotSupplier;

    public NexusWorker(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull SingleWorkerOptions options, @Nonnull NexusTaskHandler handler, @Nonnull SlotSupplier<NexusSlotInfo> slotSupplier) {
        this.service = Objects.requireNonNull(service);
        this.namespace = Objects.requireNonNull(namespace);
        this.taskQueue = Objects.requireNonNull(taskQueue);
        this.handler = Objects.requireNonNull(handler);
        this.options = Objects.requireNonNull(options);
        this.pollerOptions = this.getPollerOptions(options);
        this.workerMetricsScope = MetricsTag.tagged((Scope)options.getMetricsScope(), (MetricsTag.TagValue)WorkerMetricsTag.WorkerType.NEXUS_WORKER);
        this.grpcRetryer = new GrpcRetryer(service.getServerCapabilities());
        this.replyGrpcRetryerOptions = new GrpcRetryer.GrpcRetryerOptions(DefaultStubServiceOperationRpcRetryOptions.INSTANCE, null);
        this.slotSupplier = new TrackingSlotSupplier<NexusSlotInfo>(slotSupplier, this.workerMetricsScope);
    }

    @Override
    public boolean start() {
        if (this.handler.start()) {
            this.pollTaskExecutor = new PollTaskExecutor<NexusTask>(this.namespace, this.taskQueue, this.options.getIdentity(), new TaskHandlerImpl(this.handler), this.pollerOptions, this.slotSupplier.maximumSlots().orElse(Integer.MAX_VALUE), true);
            this.poller = new Poller<NexusTask>(this.options.getIdentity(), new NexusPollTask(this.service, this.namespace, this.taskQueue, this.options.getIdentity(), this.options.getBuildId(), this.options.isUsingBuildIdForVersioning(), this.slotSupplier, this.workerMetricsScope, this.service.getServerCapabilities()), this.pollTaskExecutor, this.pollerOptions, this.workerMetricsScope);
            this.poller.start();
            this.workerMetricsScope.counter("temporal_worker_start").inc(1L);
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Void> shutdown(ShutdownManager shutdownManager, boolean interruptTasks) {
        String supplierName = this + "#executorSlots";
        return ((CompletableFuture)((CompletableFuture)this.poller.shutdown(shutdownManager, interruptTasks).thenCompose(ignore -> !interruptTasks ? shutdownManager.waitForSupplierPermitsReleasedUnlimited(this.slotSupplier, supplierName) : CompletableFuture.completedFuture(null))).thenCompose(ignore -> this.pollTaskExecutor != null ? this.pollTaskExecutor.shutdown(shutdownManager, interruptTasks) : CompletableFuture.completedFuture(null))).exceptionally(e -> {
            log.error("Unexpected exception during shutdown", e);
            return null;
        });
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = ShutdownManager.awaitTermination(this.poller, unit.toMillis(timeout));
        ShutdownManager.awaitTermination(this.pollTaskExecutor, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.poller.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.poller.resumePolling();
    }

    @Override
    public boolean isShutdown() {
        return this.poller.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.poller.isTerminated() && (this.pollTaskExecutor == null || this.pollTaskExecutor.isTerminated());
    }

    @Override
    public boolean isSuspended() {
        return this.poller.isSuspended();
    }

    @Override
    public WorkerLifecycleState getLifecycleState() {
        return this.poller.getLifecycleState();
    }

    private PollerOptions getPollerOptions(SingleWorkerOptions options) {
        PollerOptions pollerOptions = options.getPollerOptions();
        if (pollerOptions.getPollThreadNamePrefix() == null) {
            pollerOptions = PollerOptions.newBuilder(pollerOptions).setPollThreadNamePrefix(WorkerThreadsNameHelper.getNexusPollerThreadPrefix(this.namespace, this.taskQueue)).build();
        }
        return pollerOptions;
    }

    public String toString() {
        return String.format("NexusWorker{identity=%s, namespace=%s, taskQueue=%s}", this.options.getIdentity(), this.namespace, this.taskQueue);
    }

    private class TaskHandlerImpl
    implements PollTaskExecutor.TaskHandler<NexusTask> {
        final NexusTaskHandler handler;

        private TaskHandlerImpl(NexusTaskHandler handler) {
            this.handler = handler;
        }

        private String getNexusTaskService(PollNexusTaskQueueResponseOrBuilder pollResponse) {
            Request request = pollResponse.getRequest();
            if (request.hasStartOperation()) {
                return request.getStartOperation().getService();
            }
            if (request.hasCancelOperation()) {
                return request.getCancelOperation().getService();
            }
            return "";
        }

        private String getNexusTaskOperation(PollNexusTaskQueueResponseOrBuilder pollResponse) {
            Request request = pollResponse.getRequest();
            if (request.hasStartOperation()) {
                return request.getStartOperation().getOperation();
            }
            if (request.hasCancelOperation()) {
                return request.getCancelOperation().getOperation();
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(NexusTask task) {
            String operation;
            PollNexusTaskQueueResponseOrBuilder pollResponse = task.getResponse();
            Scope metricsScope = NexusWorker.this.workerMetricsScope;
            String service = this.getNexusTaskService(pollResponse);
            if (!service.isEmpty()) {
                MDC.put((String)"NexusService", (String)service);
                metricsScope = metricsScope.tagged((Map)ImmutableMap.of((Object)"nexus_service", (Object)service));
            }
            if (!(operation = this.getNexusTaskOperation(pollResponse)).isEmpty()) {
                MDC.put((String)"NexusOperation", (String)operation);
                metricsScope = metricsScope.tagged((Map)ImmutableMap.of((Object)"nexus_operation", (Object)operation));
            }
            NexusWorker.this.slotSupplier.markSlotUsed(new NexusSlotInfo(service, operation, NexusWorker.this.taskQueue, NexusWorker.this.options.getIdentity(), NexusWorker.this.options.getBuildId()), task.getPermit());
            try {
                this.handleNexusTask(task, metricsScope);
            }
            finally {
                task.getCompletionCallback().apply();
                MDC.remove((String)"NexusService");
                MDC.remove((String)"NexusOperation");
            }
        }

        @Override
        public Throwable wrapFailure(NexusTask task, Throwable failure) {
            PollNexusTaskQueueResponseOrBuilder response = task.getResponse();
            return new RuntimeException("Failure processing nexus response: " + response.getRequest().toString(), failure);
        }

        private void handleNexusTask(NexusTask task, Scope metricsScope) {
            NexusTaskHandler.Result result;
            PollNexusTaskQueueResponseOrBuilder pollResponse = task.getResponse();
            ByteString taskToken = pollResponse.getTaskToken();
            Stopwatch sw = metricsScope.timer("temporal_nexus_task_execution_latency").start();
            try {
                result = this.handler.handle(task, metricsScope);
                if (result.getHandlerError() != null || result.getResponse().hasStartOperation() && result.getResponse().getStartOperation().hasOperationError()) {
                    metricsScope.counter("temporal_nexus_task_execution_failed").inc(1L);
                }
            }
            catch (TimeoutException e) {
                log.warn("Nexus task timed out while processing", (Throwable)e);
                metricsScope.counter("temporal_nexus_task_execution_failed").inc(1L);
                return;
            }
            catch (Throwable e) {
                log.error("[BUG] Code that expected to never throw an exception threw an exception", e);
                throw e;
            }
            finally {
                sw.stop();
            }
            try {
                this.sendReply(taskToken, result, metricsScope);
            }
            catch (Exception e) {
                this.logExceptionDuringResultReporting(e, pollResponse, result);
                throw e;
            }
            Duration e2eDuration = ProtobufTimeUtils.toM3DurationSinceNow(pollResponse.getRequest().getScheduledTime());
            metricsScope.timer("temporal_nexus_task_endtoend_latency").record(e2eDuration);
        }

        private void logExceptionDuringResultReporting(Exception e, PollNexusTaskQueueResponseOrBuilder pollResponse, NexusTaskHandler.Result result) {
            if (log.isDebugEnabled()) {
                log.debug("Failure during reporting of nexus task result to the server. TaskResult={}", (Object)result, (Object)e);
            } else {
                log.warn("Failure during reporting of nexus task result to the server.", (Throwable)e);
            }
        }

        private void sendReply(ByteString taskToken, NexusTaskHandler.Result response, Scope metricsScope) {
            Response taskResponse = response.getResponse();
            if (taskResponse != null) {
                RespondNexusTaskCompletedRequest request = RespondNexusTaskCompletedRequest.newBuilder().setTaskToken(taskToken).setIdentity(NexusWorker.this.options.getIdentity()).setNamespace(NexusWorker.this.namespace).setResponse(taskResponse).build();
                NexusWorker.this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)NexusWorker.this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).respondNexusTaskCompleted(request), NexusWorker.this.replyGrpcRetryerOptions);
            } else {
                HandlerError taskFailed = response.getHandlerError();
                if (taskFailed != null) {
                    RespondNexusTaskFailedRequest request = RespondNexusTaskFailedRequest.newBuilder().setTaskToken(taskToken).setIdentity(NexusWorker.this.options.getIdentity()).setNamespace(NexusWorker.this.namespace).setError(taskFailed).build();
                    NexusWorker.this.grpcRetryer.retry(() -> ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)NexusWorker.this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)metricsScope)).respondNexusTaskFailed(request), NexusWorker.this.replyGrpcRetryerOptions);
                } else {
                    throw new IllegalArgumentException("[BUG] Either response or failure must be set");
                }
            }
        }
    }
}

