/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.nexus;

import io.nexusrpc.OperationInfo;
import io.nexusrpc.handler.OperationCancelDetails;
import io.nexusrpc.handler.OperationContext;
import io.nexusrpc.handler.OperationFetchInfoDetails;
import io.nexusrpc.handler.OperationFetchResultDetails;
import io.nexusrpc.handler.OperationHandler;
import io.nexusrpc.handler.OperationHandlerException;
import io.nexusrpc.handler.OperationStartDetails;
import io.nexusrpc.handler.OperationStartResult;
import io.temporal.api.common.v1.Link;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.nexus.v1.Link;
import io.temporal.client.WorkflowClient;
import io.temporal.internal.client.NexusStartWorkflowRequest;
import io.temporal.internal.common.LinkConverter;
import io.temporal.internal.common.NexusUtil;
import io.temporal.internal.nexus.CurrentNexusOperationContext;
import io.temporal.internal.nexus.NexusOperationContextImpl;
import io.temporal.nexus.WorkflowHandle;
import io.temporal.nexus.WorkflowHandleFactory;
import java.net.URISyntaxException;

class RunWorkflowOperation<T, R>
implements OperationHandler<T, R> {
    private final WorkflowHandleFactory<T, R> handleFactory;

    RunWorkflowOperation(WorkflowHandleFactory<T, R> handleFactory) {
        this.handleFactory = handleFactory;
    }

    public OperationStartResult<R> start(OperationContext ctx, OperationStartDetails operationStartDetails, T input) {
        NexusOperationContextImpl nexusCtx = CurrentNexusOperationContext.get();
        WorkflowHandle<R> handle = this.handleFactory.apply(ctx, operationStartDetails, nexusCtx.getWorkflowClient(), input);
        NexusStartWorkflowRequest nexusRequest = new NexusStartWorkflowRequest(operationStartDetails.getRequestId(), operationStartDetails.getCallbackUrl(), operationStartDetails.getCallbackHeaders(), nexusCtx.getTaskQueue(), operationStartDetails.getLinks());
        WorkflowExecution workflowExec = handle.getInvoker().invoke(nexusRequest);
        Link.WorkflowEvent workflowEventLink = Link.WorkflowEvent.newBuilder().setNamespace(nexusCtx.getNamespace()).setWorkflowId(workflowExec.getWorkflowId()).setRunId(workflowExec.getRunId()).setEventRef(Link.WorkflowEvent.EventReference.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED)).build();
        Link nexusLink = LinkConverter.workflowEventToNexusLink(workflowEventLink);
        try {
            OperationStartResult.Builder result = OperationStartResult.newBuilder().setAsyncOperationId(workflowExec.getWorkflowId());
            if (nexusLink != null) {
                result.addLink(NexusUtil.nexusProtoLinkToLink(nexusLink));
            }
            return result.build();
        }
        catch (URISyntaxException e) {
            throw new OperationHandlerException(OperationHandlerException.ErrorType.INTERNAL, "failed to construct result URL", (Throwable)e);
        }
    }

    public R fetchResult(OperationContext operationContext, OperationFetchResultDetails operationFetchResultDetails) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OperationInfo fetchInfo(OperationContext operationContext, OperationFetchInfoDetails operationFetchInfoDetails) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void cancel(OperationContext operationContext, OperationCancelDetails operationCancelDetails) {
        WorkflowClient client = CurrentNexusOperationContext.get().getWorkflowClient();
        client.newUntypedWorkflowStub(operationCancelDetails.getOperationId()).cancel();
    }
}

