/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Defaults;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.internal.sync.NexusOperationHandleImpl;
import io.temporal.workflow.Functions;
import io.temporal.workflow.NexusOperationHandle;
import io.temporal.workflow.NexusOperationOptions;
import io.temporal.workflow.NexusServiceOptions;
import io.temporal.workflow.NexusServiceStub;
import io.temporal.workflow.Promise;
import java.lang.reflect.Type;
import java.util.Collections;

public class NexusServiceStubImpl
implements NexusServiceStub {
    final String name;
    final NexusServiceOptions options;
    final WorkflowOutboundCallsInterceptor outboundCallsInterceptor;
    final Functions.Proc1<String> assertReadOnly;

    public NexusServiceStubImpl(String name, NexusServiceOptions options, WorkflowOutboundCallsInterceptor outboundCallsInterceptor, Functions.Proc1<String> assertReadOnly) {
        this.name = name;
        this.options = options;
        this.outboundCallsInterceptor = outboundCallsInterceptor;
        this.assertReadOnly = assertReadOnly;
    }

    @Override
    public <R> R execute(String operationName, Class<R> resultClass, Object arg) {
        return this.execute(operationName, resultClass, resultClass, arg);
    }

    @Override
    public <R> R execute(String operationName, Class<R> resultClass, Type resultType, Object arg) {
        this.assertReadOnly.apply("execute nexus operation");
        Promise<R> result = this.executeAsync(operationName, resultClass, resultType, arg);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(result);
            return (R)Defaults.defaultValue(resultClass);
        }
        try {
            return result.get();
        }
        catch (TemporalFailure e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    @Override
    public <R> Promise<R> executeAsync(String operationName, Class<R> resultClass, Object arg) {
        return this.executeAsync(operationName, resultClass, resultClass, arg);
    }

    @Override
    public <R> Promise<R> executeAsync(String operationName, Class<R> resultClass, Type resultType, Object arg) {
        this.assertReadOnly.apply("execute nexus operation");
        NexusOperationOptions mergedOptions = NexusOperationOptions.newBuilder(this.options.getOperationOptions()).mergeNexusOperationOptions(this.options.getOperationMethodOptions().get(operationName)).build();
        WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput<R> result = this.outboundCallsInterceptor.executeNexusOperation(new WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R>(this.options.getEndpoint(), this.name, operationName, resultClass, resultType, arg, mergedOptions, Collections.emptyMap()));
        return result.getResult();
    }

    @Override
    public <R> NexusOperationHandle<R> start(String operationName, Class<R> resultClass, Object arg) {
        return this.start(operationName, resultClass, resultClass, arg);
    }

    @Override
    public <R> NexusOperationHandle<R> start(String operationName, Class<R> resultClass, Type resultType, Object arg) {
        this.assertReadOnly.apply("schedule nexus operation");
        NexusOperationOptions mergedOptions = NexusOperationOptions.newBuilder(this.options.getOperationOptions()).mergeNexusOperationOptions(this.options.getOperationMethodOptions().get(operationName)).build();
        WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput<R> result = this.outboundCallsInterceptor.executeNexusOperation(new WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R>(this.options.getEndpoint(), this.name, operationName, resultClass, resultType, arg, mergedOptions, Collections.emptyMap()));
        return new NexusOperationHandleImpl<R>(result.getOperationExecution(), result.getResult());
    }
}

