/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.worker;

import com.google.protobuf.DoubleValue;
import com.uber.m3.tally.Scope;
import io.temporal.api.common.v1.WorkerVersionCapabilities;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.taskqueue.v1.TaskQueueMetadata;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.Poller;
import io.temporal.internal.worker.SlotReservationData;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.serviceclient.MetricsTag;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ActivityPollTask
implements Poller.PollTask<ActivityTask> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPollTask.class);
    private final WorkflowServiceStubs service;
    private final TrackingSlotSupplier<ActivitySlotInfo> slotSupplier;
    private final Scope metricsScope;
    private final PollActivityTaskQueueRequest pollRequest;

    public ActivityPollTask(@Nonnull WorkflowServiceStubs service, @Nonnull String namespace, @Nonnull String taskQueue, @Nonnull String identity, @Nullable String buildId, boolean useBuildIdForVersioning, double activitiesPerSecond, @Nonnull TrackingSlotSupplier<ActivitySlotInfo> slotSupplier, @Nonnull Scope metricsScope, @Nonnull Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities) {
        this.service = Objects.requireNonNull(service);
        this.slotSupplier = slotSupplier;
        this.metricsScope = Objects.requireNonNull(metricsScope);
        PollActivityTaskQueueRequest.Builder pollRequest = PollActivityTaskQueueRequest.newBuilder().setNamespace(namespace).setIdentity(identity).setTaskQueue(TaskQueue.newBuilder().setName(taskQueue));
        if (activitiesPerSecond > 0.0) {
            pollRequest.setTaskQueueMetadata(TaskQueueMetadata.newBuilder().setMaxTasksPerSecond(DoubleValue.newBuilder().setValue(activitiesPerSecond).build()).build());
        }
        if (serverCapabilities.get().getBuildIdBasedVersioning()) {
            pollRequest.setWorkerVersionCapabilities(WorkerVersionCapabilities.newBuilder().setBuildId(buildId).setUseVersioning(useBuildIdForVersioning).build());
        }
        this.pollRequest = pollRequest.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityTask poll() {
        SlotPermit permit;
        if (log.isTraceEnabled()) {
            log.trace("poll request begin: " + this.pollRequest);
        }
        boolean isSuccessful = false;
        try {
            permit = this.slotSupplier.reserveSlot(new SlotReservationData(this.pollRequest.getTaskQueue().getName(), this.pollRequest.getIdentity(), this.pollRequest.getWorkerVersionCapabilities().getBuildId()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            log.warn("Error while trying to reserve a slot for an activity", e.getCause());
            return null;
        }
        try {
            PollActivityTaskQueueResponse response = ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)((WorkflowServiceGrpc.WorkflowServiceBlockingStub)this.service.blockingStub()).withOption(MetricsTag.METRICS_TAGS_CALL_OPTIONS_KEY, (Object)this.metricsScope)).pollActivityTaskQueue(this.pollRequest);
            if (response == null || response.getTaskToken().isEmpty()) {
                this.metricsScope.counter("temporal_activity_poll_no_task").inc(1L);
                ActivityTask activityTask = null;
                return activityTask;
            }
            this.metricsScope.timer("temporal_activity_schedule_to_start_latency").record(ProtobufTimeUtils.toM3Duration(response.getStartedTime(), response.getCurrentAttemptScheduledTime()));
            isSuccessful = true;
            ActivityTask activityTask = new ActivityTask((PollActivityTaskQueueResponseOrBuilder)response, permit, () -> this.slotSupplier.releaseSlot(SlotReleaseReason.taskComplete(), permit));
            return activityTask;
        }
        finally {
            if (!isSuccessful) {
                this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), permit);
            }
        }
    }
}

