/*
 * Copyright (C) 2022 Temporal Technologies, Inc. All Rights Reserved.
 *
 * Copyright (C) 2012-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Modifications copyright (C) 2017 Uber Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this material except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.temporal.internal.worker;

import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributesOrBuilder;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.worker.tuning.SlotPermit;
import java.util.Optional;

public interface EagerActivityDispatcher {
  Optional<SlotPermit> tryReserveActivitySlot(
      ScheduleActivityTaskCommandAttributesOrBuilder commandAttributes);

  void releaseActivitySlotReservations(Iterable<SlotPermit> permits);

  void dispatchActivity(PollActivityTaskQueueResponse activity, SlotPermit permit);

  class NoopEagerActivityDispatcher implements EagerActivityDispatcher {
    @Override
    public Optional<SlotPermit> tryReserveActivitySlot(
        ScheduleActivityTaskCommandAttributesOrBuilder commandAttributes) {
      return Optional.empty();
    }

    @Override
    public void releaseActivitySlotReservations(Iterable<SlotPermit> permits) {
      if (permits.iterator().hasNext())
        throw new IllegalStateException(
            "Trying to release activity slots on a NoopEagerActivityDispatcher");
    }

    @Override
    public void dispatchActivity(PollActivityTaskQueueResponse activity, SlotPermit permit) {
      throw new IllegalStateException(
          "Trying to dispatch activity on a NoopEagerActivityDispatcher");
    }
  }
}
