/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.failure.v1.ApplicationFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.failure.v1.ResetWorkflowFailureInfo;
import io.temporal.api.failure.v1.TimeoutFailureInfo;
import io.temporal.common.converter.ConverterUtils;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.failure.TemporalFailure;
import io.temporal.payload.codec.ChainCodec;
import io.temporal.payload.codec.PayloadCodec;
import io.temporal.payload.context.SerializationContext;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CodecDataConverter
implements DataConverter,
PayloadCodec {
    private static final String ENCODED_FAILURE_MESSAGE = "Encoded failure";
    private final DataConverter dataConverter;
    private final ChainCodec chainCodec;
    private final boolean encodeFailureAttributes;
    @Nullable
    private final SerializationContext serializationContext;

    public CodecDataConverter(DataConverter dataConverter, Collection<PayloadCodec> codecs) {
        this(dataConverter, codecs, false);
    }

    public CodecDataConverter(DataConverter dataConverter, Collection<PayloadCodec> codecs, boolean encodeFailureAttributes) {
        this(dataConverter, new ChainCodec(codecs), encodeFailureAttributes, null);
    }

    CodecDataConverter(DataConverter dataConverter, ChainCodec codecs, boolean encodeFailureAttributes, @Nullable SerializationContext serializationContext) {
        this.dataConverter = dataConverter;
        this.chainCodec = codecs;
        this.encodeFailureAttributes = encodeFailureAttributes;
        this.serializationContext = serializationContext;
    }

    @Override
    public <T> Optional<Payload> toPayload(T value) {
        Optional<Payload> payload = ConverterUtils.withContext(this.dataConverter, this.serializationContext).toPayload(value);
        List<Payload> encodedPayloads = ConverterUtils.withContext(this.chainCodec, this.serializationContext).encode(Collections.singletonList(payload.get()));
        Preconditions.checkState((encodedPayloads.size() == 1 ? 1 : 0) != 0, (Object)"Expected one encoded payload");
        return Optional.of(encodedPayloads.get(0));
    }

    @Override
    public <T> T fromPayload(Payload payload, Class<T> valueClass, Type valueType) {
        List<Payload> decodedPayload = ConverterUtils.withContext(this.chainCodec, this.serializationContext).decode(Collections.singletonList(payload));
        Preconditions.checkState((decodedPayload.size() == 1 ? 1 : 0) != 0, (Object)"Expected one decoded payload");
        return ConverterUtils.withContext(this.dataConverter, this.serializationContext).fromPayload(decodedPayload.get(0), valueClass, valueType);
    }

    @Override
    public Optional<Payloads> toPayloads(Object ... values) throws DataConverterException {
        Optional<Payloads> payloads = ConverterUtils.withContext(this.dataConverter, this.serializationContext).toPayloads(values);
        if (payloads.isPresent()) {
            List<Payload> encodedPayloads = ConverterUtils.withContext(this.chainCodec, this.serializationContext).encode(payloads.get().getPayloadsList());
            payloads = Optional.of(Payloads.newBuilder().addAllPayloads(encodedPayloads).build());
        }
        return payloads;
    }

    @Override
    public <T> T fromPayloads(int index, Optional<Payloads> content, Class<T> valueType, Type valueGenericType) throws DataConverterException {
        if (content.isPresent()) {
            content = Optional.of(this.decodePayloads(content.get()));
        }
        return ConverterUtils.withContext(this.dataConverter, this.serializationContext).fromPayloads(index, content, valueType, valueGenericType);
    }

    @Override
    public Object[] fromPayloads(Optional<Payloads> content, Class<?>[] parameterTypes, Type[] genericParameterTypes) throws DataConverterException {
        if (content.isPresent()) {
            content = Optional.of(this.decodePayloads(content.get()));
        }
        return ConverterUtils.withContext(this.dataConverter, this.serializationContext).fromPayloads(content, parameterTypes, genericParameterTypes);
    }

    @Override
    @Nonnull
    public Failure exceptionToFailure(@Nonnull Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable, (Object)"throwable");
        return this.encodeFailure(ConverterUtils.withContext(this.dataConverter, this.serializationContext).exceptionToFailure(throwable).toBuilder()).build();
    }

    @Override
    @Nonnull
    public TemporalFailure failureToException(@Nonnull Failure failure) {
        Preconditions.checkNotNull((Object)failure, (Object)"failure");
        return ConverterUtils.withContext(this.dataConverter, this.serializationContext).failureToException(this.decodeFailure(failure.toBuilder()).build());
    }

    @Override
    @Nonnull
    public CodecDataConverter withContext(@Nonnull SerializationContext context) {
        return new CodecDataConverter(this.dataConverter, this.chainCodec, this.encodeFailureAttributes, context);
    }

    @Override
    @Nonnull
    public List<Payload> encode(@Nonnull List<Payload> payloads) {
        return ConverterUtils.withContext(this.chainCodec, this.serializationContext).encode(payloads);
    }

    @Override
    @Nonnull
    public List<Payload> decode(@Nonnull List<Payload> payloads) {
        return ConverterUtils.withContext(this.chainCodec, this.serializationContext).decode(payloads);
    }

    private Failure.Builder encodeFailure(Failure.Builder failure) {
        if (failure.hasCause()) {
            failure.setCause(this.encodeFailure(failure.getCause().toBuilder()));
        }
        if (this.encodeFailureAttributes) {
            EncodedAttributes encodedAttributes = new EncodedAttributes();
            encodedAttributes.setStackTrace(failure.getStackTrace());
            encodedAttributes.setMessage(failure.getMessage());
            Payload encodedAttributesPayload = this.toPayload(Optional.of(encodedAttributes)).get();
            failure.setEncodedAttributes(encodedAttributesPayload).setMessage(ENCODED_FAILURE_MESSAGE).setStackTrace("");
        }
        switch (failure.getFailureInfoCase()) {
            case APPLICATION_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getApplicationFailureInfo().toBuilder();
                if (info.hasDetails()) {
                    info.setDetails(this.encodePayloads(info.getDetails()));
                }
                failure.setApplicationFailureInfo(info);
                break;
            }
            case TIMEOUT_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getTimeoutFailureInfo().toBuilder();
                if (info.hasLastHeartbeatDetails()) {
                    info.setLastHeartbeatDetails(this.encodePayloads(info.getLastHeartbeatDetails()));
                }
                failure.setTimeoutFailureInfo((TimeoutFailureInfo.Builder)info);
                break;
            }
            case CANCELED_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getCanceledFailureInfo().toBuilder();
                if (info.hasDetails()) {
                    info.setDetails(this.encodePayloads(info.getDetails()));
                }
                failure.setCanceledFailureInfo((CanceledFailureInfo.Builder)info);
                break;
            }
            case RESET_WORKFLOW_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getResetWorkflowFailureInfo().toBuilder();
                if (info.hasLastHeartbeatDetails()) {
                    info.setLastHeartbeatDetails(this.encodePayloads(info.getLastHeartbeatDetails()));
                }
                failure.setResetWorkflowFailureInfo((ResetWorkflowFailureInfo.Builder)info);
                break;
            }
        }
        return failure;
    }

    private Failure.Builder decodeFailure(Failure.Builder failure) {
        if (failure.hasCause()) {
            failure.setCause(this.decodeFailure(failure.getCause().toBuilder()));
        }
        if (failure.hasEncodedAttributes()) {
            EncodedAttributes encodedAttributes = this.fromPayload(failure.getEncodedAttributes(), (Class)EncodedAttributes.class, (Type)((Object)EncodedAttributes.class));
            failure.setStackTrace(encodedAttributes.getStackTrace()).setMessage(encodedAttributes.getMessage()).clearEncodedAttributes();
        }
        switch (failure.getFailureInfoCase()) {
            case APPLICATION_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getApplicationFailureInfo().toBuilder();
                if (info.hasDetails()) {
                    info.setDetails(this.decodePayloads(info.getDetails()));
                }
                failure.setApplicationFailureInfo(info);
                break;
            }
            case TIMEOUT_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getTimeoutFailureInfo().toBuilder();
                if (info.hasLastHeartbeatDetails()) {
                    info.setLastHeartbeatDetails(this.decodePayloads(info.getLastHeartbeatDetails()));
                }
                failure.setTimeoutFailureInfo((TimeoutFailureInfo.Builder)info);
                break;
            }
            case CANCELED_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getCanceledFailureInfo().toBuilder();
                if (info.hasDetails()) {
                    info.setDetails(this.decodePayloads(info.getDetails()));
                }
                failure.setCanceledFailureInfo((CanceledFailureInfo.Builder)info);
                break;
            }
            case RESET_WORKFLOW_FAILURE_INFO: {
                ApplicationFailureInfo.Builder info = failure.getResetWorkflowFailureInfo().toBuilder();
                if (info.hasLastHeartbeatDetails()) {
                    info.setLastHeartbeatDetails(this.decodePayloads(info.getLastHeartbeatDetails()));
                }
                failure.setResetWorkflowFailureInfo((ResetWorkflowFailureInfo.Builder)info);
                break;
            }
        }
        return failure;
    }

    private Payloads encodePayloads(Payloads decodedPayloads) {
        return Payloads.newBuilder().addAllPayloads(this.encode(decodedPayloads.getPayloadsList())).build();
    }

    private Payloads decodePayloads(Payloads encodedPayloads) {
        return Payloads.newBuilder().addAllPayloads(this.decode(encodedPayloads.getPayloadsList())).build();
    }

    static class EncodedAttributes {
        private String message;
        private String stackTrace;

        EncodedAttributes() {
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="stack_trace")
        public String getStackTrace() {
            return this.stackTrace;
        }

        @JsonProperty(value="stack_trace")
        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }
    }
}

