/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.google.common.base.Defaults;
import io.nexusrpc.Operation;
import io.nexusrpc.ServiceDefinition;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.sync.NexusServiceStubImpl;
import io.temporal.internal.sync.StartNexusCallInternal;
import io.temporal.workflow.Functions;
import io.temporal.workflow.NexusServiceOptions;
import io.temporal.workflow.NexusServiceStub;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class NexusServiceInvocationHandler
implements InvocationHandler {
    private final NexusServiceStub stub;
    private final ServiceDefinition serviceDef;

    NexusServiceInvocationHandler(ServiceDefinition serviceDef, NexusServiceOptions options, WorkflowOutboundCallsInterceptor outboundCallsInterceptor, Functions.Proc1<String> assertReadOnly) {
        this.serviceDef = serviceDef;
        this.stub = new NexusServiceStubImpl(serviceDef.getName(), options, outboundCallsInterceptor, assertReadOnly){};
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String opName;
        if (method.getName().equals("__getUntypedStub")) {
            return this.stub;
        }
        Object arg = args != null ? args[0] : null;
        Operation opAnnotation = method.getAnnotation(Operation.class);
        if (opAnnotation == null) {
            throw new IllegalArgumentException("Unknown method: " + method);
        }
        String string = opName = !opAnnotation.name().equals("") ? opAnnotation.name() : method.getName();
        if (StartNexusCallInternal.isAsync()) {
            StartNexusCallInternal.setAsyncResult(this.stub.start(opName, method.getReturnType(), method.getGenericReturnType(), arg));
            return Defaults.defaultValue(method.getReturnType());
        }
        return InternalUtils.getValueOrDefault(this.stub.execute(opName, method.getReturnType(), method.getGenericReturnType(), arg), method.getReturnType());
    }
}

