/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ScheduleRange {
    private final int start;
    private final int end;
    private final int step;

    public ScheduleRange(int start) {
        this(start, 0, 0);
    }

    public ScheduleRange(int start, int end) {
        this(start, end, 0);
    }

    public ScheduleRange(int start, int end, int step) {
        Preconditions.checkState((start >= 0 && step >= 0 && step >= 0 ? 1 : 0) != 0);
        this.start = start;
        this.end = end;
        this.step = step;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStep() {
        return this.step;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleRange that = (ScheduleRange)o;
        return this.start == that.start && this.end == that.end && this.step == that.step;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.step);
    }

    public String toString() {
        return "ScheduleRange{start=" + this.start + ", end=" + this.end + ", step=" + this.step + '}';
    }
}

