/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.TaskReachability;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.client.ActivityCompletionClient;
import io.temporal.client.BatchRequest;
import io.temporal.client.BuildIdOperation;
import io.temporal.client.UpdateOptions;
import io.temporal.client.WithStartWorkflowOperation;
import io.temporal.client.WorkerBuildIdVersionSets;
import io.temporal.client.WorkerTaskReachability;
import io.temporal.client.WorkflowClientInternalImpl;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.client.WorkflowExecutionMetadata;
import io.temporal.client.WorkflowOptions;
import io.temporal.client.WorkflowStub;
import io.temporal.client.WorkflowUpdateHandle;
import io.temporal.common.Experimental;
import io.temporal.common.WorkflowExecutionHistory;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.workflow.Functions;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface WorkflowClient {
    public static final String QUERY_TYPE_STACK_TRACE = "__stack_trace";
    public static final String QUERY_TYPE_WORKFLOW_METADATA = "__temporal_workflow_metadata";
    public static final String QUERY_TYPE_REPLAY_ONLY = "__replay_only";

    public static WorkflowClient newInstance(WorkflowServiceStubs service) {
        return WorkflowClientInternalImpl.newInstance(service, WorkflowClientOptions.getDefaultInstance());
    }

    public static WorkflowClient newInstance(WorkflowServiceStubs service, WorkflowClientOptions options) {
        return WorkflowClientInternalImpl.newInstance(service, options);
    }

    public WorkflowClientOptions getOptions();

    public WorkflowServiceStubs getWorkflowServiceStubs();

    public <T> T newWorkflowStub(Class<T> var1, WorkflowOptions var2);

    public <T> T newWorkflowStub(Class<T> var1, String var2);

    public <T> T newWorkflowStub(Class<T> var1, String var2, Optional<String> var3);

    public WorkflowStub newUntypedWorkflowStub(String var1);

    public WorkflowStub newUntypedWorkflowStub(String var1, WorkflowOptions var2);

    public WorkflowStub newUntypedWorkflowStub(String var1, Optional<String> var2, Optional<String> var3);

    public WorkflowStub newUntypedWorkflowStub(WorkflowExecution var1, Optional<String> var2);

    public ActivityCompletionClient newActivityCompletionClient();

    public BatchRequest newSignalWithStartRequest();

    public WorkflowExecution signalWithStart(BatchRequest var1);

    public Stream<WorkflowExecutionMetadata> listExecutions(@Nullable String var1);

    public Stream<HistoryEvent> streamHistory(@Nonnull String var1);

    public Stream<HistoryEvent> streamHistory(@Nonnull String var1, @Nullable String var2);

    public WorkflowExecutionHistory fetchHistory(@Nonnull String var1);

    public WorkflowExecutionHistory fetchHistory(@Nonnull String var1, @Nullable String var2);

    @Experimental
    public void updateWorkerBuildIdCompatability(@Nonnull String var1, @Nonnull BuildIdOperation var2);

    @Experimental
    public WorkerBuildIdVersionSets getWorkerBuildIdCompatability(@Nonnull String var1);

    @Experimental
    public WorkerTaskReachability getWorkerTaskReachability(@Nonnull Iterable<String> var1, @Nonnull Iterable<String> var2, TaskReachability var3);

    public static WorkflowExecution start(Functions.Proc workflow) {
        return WorkflowClientInternalImpl.start(workflow);
    }

    public static <A1> WorkflowExecution start(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.start(workflow, arg1);
    }

    public static <A1, A2> WorkflowExecution start(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2);
    }

    public static <A1, A2, A3> WorkflowExecution start(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4> WorkflowExecution start(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5> WorkflowExecution start(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6> WorkflowExecution start(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static <R> WorkflowExecution start(Functions.Func<R> workflow) {
        return WorkflowClientInternalImpl.start(workflow);
    }

    public static <A1, R> WorkflowExecution start(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.start(workflow, arg1);
    }

    public static <A1, A2, R> WorkflowExecution start(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2);
    }

    public static <A1, A2, A3, R> WorkflowExecution start(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4, R> WorkflowExecution start(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5, R> WorkflowExecution start(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6, R> WorkflowExecution start(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.start(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static WorkflowUpdateHandle<Void> startUpdate(Functions.Proc updateMethod, @Nonnull UpdateOptions<Void> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, options);
    }

    public static <A1> WorkflowUpdateHandle<Void> startUpdate(Functions.Proc1<A1> updateMethod, A1 arg1, @Nonnull UpdateOptions<Void> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, options);
    }

    public static <A1, A2> WorkflowUpdateHandle<Void> startUpdate(Functions.Proc2<A1, A2> updateMethod, A1 arg1, A2 arg2, @Nonnull UpdateOptions<Void> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, options);
    }

    public static <A1, A2, A3> WorkflowUpdateHandle<Void> startUpdate(Functions.Proc3<A1, A2, A3> updateMethod, A1 arg1, A2 arg2, A3 arg3, @Nonnull UpdateOptions<Void> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, options);
    }

    public static <A1, A2, A3, A4> WorkflowUpdateHandle<Void> startUpdate(Functions.Proc4<A1, A2, A3, A4> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, @Nonnull UpdateOptions<Void> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, arg4, options);
    }

    public static <A1, A2, A3, A4, A5> WorkflowUpdateHandle<Void> startUpdate(Functions.Proc5<A1, A2, A3, A4, A5> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, @Nonnull UpdateOptions<Void> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, arg4, arg5, options);
    }

    public static <A1, A2, A3, A4, A5, A6> WorkflowUpdateHandle<Void> startUpdate(Functions.Proc6<A1, A2, A3, A4, A5, A6> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, @Nonnull UpdateOptions<Void> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, arg4, arg5, arg6, options);
    }

    public static <R> WorkflowUpdateHandle<R> startUpdate(Functions.Func<R> updateMethod, @Nonnull UpdateOptions<R> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, options);
    }

    public static <R, A1> WorkflowUpdateHandle<R> startUpdate(Functions.Func1<A1, R> updateMethod, A1 arg1, @Nonnull UpdateOptions<R> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, options);
    }

    public static <R, A1, A2> WorkflowUpdateHandle<R> startUpdate(Functions.Func2<A1, A2, R> updateMethod, A1 arg1, A2 arg2, @Nonnull UpdateOptions<R> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, options);
    }

    public static <R, A1, A2, A3> WorkflowUpdateHandle<R> startUpdate(Functions.Func3<A1, A2, A3, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, @Nonnull UpdateOptions<R> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, options);
    }

    public static <R, A1, A2, A3, A4> WorkflowUpdateHandle<R> startUpdate(Functions.Func4<A1, A2, A3, A4, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, @Nonnull UpdateOptions<R> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, arg4, options);
    }

    public static <R, A1, A2, A3, A4, A5> WorkflowUpdateHandle<R> startUpdate(Functions.Func5<A1, A2, A3, A4, A5, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, @Nonnull UpdateOptions<R> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, arg4, arg5, options);
    }

    public static <R, A1, A2, A3, A4, A5, A6> WorkflowUpdateHandle<R> startUpdate(Functions.Func6<A1, A2, A3, A4, A5, A6, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, @Nonnull UpdateOptions<R> options) {
        return WorkflowClientInternalImpl.startUpdate(updateMethod, arg1, arg2, arg3, arg4, arg5, arg6, options);
    }

    @Experimental
    public static <R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Proc updateMethod, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(updateMethod, options, startOperation);
    }

    @Experimental
    public static <R, A1> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Proc1<A1> updateMethod, A1 arg1, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Proc2<A1, A2> updateMethod, A1 arg1, A2 arg2, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Proc3<A1, A2, A3> updateMethod, A1 arg1, A2 arg2, A3 arg3, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3, A4> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Proc4<A1, A2, A3, A4> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3, A4, A5> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Proc5<A1, A2, A3, A4, A5> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3, A4, A5, A6> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Proc6<A1, A2, A3, A4, A5, A6> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5, arg6), options, startOperation);
    }

    @Experimental
    public static <R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Func<R> updateMethod, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(updateMethod::apply, options, startOperation);
    }

    @Experimental
    public static <A1, R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Func1<A1, R> updateMethod, A1 arg1, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1), options, startOperation);
    }

    @Experimental
    public static <A1, A2, R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Func2<A1, A2, R> updateMethod, A1 arg1, A2 arg2, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2), options, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Func3<A1, A2, A3, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3), options, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, A4, R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Func4<A1, A2, A3, A4, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4), options, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, A4, A5, R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Func5<A1, A2, A3, A4, A5, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5), options, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, A4, A5, A6, R> WorkflowUpdateHandle<R> startUpdateWithStart(Functions.Func6<A1, A2, A3, A4, A5, A6, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.startUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5, arg6), options, startOperation);
    }

    @Experimental
    public static <R> R executeUpdateWithStart(Functions.Proc updateMethod, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(updateMethod, options, startOperation);
    }

    @Experimental
    public static <R, A1> R executeUpdateWithStart(Functions.Proc1<A1> updateMethod, A1 arg1, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2> R executeUpdateWithStart(Functions.Proc2<A1, A2> updateMethod, A1 arg1, A2 arg2, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3> R executeUpdateWithStart(Functions.Proc3<A1, A2, A3> updateMethod, A1 arg1, A2 arg2, A3 arg3, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3, A4> R executeUpdateWithStart(Functions.Proc4<A1, A2, A3, A4> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3, A4, A5> R executeUpdateWithStart(Functions.Proc5<A1, A2, A3, A4, A5> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5), options, startOperation);
    }

    @Experimental
    public static <R, A1, A2, A3, A4, A5, A6> R executeUpdateWithStart(Functions.Proc6<A1, A2, A3, A4, A5, A6> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5, arg6), options, startOperation);
    }

    @Experimental
    public static <R> R executeUpdateWithStart(Functions.Func<R> updateMethod, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(updateMethod::apply, options, startOperation);
    }

    @Experimental
    public static <A1, R> R executeUpdateWithStart(Functions.Func1<A1, R> updateMethod, A1 arg1, @Nonnull UpdateOptions<R> updateOptions, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1), updateOptions, startOperation);
    }

    @Experimental
    public static <A1, A2, R> R executeUpdateWithStart(Functions.Func2<A1, A2, R> updateMethod, A1 arg1, A2 arg2, @Nonnull UpdateOptions<R> updateOptions, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2), updateOptions, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, R> R executeUpdateWithStart(Functions.Func3<A1, A2, A3, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3), options, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, A4, R> R executeUpdateWithStart(Functions.Func4<A1, A2, A3, A4, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4), options, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, A4, A5, R> R executeUpdateWithStart(Functions.Func5<A1, A2, A3, A4, A5, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5), options, startOperation);
    }

    @Experimental
    public static <A1, A2, A3, A4, A5, A6, R> R executeUpdateWithStart(Functions.Func6<A1, A2, A3, A4, A5, A6, R> updateMethod, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6, @Nonnull UpdateOptions<R> options, @Nonnull WithStartWorkflowOperation<?> startOperation) {
        return WorkflowClientInternalImpl.executeUpdateWithStart(() -> updateMethod.apply(arg1, arg2, arg3, arg4, arg5, arg6), options, startOperation);
    }

    public static CompletableFuture<Void> execute(Functions.Proc workflow) {
        return WorkflowClientInternalImpl.execute(workflow);
    }

    public static <A1> CompletableFuture<Void> execute(Functions.Proc1<A1> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.execute(workflow, arg1);
    }

    public static <A1, A2> CompletableFuture<Void> execute(Functions.Proc2<A1, A2> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2);
    }

    public static <A1, A2, A3> CompletableFuture<Void> execute(Functions.Proc3<A1, A2, A3> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4> CompletableFuture<Void> execute(Functions.Proc4<A1, A2, A3, A4> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5> CompletableFuture<Void> execute(Functions.Proc5<A1, A2, A3, A4, A5> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6> CompletableFuture<Void> execute(Functions.Proc6<A1, A2, A3, A4, A5, A6> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static <R> CompletableFuture<R> execute(Functions.Func<R> workflow) {
        return WorkflowClientInternalImpl.execute(workflow);
    }

    public static <A1, R> CompletableFuture<R> execute(Functions.Func1<A1, R> workflow, A1 arg1) {
        return WorkflowClientInternalImpl.execute(workflow, arg1);
    }

    public static <A1, A2, R> CompletableFuture<R> execute(Functions.Func2<A1, A2, R> workflow, A1 arg1, A2 arg2) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2);
    }

    public static <A1, A2, A3, R> CompletableFuture<R> execute(Functions.Func3<A1, A2, A3, R> workflow, A1 arg1, A2 arg2, A3 arg3) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3);
    }

    public static <A1, A2, A3, A4, R> CompletableFuture<R> execute(Functions.Func4<A1, A2, A3, A4, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3, arg4);
    }

    public static <A1, A2, A3, A4, A5, R> CompletableFuture<R> execute(Functions.Func5<A1, A2, A3, A4, A5, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3, arg4, arg5);
    }

    public static <A1, A2, A3, A4, A5, A6, R> CompletableFuture<R> execute(Functions.Func6<A1, A2, A3, A4, A5, A6, R> workflow, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5, A6 arg6) {
        return WorkflowClientInternalImpl.execute(workflow, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public Object getInternal();
}

