/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.temporal.common.Experimental;
import io.temporal.common.interceptors.WorkerInterceptor;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class WorkerFactoryOptions {
    private static final int DEFAULT_WORKFLOW_CACHE_SIZE = 600;
    private static final int DEFAULT_MAX_WORKFLOW_THREAD_COUNT = 600;
    private static final WorkerFactoryOptions DEFAULT_INSTANCE = WorkerFactoryOptions.newBuilder().build();
    private final int workflowCacheSize;
    private final int maxWorkflowThreadCount;
    @Nullable
    private final Duration workflowHostLocalTaskQueueScheduleToStartTimeout;
    private final WorkerInterceptor[] workerInterceptors;
    private final boolean enableLoggingInReplay;
    private final boolean usingVirtualWorkflowThreads;
    private final ExecutorService overrideLocalActivityTaskExecutor;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkerFactoryOptions options) {
        return new Builder(options);
    }

    public static WorkerFactoryOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkerFactoryOptions(int workflowCacheSize, int maxWorkflowThreadCount, @Nullable Duration workflowHostLocalTaskQueueScheduleToStartTimeout, WorkerInterceptor[] workerInterceptors, boolean enableLoggingInReplay, boolean usingVirtualWorkflowThreads, ExecutorService overrideLocalActivityTaskExecutor, boolean validate) {
        if (validate) {
            Preconditions.checkState((workflowCacheSize >= 0 ? 1 : 0) != 0, (Object)"negative workflowCacheSize");
            if (workflowCacheSize <= 0) {
                workflowCacheSize = 600;
            }
            Preconditions.checkState((maxWorkflowThreadCount >= 0 ? 1 : 0) != 0, (Object)"negative maxWorkflowThreadCount");
            if (maxWorkflowThreadCount == 0) {
                maxWorkflowThreadCount = 600;
            }
            if (workflowHostLocalTaskQueueScheduleToStartTimeout != null) {
                Preconditions.checkState((!workflowHostLocalTaskQueueScheduleToStartTimeout.isNegative() ? 1 : 0) != 0, (Object)"negative workflowHostLocalTaskQueueScheduleToStartTimeoutSeconds");
            }
            if (workerInterceptors == null) {
                workerInterceptors = new WorkerInterceptor[]{};
            }
        }
        this.workflowCacheSize = workflowCacheSize;
        this.maxWorkflowThreadCount = maxWorkflowThreadCount;
        this.workflowHostLocalTaskQueueScheduleToStartTimeout = workflowHostLocalTaskQueueScheduleToStartTimeout;
        this.workerInterceptors = workerInterceptors;
        this.enableLoggingInReplay = enableLoggingInReplay;
        this.usingVirtualWorkflowThreads = usingVirtualWorkflowThreads;
        this.overrideLocalActivityTaskExecutor = overrideLocalActivityTaskExecutor;
    }

    public int getWorkflowCacheSize() {
        return this.workflowCacheSize;
    }

    public int getMaxWorkflowThreadCount() {
        return this.maxWorkflowThreadCount;
    }

    @Nullable
    public Duration getWorkflowHostLocalTaskQueueScheduleToStartTimeout() {
        return this.workflowHostLocalTaskQueueScheduleToStartTimeout;
    }

    public WorkerInterceptor[] getWorkerInterceptors() {
        return this.workerInterceptors;
    }

    public boolean isEnableLoggingInReplay() {
        return this.enableLoggingInReplay;
    }

    @Experimental
    public boolean isUsingVirtualWorkflowThreads() {
        return this.usingVirtualWorkflowThreads;
    }

    ExecutorService getOverrideLocalActivityTaskExecutor() {
        return this.overrideLocalActivityTaskExecutor;
    }

    @Deprecated
    public int getWorkflowHostLocalPollThreadCount() {
        return 0;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Duration workflowHostLocalTaskQueueScheduleToStartTimeout;
        private int workflowCacheSize;
        private int maxWorkflowThreadCount;
        private WorkerInterceptor[] workerInterceptors;
        private boolean enableLoggingInReplay;
        private boolean usingVirtualWorkflowThreads;
        private ExecutorService overrideLocalActivityTaskExecutor;

        private Builder() {
        }

        private Builder(WorkerFactoryOptions options) {
            if (options == null) {
                return;
            }
            this.workflowHostLocalTaskQueueScheduleToStartTimeout = options.workflowHostLocalTaskQueueScheduleToStartTimeout;
            this.workflowCacheSize = options.workflowCacheSize;
            this.maxWorkflowThreadCount = options.maxWorkflowThreadCount;
            this.workerInterceptors = options.workerInterceptors;
            this.enableLoggingInReplay = options.enableLoggingInReplay;
            this.usingVirtualWorkflowThreads = options.usingVirtualWorkflowThreads;
            this.overrideLocalActivityTaskExecutor = options.overrideLocalActivityTaskExecutor;
        }

        public Builder setWorkflowCacheSize(int workflowCacheSize) {
            this.workflowCacheSize = workflowCacheSize;
            return this;
        }

        public Builder setMaxWorkflowThreadCount(int maxWorkflowThreadCount) {
            this.maxWorkflowThreadCount = maxWorkflowThreadCount;
            return this;
        }

        @Deprecated
        public Builder setWorkflowHostLocalTaskQueueScheduleToStartTimeout(Duration timeout) {
            this.workflowHostLocalTaskQueueScheduleToStartTimeout = timeout;
            return this;
        }

        public Builder setWorkerInterceptors(WorkerInterceptor ... workerInterceptors) {
            this.workerInterceptors = workerInterceptors;
            return this;
        }

        public Builder setEnableLoggingInReplay(boolean enableLoggingInReplay) {
            this.enableLoggingInReplay = enableLoggingInReplay;
            return this;
        }

        @Experimental
        public Builder setUsingVirtualWorkflowThreads(boolean usingVirtualWorkflowThreads) {
            this.usingVirtualWorkflowThreads = usingVirtualWorkflowThreads;
            return this;
        }

        @Deprecated
        public Builder setWorkflowHostLocalPollThreadCount(int workflowHostLocalPollThreadCount) {
            return this;
        }

        @VisibleForTesting
        Builder setOverrideLocalActivityTaskExecutor(ExecutorService overrideLocalActivityTaskExecutor) {
            this.overrideLocalActivityTaskExecutor = overrideLocalActivityTaskExecutor;
            return this;
        }

        public WorkerFactoryOptions build() {
            return new WorkerFactoryOptions(this.workflowCacheSize, this.maxWorkflowThreadCount, this.workflowHostLocalTaskQueueScheduleToStartTimeout, this.workerInterceptors, this.enableLoggingInReplay, this.usingVirtualWorkflowThreads, this.overrideLocalActivityTaskExecutor, false);
        }

        public WorkerFactoryOptions validateAndBuildWithDefaults() {
            return new WorkerFactoryOptions(this.workflowCacheSize, this.maxWorkflowThreadCount, this.workflowHostLocalTaskQueueScheduleToStartTimeout, this.workerInterceptors == null ? new WorkerInterceptor[]{} : this.workerInterceptors, this.enableLoggingInReplay, this.usingVirtualWorkflowThreads, this.overrideLocalActivityTaskExecutor, true);
        }
    }
}

