/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.common.Experimental;
import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.ResourceBasedController;
import io.temporal.worker.tuning.ResourceBasedSlotOptions;
import io.temporal.worker.tuning.ResourceBasedTuner;
import io.temporal.worker.tuning.SlotInfo;
import io.temporal.worker.tuning.SlotMarkUsedContext;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseContext;
import io.temporal.worker.tuning.SlotReserveContext;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;

@Experimental
public class ResourceBasedSlotSupplier<SI extends SlotInfo>
implements SlotSupplier<SI> {
    private final ResourceBasedController resourceController;
    private final ResourceBasedSlotOptions options;
    private Instant lastSlotIssuedAt = Instant.EPOCH;

    public static ResourceBasedSlotSupplier<WorkflowSlotInfo> createForWorkflow(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<WorkflowSlotInfo>(WorkflowSlotInfo.class, resourceBasedController, options);
    }

    public static ResourceBasedSlotSupplier<ActivitySlotInfo> createForActivity(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<ActivitySlotInfo>(ActivitySlotInfo.class, resourceBasedController, options);
    }

    public static ResourceBasedSlotSupplier<LocalActivitySlotInfo> createForLocalActivity(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<LocalActivitySlotInfo>(LocalActivitySlotInfo.class, resourceBasedController, options);
    }

    public static ResourceBasedSlotSupplier<NexusSlotInfo> createForNexus(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<NexusSlotInfo>(NexusSlotInfo.class, resourceBasedController, options);
    }

    private ResourceBasedSlotSupplier(Class<SI> clazz, ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        this.resourceController = resourceBasedController;
        this.options = WorkflowSlotInfo.class.isAssignableFrom(clazz) ? ResourceBasedSlotOptions.newBuilder().setMinimumSlots(options.getMinimumSlots() == 0 ? ResourceBasedTuner.DEFAULT_WORKFLOW_SLOT_OPTIONS.getMinimumSlots() : options.getMinimumSlots()).setMaximumSlots(options.getMaximumSlots() == 0 ? ResourceBasedTuner.DEFAULT_WORKFLOW_SLOT_OPTIONS.getMaximumSlots() : options.getMaximumSlots()).setRampThrottle(options.getRampThrottle() == null ? ResourceBasedTuner.DEFAULT_WORKFLOW_SLOT_OPTIONS.getRampThrottle() : options.getRampThrottle()).build() : (ActivitySlotInfo.class.isAssignableFrom(clazz) || LocalActivitySlotInfo.class.isAssignableFrom(clazz) ? ResourceBasedSlotOptions.newBuilder().setMinimumSlots(options.getMinimumSlots() == 0 ? ResourceBasedTuner.DEFAULT_ACTIVITY_SLOT_OPTIONS.getMinimumSlots() : options.getMinimumSlots()).setMaximumSlots(options.getMaximumSlots() == 0 ? ResourceBasedTuner.DEFAULT_ACTIVITY_SLOT_OPTIONS.getMaximumSlots() : options.getMaximumSlots()).setRampThrottle(options.getRampThrottle() == null ? ResourceBasedTuner.DEFAULT_ACTIVITY_SLOT_OPTIONS.getRampThrottle() : options.getRampThrottle()).build() : ResourceBasedSlotOptions.newBuilder().setMinimumSlots(options.getMinimumSlots() == 0 ? ResourceBasedTuner.DEFAULT_NEXUS_SLOT_OPTIONS.getMinimumSlots() : options.getMinimumSlots()).setMaximumSlots(options.getMaximumSlots() == 0 ? ResourceBasedTuner.DEFAULT_NEXUS_SLOT_OPTIONS.getMaximumSlots() : options.getMaximumSlots()).setRampThrottle(options.getRampThrottle() == null ? ResourceBasedTuner.DEFAULT_NEXUS_SLOT_OPTIONS.getRampThrottle() : options.getRampThrottle()).build());
    }

    @Override
    public SlotPermit reserveSlot(SlotReserveContext<SI> ctx) throws InterruptedException {
        while (ctx.getNumIssuedSlots() >= this.options.getMinimumSlots()) {
            Optional<SlotPermit> permit;
            Duration mustWaitFor;
            try {
                mustWaitFor = this.options.getRampThrottle().minus(this.timeSinceLastSlotIssued());
            }
            catch (ArithmeticException e) {
                mustWaitFor = Duration.ZERO;
            }
            if (mustWaitFor.compareTo(Duration.ZERO) > 0) {
                Thread.sleep(mustWaitFor.toMillis());
            }
            if ((permit = this.tryReserveSlot(ctx)).isPresent()) {
                return permit.get();
            }
            Thread.sleep(10L);
        }
        return new SlotPermit();
    }

    @Override
    public Optional<SlotPermit> tryReserveSlot(SlotReserveContext<SI> ctx) {
        int numIssued = ctx.getNumIssuedSlots();
        if (numIssued < this.options.getMinimumSlots() || this.timeSinceLastSlotIssued().compareTo(this.options.getRampThrottle()) > 0 && numIssued < this.options.getMaximumSlots() && this.resourceController.pidDecision()) {
            this.lastSlotIssuedAt = Instant.now();
            return Optional.of(new SlotPermit());
        }
        return Optional.empty();
    }

    @Override
    public void markSlotUsed(SlotMarkUsedContext<SI> ctx) {
    }

    @Override
    public void releaseSlot(SlotReleaseContext<SI> ctx) {
    }

    public ResourceBasedController getResourceController() {
        return this.resourceController;
    }

    private Duration timeSinceLastSlotIssued() {
        return Duration.between(this.lastSlotIssuedAt, Instant.now());
    }
}

