/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.activity;

import com.google.common.base.Objects;
import io.temporal.common.Experimental;
import io.temporal.common.MethodRetry;
import io.temporal.common.RetryOptions;
import java.time.Duration;

public final class LocalActivityOptions {
    private static final LocalActivityOptions DEFAULT_INSTANCE = LocalActivityOptions.newBuilder().build();
    private final Duration scheduleToCloseTimeout;
    private final Duration localRetryThreshold;
    private final Duration startToCloseTimeout;
    private final Duration scheduleToStartTimeout;
    private final RetryOptions retryOptions;
    private final Boolean doNotIncludeArgumentsIntoMarker;
    private final String summary;

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public static Builder newBuilder(LocalActivityOptions o) {
        return new Builder(o);
    }

    public static LocalActivityOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private LocalActivityOptions(Duration startToCloseTimeout, Duration scheduleToCloseTimeout, Duration scheduleToStartTimeout, Duration localRetryThreshold, RetryOptions retryOptions, Boolean doNotIncludeArgumentsIntoMarker, String summary) {
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        this.startToCloseTimeout = startToCloseTimeout;
        this.scheduleToStartTimeout = scheduleToStartTimeout;
        this.localRetryThreshold = localRetryThreshold;
        this.retryOptions = retryOptions;
        this.doNotIncludeArgumentsIntoMarker = doNotIncludeArgumentsIntoMarker;
        this.summary = summary;
    }

    public Duration getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public Duration getStartToCloseTimeout() {
        return this.startToCloseTimeout;
    }

    public Duration getScheduleToStartTimeout() {
        return this.scheduleToStartTimeout;
    }

    public Duration getLocalRetryThreshold() {
        return this.localRetryThreshold;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public boolean isDoNotIncludeArgumentsIntoMarker() {
        return this.doNotIncludeArgumentsIntoMarker != null && this.doNotIncludeArgumentsIntoMarker != false;
    }

    @Experimental
    public String getSummary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalActivityOptions)) {
            return false;
        }
        LocalActivityOptions that = (LocalActivityOptions)o;
        return Objects.equal((Object)this.doNotIncludeArgumentsIntoMarker, (Object)that.doNotIncludeArgumentsIntoMarker) && Objects.equal((Object)this.scheduleToCloseTimeout, (Object)that.scheduleToCloseTimeout) && Objects.equal((Object)this.startToCloseTimeout, (Object)that.startToCloseTimeout) && Objects.equal((Object)this.scheduleToStartTimeout, (Object)that.scheduleToStartTimeout) && Objects.equal((Object)this.localRetryThreshold, (Object)that.localRetryThreshold) && Objects.equal((Object)this.retryOptions, (Object)that.retryOptions) && Objects.equal((Object)this.summary, (Object)that.summary);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scheduleToCloseTimeout, this.startToCloseTimeout, this.scheduleToStartTimeout, this.localRetryThreshold, this.retryOptions, this.doNotIncludeArgumentsIntoMarker, this.summary});
    }

    public String toString() {
        return "LocalActivityOptions{scheduleToCloseTimeout=" + this.scheduleToCloseTimeout + ", localRetryThreshold=" + this.localRetryThreshold + ", startToCloseTimeout=" + this.startToCloseTimeout + ", retryOptions=" + this.retryOptions + ", doNotIncludeArgumentsIntoMarker=" + this.isDoNotIncludeArgumentsIntoMarker() + ", summary=" + this.summary + '}';
    }

    public static final class Builder {
        private Duration scheduleToCloseTimeout;
        private Duration startToCloseTimeout;
        private Duration scheduleToStartTimeout;
        private Duration localRetryThreshold;
        private RetryOptions retryOptions;
        private Boolean doNotIncludeArgumentsIntoMarker;
        private String summary;

        private Builder(LocalActivityOptions options) {
            if (options == null) {
                return;
            }
            this.scheduleToCloseTimeout = options.getScheduleToCloseTimeout();
            this.startToCloseTimeout = options.getStartToCloseTimeout();
            this.scheduleToStartTimeout = options.getScheduleToStartTimeout();
            this.localRetryThreshold = options.getLocalRetryThreshold();
            this.retryOptions = options.getRetryOptions();
            this.doNotIncludeArgumentsIntoMarker = options.isDoNotIncludeArgumentsIntoMarker();
            this.summary = options.getSummary();
        }

        public Builder setScheduleToCloseTimeout(Duration timeout) {
            if (timeout.isZero() || timeout.isNegative()) {
                throw new IllegalArgumentException("Illegal timeout: " + timeout);
            }
            this.scheduleToCloseTimeout = timeout;
            return this;
        }

        public Builder setScheduleToStartTimeout(Duration timeout) {
            if (timeout.isZero() || timeout.isNegative()) {
                throw new IllegalArgumentException("Illegal timeout: " + timeout);
            }
            this.scheduleToStartTimeout = timeout;
            return this;
        }

        public Builder setStartToCloseTimeout(Duration timeout) {
            if (timeout.isZero() || timeout.isNegative()) {
                throw new IllegalArgumentException("Illegal timeout: " + timeout);
            }
            this.startToCloseTimeout = timeout;
            return this;
        }

        public Builder setLocalRetryThreshold(Duration localRetryThreshold) {
            if (localRetryThreshold.isZero() || localRetryThreshold.isNegative()) {
                throw new IllegalArgumentException("Illegal threshold: " + localRetryThreshold);
            }
            this.localRetryThreshold = localRetryThreshold;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setMethodRetry(MethodRetry r) {
            if (r != null) {
                this.retryOptions = RetryOptions.merge(r, this.retryOptions);
            }
            return this;
        }

        public Builder setDoNotIncludeArgumentsIntoMarker(boolean doNotIncludeArgumentsIntoMarker) {
            this.doNotIncludeArgumentsIntoMarker = doNotIncludeArgumentsIntoMarker;
            return this;
        }

        @Experimental
        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder mergeActivityOptions(LocalActivityOptions override) {
            if (override == null) {
                return this;
            }
            this.scheduleToCloseTimeout = override.scheduleToCloseTimeout == null ? this.scheduleToCloseTimeout : override.scheduleToCloseTimeout;
            this.startToCloseTimeout = override.startToCloseTimeout == null ? this.startToCloseTimeout : override.startToCloseTimeout;
            this.scheduleToStartTimeout = override.scheduleToStartTimeout == null ? this.scheduleToStartTimeout : override.scheduleToStartTimeout;
            this.localRetryThreshold = override.localRetryThreshold == null ? this.localRetryThreshold : override.localRetryThreshold;
            this.retryOptions = override.retryOptions == null ? this.retryOptions : override.retryOptions;
            this.doNotIncludeArgumentsIntoMarker = override.doNotIncludeArgumentsIntoMarker != null ? override.doNotIncludeArgumentsIntoMarker : this.doNotIncludeArgumentsIntoMarker;
            this.summary = override.summary == null ? this.summary : override.summary;
            return this;
        }

        public LocalActivityOptions build() {
            return new LocalActivityOptions(this.startToCloseTimeout, this.scheduleToCloseTimeout, this.scheduleToStartTimeout, this.localRetryThreshold, this.retryOptions, this.doNotIncludeArgumentsIntoMarker, this.summary);
        }

        public LocalActivityOptions validateAndBuildWithDefaults() {
            if (this.startToCloseTimeout == null && this.scheduleToCloseTimeout == null) {
                throw new IllegalArgumentException("one of the startToCloseTimeout or scheduleToCloseTimeout is required");
            }
            return new LocalActivityOptions(this.startToCloseTimeout, this.scheduleToCloseTimeout, this.scheduleToStartTimeout, this.localRetryThreshold, RetryOptions.newBuilder(this.retryOptions).validateBuildWithDefaults(), this.doNotIncludeArgumentsIntoMarker, this.summary);
        }
    }
}

