/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.api.common.v1.Payload;
import io.temporal.client.schedules.ScheduleListInfo;
import io.temporal.client.schedules.ScheduleListSchedule;
import io.temporal.common.converter.DataConverter;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ScheduleListDescription {
    private final String scheduleId;
    private final ScheduleListSchedule schedule;
    private final ScheduleListInfo info;
    private final Map<String, Payload> memos;
    @Nonnull
    private final DataConverter dataConverter;
    private final Map<String, ?> searchAttributes;

    public ScheduleListDescription(String scheduleId, ScheduleListSchedule schedule, ScheduleListInfo info, Map<String, Payload> memos, @Nonnull DataConverter dataConverter, Map<String, ?> searchAttributes) {
        this.scheduleId = scheduleId;
        this.schedule = schedule;
        this.info = info;
        this.memos = memos;
        this.dataConverter = dataConverter;
        this.searchAttributes = searchAttributes;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public ScheduleListSchedule getSchedule() {
        return this.schedule;
    }

    public ScheduleListInfo getInfo() {
        return this.info;
    }

    @Nullable
    public <T> Object getMemo(String key, Class<T> valueClass) {
        return this.getMemo(key, valueClass, valueClass);
    }

    @Nullable
    public <T> T getMemo(String key, Class<T> valueClass, Type genericType) {
        Payload memo = this.memos.get(key);
        if (memo == null) {
            return null;
        }
        return this.dataConverter.fromPayload(memo, valueClass, genericType);
    }

    public Map<String, ?> getSearchAttributes() {
        return this.searchAttributes;
    }
}

