/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.nexus;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nexusrpc.Link;
import io.nexusrpc.OperationInfo;
import io.nexusrpc.handler.HandlerException;
import io.nexusrpc.handler.OperationCancelDetails;
import io.nexusrpc.handler.OperationContext;
import io.nexusrpc.handler.OperationFetchInfoDetails;
import io.nexusrpc.handler.OperationFetchResultDetails;
import io.nexusrpc.handler.OperationHandler;
import io.nexusrpc.handler.OperationStartDetails;
import io.nexusrpc.handler.OperationStartResult;
import io.temporal.api.common.v1.Link;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.EventType;
import io.temporal.client.WorkflowClient;
import io.temporal.internal.client.NexusStartWorkflowRequest;
import io.temporal.internal.common.LinkConverter;
import io.temporal.internal.common.NexusUtil;
import io.temporal.internal.nexus.CurrentNexusOperationContext;
import io.temporal.internal.nexus.InternalNexusOperationContext;
import io.temporal.internal.nexus.OperationTokenUtil;
import io.temporal.nexus.WorkflowHandle;
import io.temporal.nexus.WorkflowHandleFactory;
import java.net.URISyntaxException;

class WorkflowRunOperationImpl<T, R>
implements OperationHandler<T, R> {
    private final WorkflowHandleFactory<T, R> handleFactory;

    WorkflowRunOperationImpl(WorkflowHandleFactory<T, R> handleFactory) {
        this.handleFactory = handleFactory;
    }

    public OperationStartResult<R> start(OperationContext ctx, OperationStartDetails operationStartDetails, T input) {
        String operationToken;
        InternalNexusOperationContext nexusCtx = CurrentNexusOperationContext.get();
        WorkflowHandle<R> handle = this.handleFactory.apply(ctx, operationStartDetails, input);
        NexusStartWorkflowRequest nexusRequest = new NexusStartWorkflowRequest(operationStartDetails.getRequestId(), operationStartDetails.getCallbackUrl(), operationStartDetails.getCallbackHeaders(), nexusCtx.getTaskQueue(), operationStartDetails.getLinks());
        WorkflowExecution workflowExec = handle.getInvoker().invoke(nexusRequest);
        Link.WorkflowEvent workflowEventLink = Link.WorkflowEvent.newBuilder().setNamespace(nexusCtx.getNamespace()).setWorkflowId(workflowExec.getWorkflowId()).setRunId(workflowExec.getRunId()).setEventRef(Link.WorkflowEvent.EventReference.newBuilder().setEventType(EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED)).build();
        io.temporal.api.nexus.v1.Link nexusLink = LinkConverter.workflowEventToNexusLink(workflowEventLink);
        try {
            operationToken = OperationTokenUtil.generateWorkflowRunOperationToken(workflowExec.getWorkflowId(), nexusCtx.getNamespace());
        }
        catch (JsonProcessingException e) {
            throw new HandlerException(HandlerException.ErrorType.BAD_REQUEST, (Throwable)new IllegalArgumentException("failed to generate workflow operation token", e));
        }
        OperationStartResult.Builder result = OperationStartResult.newAsyncBuilder((String)operationToken);
        if (nexusLink != null) {
            try {
                ctx.addLinks(new Link[]{NexusUtil.nexusProtoLinkToLink(nexusLink)});
            }
            catch (URISyntaxException e) {
                throw new HandlerException(HandlerException.ErrorType.INTERNAL, (Throwable)new IllegalArgumentException("failed to parse URI", e));
            }
        }
        return result.build();
    }

    public R fetchResult(OperationContext operationContext, OperationFetchResultDetails operationFetchResultDetails) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public OperationInfo fetchInfo(OperationContext operationContext, OperationFetchInfoDetails operationFetchInfoDetails) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void cancel(OperationContext operationContext, OperationCancelDetails operationCancelDetails) {
        String workflowId;
        try {
            workflowId = OperationTokenUtil.loadWorkflowIdFromOperationToken(operationCancelDetails.getOperationToken());
        }
        catch (IllegalArgumentException e) {
            throw new HandlerException(HandlerException.ErrorType.BAD_REQUEST, (Throwable)new IllegalArgumentException("failed to parse operation token", e));
        }
        WorkflowClient client = CurrentNexusOperationContext.get().getWorkflowClient();
        client.newUntypedWorkflowStub(workflowId).cancel();
    }
}

