/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.internal.common.ProtocolType;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.internal.statemachines.Transition;
import io.temporal.internal.statemachines.TransitionAction;
import io.temporal.internal.statemachines.TransitionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StateMachine<State, ExplicitEvent, Data> {
    private static final Logger log = LoggerFactory.getLogger(StateMachine.class);
    private final StateMachineDefinition<State, ExplicitEvent, Data> definition;
    private final List<Transition<State, TransitionEvent<ExplicitEvent>>> transitionHistory = new ArrayList<Transition<State, TransitionEvent<ExplicitEvent>>>();
    @Nullable
    private final String entityName;
    private State state;

    public static <State, ExplicitEvent, Data> StateMachine<State, ExplicitEvent, Data> newInstance(StateMachineDefinition<State, ExplicitEvent, Data> definition, @Nullable String entityName) {
        return new StateMachine<State, ExplicitEvent, Data>(definition, entityName);
    }

    private StateMachine(StateMachineDefinition<State, ExplicitEvent, Data> definition, @Nullable String entityName) {
        this.definition = Objects.requireNonNull(definition);
        this.entityName = entityName;
        this.state = definition.getInitialState();
    }

    public Set<EventType> getValidEventTypes() {
        return this.definition.getValidEventTypes();
    }

    public State getState() {
        return this.state;
    }

    public boolean isFinalState() {
        return this.definition.isFinalState(this.state);
    }

    public void handleExplicitEvent(ExplicitEvent explicitEvent, Data data) {
        this.executeTransition(new TransitionEvent<ExplicitEvent>(explicitEvent), data);
    }

    public void handleHistoryEvent(EventType eventType, Data data) {
        this.executeTransition(new TransitionEvent(eventType), data);
    }

    public void handleMessage(ProtocolType messageType, Data data) {
        this.executeTransition(new TransitionEvent(messageType), data);
    }

    public void handleCommand(CommandType commandType, Data data) {
        this.executeTransition(new TransitionEvent(commandType), data);
    }

    public String getHistory() {
        return this.transitionHistory.toString();
    }

    List<Transition<State, TransitionEvent<ExplicitEvent>>> getTransitionHistory() {
        return this.transitionHistory;
    }

    public String toString() {
        return "StateMachine{definition=" + this.definition + ", state=" + this.state + ", transitionHistory=" + this.transitionHistory + '}';
    }

    private void executeTransition(TransitionEvent<ExplicitEvent> transitionEvent, Data data) {
        Transition<State, TransitionEvent<ExplicitEvent>> transition = new Transition<State, TransitionEvent<ExplicitEvent>>(this.state, transitionEvent);
        TransitionAction<State, Data> destination = this.definition.getTransitionAction(transition);
        if (destination == null) {
            throw new IllegalArgumentException(this.stateMachineNameString() + ": invalid " + transition + ", transition history is " + this.transitionHistory);
        }
        try {
            this.state = destination.apply(data);
            this.logTransition(transition);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(this.stateMachineNameString() + ": failure executing " + transition + ", transition history is " + this.transitionHistory, e);
        }
        this.transitionHistory.add(transition);
    }

    private void logTransition(Transition<State, TransitionEvent<ExplicitEvent>> transition) {
        if (log.isTraceEnabled()) {
            log.trace("State Machine {}: {} --:{}:--> {}", new Object[]{this.stateMachineNameString(), transition.from, transition.event, this.state});
        }
    }

    private String stateMachineNameString() {
        return this.definition.getName() + (this.entityName != null && !this.entityName.isEmpty() ? "[" + this.entityName + "]" : "");
    }
}

