/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.common.Experimental;
import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.ResourceBasedController;
import io.temporal.worker.tuning.ResourceBasedSlotSupplier;
import io.temporal.worker.tuning.SlotInfo;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.WorkerTuner;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.util.Objects;
import javax.annotation.Nonnull;

@Experimental
public class CompositeTuner
implements WorkerTuner {
    @Nonnull
    private final SlotSupplier<WorkflowSlotInfo> workflowTaskSlotSupplier;
    @Nonnull
    private final SlotSupplier<ActivitySlotInfo> activityTaskSlotSupplier;
    @Nonnull
    private final SlotSupplier<LocalActivitySlotInfo> localActivitySlotSupplier;
    @Nonnull
    private final SlotSupplier<NexusSlotInfo> nexusSlotSupplier;

    public CompositeTuner(@Nonnull SlotSupplier<WorkflowSlotInfo> workflowTaskSlotSupplier, @Nonnull SlotSupplier<ActivitySlotInfo> activityTaskSlotSupplier, @Nonnull SlotSupplier<LocalActivitySlotInfo> localActivitySlotSupplier, @Nonnull SlotSupplier<NexusSlotInfo> nexusSlotSupplier) {
        this.workflowTaskSlotSupplier = Objects.requireNonNull(workflowTaskSlotSupplier);
        this.activityTaskSlotSupplier = Objects.requireNonNull(activityTaskSlotSupplier);
        this.localActivitySlotSupplier = Objects.requireNonNull(localActivitySlotSupplier);
        this.nexusSlotSupplier = Objects.requireNonNull(nexusSlotSupplier);
        this.validateResourceController(workflowTaskSlotSupplier, activityTaskSlotSupplier);
        this.validateResourceController(workflowTaskSlotSupplier, localActivitySlotSupplier);
        this.validateResourceController(activityTaskSlotSupplier, localActivitySlotSupplier);
        this.validateResourceController(workflowTaskSlotSupplier, nexusSlotSupplier);
    }

    @Override
    @Nonnull
    public SlotSupplier<WorkflowSlotInfo> getWorkflowTaskSlotSupplier() {
        return this.workflowTaskSlotSupplier;
    }

    @Override
    @Nonnull
    public SlotSupplier<ActivitySlotInfo> getActivityTaskSlotSupplier() {
        return this.activityTaskSlotSupplier;
    }

    @Override
    @Nonnull
    public SlotSupplier<LocalActivitySlotInfo> getLocalActivitySlotSupplier() {
        return this.localActivitySlotSupplier;
    }

    @Override
    @Nonnull
    public SlotSupplier<NexusSlotInfo> getNexusSlotSupplier() {
        return this.nexusSlotSupplier;
    }

    private <T extends SlotInfo, U extends SlotInfo> void validateResourceController(@Nonnull SlotSupplier<T> supplier1, @Nonnull SlotSupplier<U> supplier2) {
        ResourceBasedController controller2;
        ResourceBasedController controller1;
        if (supplier1 instanceof ResourceBasedSlotSupplier && supplier2 instanceof ResourceBasedSlotSupplier && (controller1 = ((ResourceBasedSlotSupplier)supplier1).getResourceController()) != (controller2 = ((ResourceBasedSlotSupplier)supplier2).getResourceController())) {
            throw new IllegalArgumentException("All resource-based slot suppliers must use the same ResourceController");
        }
    }
}

