/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client.schedules;

import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.GlobalDataConverter;
import io.temporal.common.interceptors.ScheduleClientInterceptor;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;

public final class ScheduleClientOptions {
    private static final ScheduleClientOptions DEFAULT_INSTANCE = ScheduleClientOptions.newBuilder().build();
    private final String namespace;
    private final DataConverter dataConverter;
    private final String identity;
    private final List<ContextPropagator> contextPropagators;
    private final List<ScheduleClientInterceptor> interceptors;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ScheduleClientOptions options) {
        return new Builder(options);
    }

    public static ScheduleClientOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ScheduleClientOptions(String namespace, DataConverter dataConverter, String identity, List<ContextPropagator> contextPropagators, List<ScheduleClientInterceptor> interceptors) {
        this.namespace = namespace;
        this.dataConverter = dataConverter;
        this.identity = identity;
        this.contextPropagators = contextPropagators;
        this.interceptors = interceptors;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public String getIdentity() {
        return this.identity;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public List<ScheduleClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public static final class Builder {
        private static final String DEFAULT_NAMESPACE = "default";
        private static final List<ContextPropagator> EMPTY_CONTEXT_PROPAGATORS = Collections.emptyList();
        private static final List<ScheduleClientInterceptor> EMPTY_INTERCEPTORS = Collections.emptyList();
        private String namespace;
        private DataConverter dataConverter;
        private String identity;
        private List<ContextPropagator> contextPropagators;
        private List<ScheduleClientInterceptor> interceptors;

        private Builder() {
        }

        private Builder(ScheduleClientOptions options) {
            if (options == null) {
                return;
            }
            this.namespace = options.namespace;
            this.dataConverter = options.dataConverter;
            this.identity = options.identity;
            this.contextPropagators = options.contextPropagators;
            this.interceptors = options.interceptors;
        }

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setDataConverter(DataConverter dataConverter) {
            this.dataConverter = dataConverter;
            return this;
        }

        public Builder setIdentity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setInterceptors(List<ScheduleClientInterceptor> interceptors) {
            this.interceptors = interceptors;
            return this;
        }

        public ScheduleClientOptions build() {
            String name = this.identity == null ? ManagementFactory.getRuntimeMXBean().getName() : this.identity;
            return new ScheduleClientOptions(this.namespace == null ? DEFAULT_NAMESPACE : this.namespace, this.dataConverter == null ? GlobalDataConverter.get() : this.dataConverter, name, this.contextPropagators == null ? EMPTY_CONTEXT_PROPAGATORS : this.contextPropagators, this.interceptors == null ? EMPTY_INTERCEPTORS : this.interceptors);
        }
    }
}

