/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.workflowservice.v1.DescribeWorkflowExecutionResponse;
import io.temporal.client.WorkflowExecutionMetadata;
import io.temporal.common.Experimental;
import io.temporal.common.converter.DataConverter;
import io.temporal.payload.context.WorkflowSerializationContext;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowExecutionDescription
extends WorkflowExecutionMetadata {
    @Nonnull
    private final DataConverter dataConverter;
    @Nonnull
    private final DescribeWorkflowExecutionResponse response;

    public WorkflowExecutionDescription(@Nonnull DescribeWorkflowExecutionResponse response, @Nonnull DataConverter dataConverter) {
        super(response.getWorkflowExecutionInfo(), dataConverter);
        this.dataConverter = dataConverter;
        this.response = response;
    }

    @Experimental
    @Nullable
    public String getStaticSummary() {
        if (!this.response.getExecutionConfig().getUserMetadata().hasSummary()) {
            return null;
        }
        return this.dataConverter.withContext(new WorkflowSerializationContext(this.response.getWorkflowExecutionInfo().getParentNamespaceId(), this.response.getWorkflowExecutionInfo().getExecution().getWorkflowId())).fromPayload(this.response.getExecutionConfig().getUserMetadata().getSummary(), String.class, (Type)((Object)String.class));
    }

    @Experimental
    @Nullable
    public String getStaticDetails() {
        if (!this.response.getExecutionConfig().getUserMetadata().hasDetails()) {
            return null;
        }
        return this.dataConverter.withContext(new WorkflowSerializationContext(this.response.getWorkflowExecutionInfo().getParentNamespaceId(), this.response.getWorkflowExecutionInfo().getExecution().getWorkflowId())).fromPayload(this.response.getExecutionConfig().getUserMetadata().getDetails(), String.class, (Type)((Object)String.class));
    }

    public DescribeWorkflowExecutionResponse getRawDescription() {
        return this.response;
    }
}

