/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.temporal.api.command.v1.CancelWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ModifyWorkflowPropertiesCommandAttributes;
import io.temporal.api.command.v1.ProtocolMessageCommandAttributes;
import io.temporal.api.command.v1.RequestCancelExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.RequestCancelNexusOperationCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.ScheduleNexusOperationCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartTimerCommandAttributes;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.ActivityTaskScheduledEventAttributes;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.api.history.v1.NexusOperationCancelRequestedEventAttributes;
import io.temporal.api.history.v1.NexusOperationScheduledEventAttributes;
import io.temporal.api.history.v1.StartChildWorkflowExecutionInitiatedEventAttributes;
import io.temporal.api.history.v1.TimerStartedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionUpdateAcceptedEventAttributes;
import io.temporal.api.history.v1.WorkflowExecutionUpdateAdmittedEventAttributes;
import io.temporal.api.history.v1.WorkflowTaskCompletedEventAttributes;
import io.temporal.api.sdk.v1.UserMetadata;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.common.ProtocolType;
import io.temporal.internal.common.ProtocolUtils;
import io.temporal.internal.common.SdkFlag;
import io.temporal.internal.common.SdkFlags;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.internal.history.LocalActivityMarkerUtils;
import io.temporal.internal.history.VersionMarkerUtils;
import io.temporal.internal.statemachines.ActivityStateMachine;
import io.temporal.internal.statemachines.CancelExternalStateMachine;
import io.temporal.internal.statemachines.CancelNexusOperationStateMachine;
import io.temporal.internal.statemachines.CancelWorkflowStateMachine;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.ChildWorkflowStateMachine;
import io.temporal.internal.statemachines.CompleteWorkflowStateMachine;
import io.temporal.internal.statemachines.ContinueAsNewWorkflowStateMachine;
import io.temporal.internal.statemachines.EntityStateMachine;
import io.temporal.internal.statemachines.ExecuteActivityParameters;
import io.temporal.internal.statemachines.ExecuteLocalActivityParameters;
import io.temporal.internal.statemachines.FailWorkflowStateMachine;
import io.temporal.internal.statemachines.InternalWorkflowTaskException;
import io.temporal.internal.statemachines.LocalActivityCallback;
import io.temporal.internal.statemachines.LocalActivityStateMachine;
import io.temporal.internal.statemachines.MutableSideEffectStateMachine;
import io.temporal.internal.statemachines.NexusOperationStateMachine;
import io.temporal.internal.statemachines.SideEffectStateMachine;
import io.temporal.internal.statemachines.SignalExternalStateMachine;
import io.temporal.internal.statemachines.StartChildWorkflowExecutionParameters;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StatesMachinesCallback;
import io.temporal.internal.statemachines.TimerStateMachine;
import io.temporal.internal.statemachines.UpdateProtocolStateMachine;
import io.temporal.internal.statemachines.UpsertSearchAttributesStateMachine;
import io.temporal.internal.statemachines.VersionStateMachine;
import io.temporal.internal.statemachines.WFTBuffer;
import io.temporal.internal.statemachines.WorkflowPropertiesModifiedStateMachine;
import io.temporal.internal.statemachines.WorkflowTaskStateMachine;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.internal.worker.LocalActivityResult;
import io.temporal.serviceclient.CheckedExceptionWrapper;
import io.temporal.serviceclient.Version;
import io.temporal.worker.NonDeterministicException;
import io.temporal.workflow.ChildWorkflowCancellationType;
import io.temporal.workflow.Functions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class WorkflowStateMachines {
    @VisibleForTesting
    public static List<SdkFlag> initialFlags = Collections.unmodifiableList(Arrays.asList(SdkFlag.SKIP_YIELD_ON_DEFAULT_VERSION));
    private long workflowTaskStartedEventId;
    private long lastWFTStartedEventId;
    private String currentTaskBuildId;
    private long historySize;
    private boolean isContinueAsNewSuggested;
    private long lastHandledEventId;
    private final StatesMachinesCallback callbacks;
    private final Functions.Proc1<CancellableCommand> commandSink;
    private String currentRunId;
    private long idCounter;
    private long currentTimeMillis = -1L;
    private final Map<Long, EntityStateMachine> stateMachines = new HashMap<Long, EntityStateMachine>();
    private final Map<String, EntityStateMachine> protocolStateMachines = new HashMap<String, EntityStateMachine>();
    private final Queue<io.temporal.api.protocol.v1.Message> messageOutbox = new ArrayDeque<io.temporal.api.protocol.v1.Message>();
    private final Queue<CancellableCommand> commands = new ArrayDeque<CancellableCommand>();
    private final Queue<CancellableCommand> cancellableCommands = new ArrayDeque<CancellableCommand>();
    private boolean replaying;
    private boolean eventLoopExecuting;
    private boolean preparing;
    private final Map<String, MutableSideEffectStateMachine> mutableSideEffects = new HashMap<String, MutableSideEffectStateMachine>();
    private final Map<String, VersionStateMachine> versions = new HashMap<String, VersionStateMachine>();
    private final Map<String, LocalActivityStateMachine> localActivityMap = new HashMap<String, LocalActivityStateMachine>();
    private List<ExecuteLocalActivityParameters> localActivityRequests = new ArrayList<ExecuteLocalActivityParameters>();
    private final Functions.Proc1<ExecuteLocalActivityParameters> localActivityRequestSink;
    private final Functions.Proc1<StateMachine> stateMachineSink;
    private final WFTBuffer wftBuffer = new WFTBuffer();
    private List<io.temporal.api.protocol.v1.Message> messages = new ArrayList<io.temporal.api.protocol.v1.Message>();
    private final Set<String> acceptedUpdates = new HashSet<String>();
    private final SdkFlags flags;
    @Nonnull
    private String lastSeenSdkName = "";
    @Nonnull
    private String lastSeenSdkVersion = "";

    public WorkflowStateMachines(StatesMachinesCallback callbacks, GetSystemInfoResponse.Capabilities capabilities) {
        this(callbacks, stateMachine -> {}, capabilities);
    }

    @VisibleForTesting
    public WorkflowStateMachines(StatesMachinesCallback callbacks, Functions.Proc1<StateMachine> stateMachineSink, GetSystemInfoResponse.Capabilities capabilities) {
        this.callbacks = Objects.requireNonNull(callbacks);
        this.commandSink = this.cancellableCommands::add;
        this.stateMachineSink = stateMachineSink;
        this.localActivityRequestSink = request -> this.localActivityRequests.add((ExecuteLocalActivityParameters)request);
        this.flags = new SdkFlags(capabilities.getSdkMetadata(), this::isReplaying);
    }

    @VisibleForTesting
    public WorkflowStateMachines(StatesMachinesCallback callbacks, Functions.Proc1<StateMachine> stateMachineSink) {
        this.callbacks = Objects.requireNonNull(callbacks);
        this.commandSink = this.cancellableCommands::add;
        this.stateMachineSink = stateMachineSink;
        this.localActivityRequestSink = request -> this.localActivityRequests.add((ExecuteLocalActivityParameters)request);
        this.flags = new SdkFlags(false, this::isReplaying);
    }

    public void setWorkflowStartedEventId(long workflowTaskStartedEventId) {
        this.workflowTaskStartedEventId = workflowTaskStartedEventId;
    }

    public void resetStartedEventId(long eventId) {
        long resetLastHandledEventId = this.lastHandledEventId - 2L;
        for (long i = this.lastHandledEventId; i > resetLastHandledEventId; --i) {
            this.stateMachines.remove(i);
        }
        this.lastWFTStartedEventId = eventId;
        this.lastHandledEventId = resetLastHandledEventId;
    }

    public long getLastWFTStartedEventId() {
        return this.lastWFTStartedEventId;
    }

    public long getCurrentWFTStartedEventId() {
        return this.workflowTaskStartedEventId;
    }

    public long getHistorySize() {
        return this.historySize;
    }

    @Nullable
    public String getCurrentTaskBuildId() {
        return this.currentTaskBuildId;
    }

    public boolean isContinueAsNewSuggested() {
        return this.isContinueAsNewSuggested;
    }

    public void setReplaying(boolean replaying) {
        this.replaying = replaying;
    }

    public void setMessages(List<io.temporal.api.protocol.v1.Message> messages) {
        this.messages = new ArrayList<io.temporal.api.protocol.v1.Message>(messages);
    }

    public void handleEvent(HistoryEvent event, boolean hasNextEvent) {
        long eventId = event.getEventId();
        if (eventId <= this.lastHandledEventId) {
            return;
        }
        Preconditions.checkState((eventId == this.lastHandledEventId + 1L ? 1 : 0) != 0, (String)"History is out of order. There is a gap between the last event workflow state machine observed and currently handling event. Last processed eventId: %s, handling eventId: %s", (long)this.lastHandledEventId, (long)eventId);
        this.lastHandledEventId = eventId;
        boolean readyToPeek = this.wftBuffer.addEvent(event, hasNextEvent);
        if (readyToPeek) {
            this.handleEventsBatch(this.wftBuffer.fetch(), hasNextEvent);
        }
    }

    private void handleEventsBatch(WFTBuffer.EventBatch eventBatch, boolean hasNextBatch) {
        List<HistoryEvent> events = eventBatch.getEvents();
        if (EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED.equals((Object)events.get(0).getEventType())) {
            for (SdkFlag flag : initialFlags) {
                this.flags.tryUseSdkFlag(flag);
            }
        }
        if (eventBatch.getWorkflowTaskCompletedEvent().isPresent()) {
            for (HistoryEvent event : events) {
                this.handleSingleEventLookahead(event);
            }
        }
        Iterator<HistoryEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            HistoryEvent event;
            event = iterator.next();
            for (io.temporal.api.protocol.v1.Message msg : this.takeLTE(event.getEventId() - 1L)) {
                this.handleSingleMessage(msg);
            }
            try {
                boolean isLastTask = !hasNextBatch && !eventBatch.getWorkflowTaskCompletedEvent().isPresent();
                boolean hasNextEvent = iterator.hasNext() || hasNextBatch;
                this.handleSingleEvent(event, isLastTask, hasNextEvent);
            }
            catch (RuntimeException e) {
                throw this.createEventProcessingException(e, event);
            }
            for (io.temporal.api.protocol.v1.Message msg : this.takeLTE(event.getEventId())) {
                this.handleSingleMessage(msg);
            }
        }
    }

    private void handleSingleEventLookahead(HistoryEvent event) {
        EventType eventType = event.getEventType();
        switch (eventType) {
            case EVENT_TYPE_MARKER_RECORDED: {
                try {
                    this.preloadVersionMarker(event);
                    break;
                }
                catch (RuntimeException e) {
                    throw this.createEventProcessingException(e, event);
                }
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_ACCEPTED: {
                WorkflowExecutionUpdateAcceptedEventAttributes updateEvent = event.getWorkflowExecutionUpdateAcceptedEventAttributes();
                if (!updateEvent.hasAcceptedRequest()) {
                    this.acceptedUpdates.add(updateEvent.getProtocolInstanceId());
                    break;
                }
                this.messages.add(io.temporal.api.protocol.v1.Message.newBuilder().setId(updateEvent.getAcceptedRequestMessageId()).setProtocolInstanceId(updateEvent.getProtocolInstanceId()).setEventId(updateEvent.getAcceptedRequestSequencingEventId()).setBody(Any.pack((Message)updateEvent.getAcceptedRequest())).build());
                break;
            }
            case EVENT_TYPE_WORKFLOW_TASK_COMPLETED: {
                WorkflowTaskCompletedEventAttributes completedEvent = event.getWorkflowTaskCompletedEventAttributes();
                String maybeBuildId = completedEvent.getWorkerVersion().getBuildId();
                if (!maybeBuildId.isEmpty()) {
                    this.currentTaskBuildId = maybeBuildId;
                }
                for (Integer flag : completedEvent.getSdkMetadata().getLangUsedFlagsList()) {
                    SdkFlag sdkFlag = SdkFlag.getValue(flag);
                    if (sdkFlag.equals((Object)SdkFlag.UNKNOWN)) {
                        throw new IllegalArgumentException("Unknown SDK flag:" + flag);
                    }
                    this.flags.setSdkFlag(sdkFlag);
                }
                if (!Strings.isNullOrEmpty((String)completedEvent.getSdkMetadata().getSdkName())) {
                    this.lastSeenSdkName = completedEvent.getSdkMetadata().getSdkName();
                }
                if (!Strings.isNullOrEmpty((String)completedEvent.getSdkMetadata().getSdkVersion())) {
                    this.lastSeenSdkVersion = completedEvent.getSdkMetadata().getSdkVersion();
                }
                this.protocolStateMachines.entrySet().removeIf(entry -> ((EntityStateMachine)entry.getValue()).isFinalState());
                break;
            }
        }
    }

    private List<io.temporal.api.protocol.v1.Message> takeLTE(long eventId) {
        ArrayList<io.temporal.api.protocol.v1.Message> m = new ArrayList<io.temporal.api.protocol.v1.Message>();
        ArrayList<io.temporal.api.protocol.v1.Message> remainingMessages = new ArrayList<io.temporal.api.protocol.v1.Message>();
        for (io.temporal.api.protocol.v1.Message msg : this.messages) {
            if (msg.getEventId() > eventId) {
                remainingMessages.add(msg);
                continue;
            }
            m.add(msg);
        }
        this.messages = remainingMessages;
        return m;
    }

    private RuntimeException createEventProcessingException(RuntimeException e, HistoryEvent event) {
        Throwable ex = CheckedExceptionWrapper.unwrap((Throwable)e);
        if (ex instanceof NonDeterministicException) {
            NonDeterministicException modifiedException = new NonDeterministicException(this.createEventHandlingMessage(event) + ". " + ex.getMessage() + ". " + this.createShortCurrentStateMessagePostfix(), ex.getCause());
            modifiedException.setStackTrace(ex.getStackTrace());
            return modifiedException;
        }
        return new InternalWorkflowTaskException(this.createEventHandlingMessage(event) + ". " + this.createShortCurrentStateMessagePostfix(), ex);
    }

    private void handleSingleMessage(io.temporal.api.protocol.v1.Message message) {
        EntityStateMachine stateMachine = this.protocolStateMachines.computeIfAbsent(message.getProtocolInstanceId(), protocolInstance -> {
            String protocolName = ProtocolUtils.getProtocol(message);
            Optional<ProtocolType> type = ProtocolType.get(protocolName);
            if (type.isPresent()) {
                switch (type.get()) {
                    case UPDATE_V1: {
                        return UpdateProtocolStateMachine.newInstance(this::isReplaying, this.callbacks::update, this::sendMessage, this.commandSink, this.stateMachineSink);
                    }
                }
                throw new IllegalArgumentException("Unknown protocol type:" + protocolName);
            }
            throw new IllegalArgumentException("Protocol type not specified:" + message);
        });
        stateMachine.handleMessage(message);
    }

    private void handleSingleEvent(HistoryEvent event, boolean lastTask, boolean hasNextEvent) {
        OptionalLong initialCommandEventId;
        if (WorkflowExecutionUtils.isCommandEvent(event)) {
            this.handleCommandEvent(event);
            return;
        }
        if (this.replaying && lastTask && event.getEventType() != EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED) {
            this.replaying = false;
        }
        if (!(initialCommandEventId = this.getInitialCommandEventId(event)).isPresent()) {
            return;
        }
        EntityStateMachine c = this.stateMachines.get(initialCommandEventId.getAsLong());
        if (c != null) {
            c.handleEvent(event, hasNextEvent);
            if (c.isFinalState()) {
                this.stateMachines.remove(initialCommandEventId.getAsLong());
            }
        } else {
            this.handleNonStatefulEvent(event, hasNextEvent);
        }
    }

    private void handleCommandEvent(HistoryEvent event) {
        if (this.handleLocalActivityMarker(event)) {
            return;
        }
        CancellableCommand matchingCommand = null;
        block4: while (matchingCommand == null) {
            CancellableCommand command = this.commands.peek();
            if (command == null) {
                if (this.handleNonMatchingVersionMarker(event)) {
                    return;
                }
                throw new NonDeterministicException("No command scheduled that corresponds to " + event);
            }
            if (command.isCanceled()) {
                this.commands.poll();
                continue;
            }
            if (VersionMarkerUtils.hasVersionMarkerStructure(event) && !VersionMarkerUtils.hasVersionMarkerStructure(command.getCommand())) {
                if (this.handleNonMatchingVersionMarker(event)) {
                    return;
                }
                throw new NonDeterministicException("Event " + event.getEventId() + " of type " + event.getEventType() + " does not match command type " + command.getCommandType());
            }
            HandleEventStatus status = command.handleEvent(event, true);
            if (command.isCanceled()) {
                this.commands.poll();
                continue;
            }
            switch (status) {
                case OK: {
                    this.commands.poll();
                    matchingCommand = command;
                    continue block4;
                }
                case NON_MATCHING_EVENT: {
                    if (this.handleNonMatchingVersionMarker(event)) {
                        return;
                    }
                    throw new NonDeterministicException("Event " + event.getEventId() + " of type " + event.getEventType() + " does not match command type " + command.getCommandType());
                }
            }
            throw new IllegalStateException("Got " + (Object)((Object)status) + " value from command.handleEvent which is not handled");
        }
        this.validateCommand(matchingCommand.getCommand(), event);
        EntityStateMachine stateMachine = matchingCommand.getStateMachine();
        if (!stateMachine.isFinalState()) {
            this.stateMachines.put(event.getEventId(), stateMachine);
        }
        if (event.getEventType() == EventType.EVENT_TYPE_MARKER_RECORDED) {
            this.prepareCommands();
        }
    }

    private void preloadVersionMarker(HistoryEvent event) {
        if (VersionMarkerUtils.hasVersionMarkerStructure(event)) {
            String changeId = VersionMarkerUtils.tryGetChangeIdFromVersionMarkerEvent(event);
            if (changeId == null) {
                return;
            }
            VersionStateMachine versionStateMachine = this.versions.computeIfAbsent(changeId, idKey -> VersionStateMachine.newInstance(changeId, this::isReplaying, this.commandSink, this.stateMachineSink));
            versionStateMachine.handleMarkersPreload(event);
        }
    }

    private boolean handleNonMatchingVersionMarker(HistoryEvent event) {
        String changeId = VersionMarkerUtils.tryGetChangeIdFromVersionMarkerEvent(event);
        if (changeId == null) {
            return false;
        }
        VersionStateMachine versionStateMachine = this.versions.get(changeId);
        Preconditions.checkNotNull((Object)versionStateMachine, (Object)"versionStateMachine is expected to be initialized already by execution or preloading");
        versionStateMachine.handleNonMatchingEvent(event);
        return true;
    }

    public List<Command> takeCommands() {
        ArrayList<Command> result = new ArrayList<Command>(this.commands.size());
        for (CancellableCommand command : this.commands) {
            if (command.isCanceled()) continue;
            result.add(command.getCommand());
        }
        return result;
    }

    public void sendMessage(io.temporal.api.protocol.v1.Message message) {
        this.checkEventLoopExecuting();
        if (!this.isReplaying()) {
            this.messageOutbox.add(message);
        }
    }

    public List<io.temporal.api.protocol.v1.Message> takeMessages() {
        ArrayList<io.temporal.api.protocol.v1.Message> result = new ArrayList<io.temporal.api.protocol.v1.Message>(this.messageOutbox.size());
        result.addAll(this.messageOutbox);
        this.messageOutbox.clear();
        this.protocolStateMachines.entrySet().removeIf(entry -> ((EntityStateMachine)entry.getValue()).isFinalState());
        return result;
    }

    public boolean tryUseSdkFlag(SdkFlag flag) {
        return this.flags.tryUseSdkFlag(flag);
    }

    public boolean checkSdkFlag(SdkFlag flag) {
        return this.flags.checkSdkFlag(flag);
    }

    public EnumSet<SdkFlag> takeNewSdkFlags() {
        return this.flags.takeNewSdkFlags();
    }

    public String sdkNameToWrite() {
        if (!this.lastSeenSdkName.equals("temporal-java")) {
            return "temporal-java";
        }
        return null;
    }

    public String sdkVersionToWrite() {
        if (!this.lastSeenSdkVersion.equals(Version.LIBRARY_VERSION)) {
            return Version.LIBRARY_VERSION;
        }
        return null;
    }

    private void prepareCommands() {
        if (this.preparing) {
            return;
        }
        this.preparing = true;
        try {
            this.prepareImpl();
        }
        finally {
            this.preparing = false;
        }
    }

    private void prepareImpl() {
        CancellableCommand command;
        while ((command = this.cancellableCommands.poll()) != null) {
            command.handleCommand(command.getCommandType());
            this.commands.add(command);
        }
    }

    private boolean handleLocalActivityMarker(HistoryEvent event) {
        if (!LocalActivityMarkerUtils.hasLocalActivityStructure(event)) {
            return false;
        }
        MarkerRecordedEventAttributes markerAttributes = event.getMarkerRecordedEventAttributes();
        String id = LocalActivityMarkerUtils.getActivityId(markerAttributes);
        LocalActivityStateMachine stateMachine = this.localActivityMap.remove(id);
        if (stateMachine == null) {
            String activityType = LocalActivityMarkerUtils.getActivityTypeName(markerAttributes);
            throw new NonDeterministicException(String.format("Local activity of type %s is recorded in the history with id %s but was not expected by the execution", activityType, id));
        }
        if (stateMachine.getState() == LocalActivityStateMachine.State.RESULT_NOTIFIED) {
            return false;
        }
        stateMachine.handleEvent(event, true);
        this.eventLoop();
        return true;
    }

    private void eventLoop() {
        if (this.eventLoopExecuting) {
            return;
        }
        this.eventLoopExecuting = true;
        try {
            this.callbacks.eventLoop();
        }
        finally {
            this.eventLoopExecuting = false;
        }
        this.prepareCommands();
    }

    private void handleNonStatefulEvent(HistoryEvent event, boolean hasNextEvent) {
        switch (event.getEventType()) {
            case EVENT_TYPE_WORKFLOW_EXECUTION_STARTED: {
                this.currentRunId = event.getWorkflowExecutionStartedEventAttributes().getOriginalExecutionRunId();
                this.callbacks.start(event);
                break;
            }
            case EVENT_TYPE_WORKFLOW_TASK_SCHEDULED: {
                WorkflowTaskStateMachine c = WorkflowTaskStateMachine.newInstance(this.workflowTaskStartedEventId, new WorkflowTaskCommandsListener());
                c.handleEvent(event, hasNextEvent);
                this.stateMachines.put(event.getEventId(), c);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED: {
                this.callbacks.signal(event);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCEL_REQUESTED: {
                this.callbacks.cancel(event);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_ADMITTED: {
                WorkflowExecutionUpdateAdmittedEventAttributes admittedEvent = event.getWorkflowExecutionUpdateAdmittedEventAttributes();
                io.temporal.api.protocol.v1.Message msg = io.temporal.api.protocol.v1.Message.newBuilder().setId(admittedEvent.getRequest().getMeta().getUpdateId() + "/request").setProtocolInstanceId(admittedEvent.getRequest().getMeta().getUpdateId()).setEventId(event.getEventId()).setBody(Any.pack((Message)admittedEvent.getRequest())).build();
                if ((!this.replaying || !this.acceptedUpdates.remove(msg.getProtocolInstanceId())) && this.replaying) break;
                this.messages.add(msg);
                break;
            }
            case EVENT_TYPE_WORKFLOW_EXECUTION_TIMED_OUT: 
            case UNRECOGNIZED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected event:" + event);
            }
        }
    }

    private long setCurrentTimeMillis(long currentTimeMillis) {
        if (this.currentTimeMillis < currentTimeMillis) {
            this.currentTimeMillis = currentTimeMillis;
        }
        return this.currentTimeMillis;
    }

    public long getLastStartedEventId() {
        return this.lastWFTStartedEventId;
    }

    public Functions.Proc scheduleActivityTask(ExecuteActivityParameters attributes, Functions.Proc2<Optional<Payloads>, Failure> callback) {
        this.checkEventLoopExecuting();
        ActivityStateMachine activityStateMachine = ActivityStateMachine.newInstance(attributes, (p, f) -> {
            Failure failure = f != null ? f.getFailure() : null;
            callback.apply((Optional<Payloads>)p, failure);
            if (f != null && !f.isFromEvent() && failure.hasCause() && failure.getCause().hasCanceledFailureInfo()) {
                this.eventLoop();
            }
        }, this.commandSink, this.stateMachineSink);
        return activityStateMachine::cancel;
    }

    public Functions.Proc newTimer(StartTimerCommandAttributes attributes, UserMetadata metadata, Functions.Proc1<HistoryEvent> completionCallback) {
        this.checkEventLoopExecuting();
        TimerStateMachine timer = TimerStateMachine.newInstance(attributes, metadata, event -> {
            completionCallback.apply((HistoryEvent)event);
            if (event.getEventType() == EventType.EVENT_TYPE_TIMER_CANCELED) {
                this.eventLoop();
            }
        }, this.commandSink, this.stateMachineSink);
        return timer::cancel;
    }

    public Functions.Proc startChildWorkflow(StartChildWorkflowExecutionParameters parameters, Functions.Proc2<WorkflowExecution, Exception> startedCallback, Functions.Proc2<Optional<Payloads>, Exception> completionCallback) {
        this.checkEventLoopExecuting();
        StartChildWorkflowExecutionCommandAttributes attributes = parameters.getRequest().build();
        ChildWorkflowCancellationType cancellationType = parameters.getCancellationType();
        ChildWorkflowStateMachine child = ChildWorkflowStateMachine.newInstance(attributes, parameters.getMetadata(), startedCallback, completionCallback, this.commandSink, this.stateMachineSink);
        return () -> {
            if (cancellationType == ChildWorkflowCancellationType.ABANDON) {
                this.notifyChildCanceled(completionCallback);
                return;
            }
            if (child.isCancellable()) {
                child.cancel();
                return;
            }
            if (!child.isFinalState()) {
                this.requestCancelExternalWorkflowExecution(RequestCancelExternalWorkflowExecutionCommandAttributes.newBuilder().setWorkflowId(attributes.getWorkflowId()).setNamespace(attributes.getNamespace()).setChildWorkflowOnly(true).build(), (r, e) -> {
                    if (cancellationType == ChildWorkflowCancellationType.WAIT_CANCELLATION_REQUESTED) {
                        this.notifyChildCanceled(completionCallback);
                    }
                });
                if (cancellationType == ChildWorkflowCancellationType.TRY_CANCEL) {
                    this.notifyChildCanceled(completionCallback);
                }
            }
        };
    }

    public Functions.Proc startNexusOperation(ScheduleNexusOperationCommandAttributes attributes, @Nullable UserMetadata metadata, Functions.Proc2<Optional<String>, Failure> startedCallback, Functions.Proc2<Optional<Payload>, Failure> completionCallback) {
        this.checkEventLoopExecuting();
        NexusOperationStateMachine operation = NexusOperationStateMachine.newInstance(attributes, metadata, startedCallback, completionCallback, this.commandSink, this.stateMachineSink);
        return () -> {
            if (operation.isCancellable()) {
                operation.cancel();
            }
            if (!operation.isFinalState()) {
                this.requestCancelNexusOperation(RequestCancelNexusOperationCommandAttributes.newBuilder().setScheduledEventId(operation.getInitialCommandEventId()).build());
            }
        };
    }

    private void notifyChildCanceled(Functions.Proc2<Optional<Payloads>, Exception> completionCallback) {
        CanceledFailure failure = new CanceledFailure("Child canceled");
        completionCallback.apply(Optional.empty(), failure);
        this.eventLoop();
    }

    public Functions.Proc signalExternalWorkflowExecution(SignalExternalWorkflowExecutionCommandAttributes attributes, Functions.Proc2<Void, Failure> completionCallback) {
        this.checkEventLoopExecuting();
        return SignalExternalStateMachine.newInstance(attributes, completionCallback, this.commandSink, this.stateMachineSink);
    }

    public void requestCancelExternalWorkflowExecution(RequestCancelExternalWorkflowExecutionCommandAttributes attributes, Functions.Proc2<Void, RuntimeException> completionCallback) {
        this.checkEventLoopExecuting();
        CancelExternalStateMachine.newInstance(attributes, completionCallback, this.commandSink, this.stateMachineSink);
    }

    public void requestCancelNexusOperation(RequestCancelNexusOperationCommandAttributes attributes) {
        this.checkEventLoopExecuting();
        CancelNexusOperationStateMachine.newInstance(attributes, this.commandSink, this.stateMachineSink);
    }

    public void upsertSearchAttributes(SearchAttributes attributes) {
        this.checkEventLoopExecuting();
        UpsertSearchAttributesStateMachine.newInstance(attributes, this.commandSink, this.stateMachineSink);
    }

    public void upsertMemo(Memo memo) {
        this.checkEventLoopExecuting();
        WorkflowPropertiesModifiedStateMachine.newInstance(ModifyWorkflowPropertiesCommandAttributes.newBuilder().setUpsertedMemo(memo).build(), this.commandSink, this.stateMachineSink);
    }

    public void completeWorkflow(Optional<Payloads> workflowOutput) {
        this.checkEventLoopExecuting();
        CompleteWorkflowStateMachine.newInstance(workflowOutput, this.commandSink, this.stateMachineSink);
    }

    public void failWorkflow(Failure failure) {
        this.checkEventLoopExecuting();
        FailWorkflowStateMachine.newInstance(failure, this.commandSink, this.stateMachineSink);
    }

    public void cancelWorkflow() {
        this.checkEventLoopExecuting();
        CancelWorkflowStateMachine.newInstance(CancelWorkflowExecutionCommandAttributes.getDefaultInstance(), this.commandSink, this.stateMachineSink);
    }

    public void continueAsNewWorkflow(ContinueAsNewWorkflowExecutionCommandAttributes attributes) {
        this.checkEventLoopExecuting();
        ContinueAsNewWorkflowStateMachine.newInstance(attributes, this.commandSink, this.stateMachineSink);
    }

    public boolean isReplaying() {
        return this.replaying;
    }

    public long currentTimeMillis() {
        return this.currentTimeMillis;
    }

    public UUID randomUUID() {
        this.checkEventLoopExecuting();
        String runId = this.currentRunId;
        if (runId == null) {
            throw new Error("null currentRunId");
        }
        String id = runId + ":" + this.idCounter++;
        byte[] bytes = id.getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(bytes);
    }

    public Random newRandom() {
        this.checkEventLoopExecuting();
        return new Random(this.randomUUID().getLeastSignificantBits());
    }

    public void sideEffect(Functions.Func<Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
        this.checkEventLoopExecuting();
        SideEffectStateMachine.newInstance(this::isReplaying, func, payloads -> {
            callback.apply((Optional<Payloads>)payloads);
            this.eventLoop();
        }, this.commandSink, this.stateMachineSink);
    }

    public void mutableSideEffect(String id, Functions.Func1<Optional<Payloads>, Optional<Payloads>> func, Functions.Proc1<Optional<Payloads>> callback) {
        this.checkEventLoopExecuting();
        MutableSideEffectStateMachine stateMachine = this.mutableSideEffects.computeIfAbsent(id, idKey -> MutableSideEffectStateMachine.newInstance(idKey, this::isReplaying, this.commandSink, this.stateMachineSink));
        stateMachine.mutableSideEffect(func, (Optional<Payloads> r) -> {
            callback.apply((Optional<Payloads>)r);
            this.eventLoop();
        }, this.stateMachineSink);
    }

    public Integer getVersion(String changeId, int minSupported, int maxSupported, Functions.Proc2<Integer, RuntimeException> callback) {
        VersionStateMachine stateMachine = this.versions.computeIfAbsent(changeId, idKey -> VersionStateMachine.newInstance(changeId, this::isReplaying, this.commandSink, this.stateMachineSink));
        return stateMachine.getVersion(minSupported, maxSupported, (v, e) -> {
            callback.apply((Integer)v, (RuntimeException)e);
            this.eventLoop();
        });
    }

    public List<ExecuteLocalActivityParameters> takeLocalActivityRequests() {
        List<ExecuteLocalActivityParameters> result = this.localActivityRequests;
        this.localActivityRequests = new ArrayList<ExecuteLocalActivityParameters>();
        for (ExecuteLocalActivityParameters parameters : result) {
            LocalActivityStateMachine stateMachine = this.localActivityMap.get(parameters.getActivityId());
            stateMachine.markAsSent();
        }
        return result;
    }

    public void handleLocalActivityCompletion(LocalActivityResult laCompletion) {
        String activityId = laCompletion.getActivityId();
        LocalActivityStateMachine laStateMachine = this.localActivityMap.get(activityId);
        if (laStateMachine == null) {
            throw new IllegalStateException("Unknown local activity: " + activityId);
        }
        laStateMachine.handleCompletion(laCompletion);
        this.prepareCommands();
    }

    public Functions.Proc scheduleLocalActivityTask(ExecuteLocalActivityParameters parameters, Functions.Proc2<Optional<Payloads>, LocalActivityCallback.LocalActivityFailedException> callback) {
        this.checkEventLoopExecuting();
        String activityId = parameters.getActivityId();
        if (Strings.isNullOrEmpty((String)activityId)) {
            throw new IllegalArgumentException("Missing activityId: " + activityId);
        }
        if (this.localActivityMap.containsKey(activityId)) {
            throw new IllegalArgumentException("Duplicated local activity id: " + activityId);
        }
        LocalActivityStateMachine commands = LocalActivityStateMachine.newInstance(this::isReplaying, this::setCurrentTimeMillis, parameters, (r, e) -> {
            callback.apply(r, e);
            this.eventLoop();
        }, this.localActivityRequestSink, this.commandSink, this.stateMachineSink, this.currentTimeMillis);
        this.localActivityMap.put(activityId, commands);
        return commands::cancel;
    }

    private void validateCommand(Command command, HistoryEvent event) {
        if (command.getCommandType() == CommandType.COMMAND_TYPE_PROTOCOL_MESSAGE) {
            ProtocolMessageCommandAttributes commandAttributes = command.getProtocolMessageCommandAttributes();
            switch (event.getEventType()) {
                case EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_ACCEPTED: {
                    this.assertMatch(command, event, "messageType", true, commandAttributes.getMessageId().endsWith("accept"));
                    break;
                }
                case EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_REJECTED: {
                    this.assertMatch(command, event, "messageType", true, commandAttributes.getMessageId().endsWith("reject"));
                    break;
                }
                case EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_COMPLETED: {
                    this.assertMatch(command, event, "messageType", true, commandAttributes.getMessageId().endsWith("complete"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected event type: " + event.getEventType());
                }
            }
            return;
        }
        this.assertMatch(command, event, "eventType", WorkflowExecutionUtils.getEventTypeForCommand(command.getCommandType()), event.getEventType());
        switch (command.getCommandType()) {
            case COMMAND_TYPE_SCHEDULE_ACTIVITY_TASK: {
                ScheduleActivityTaskCommandAttributes commandAttributes = command.getScheduleActivityTaskCommandAttributes();
                ActivityTaskScheduledEventAttributes eventAttributes = event.getActivityTaskScheduledEventAttributes();
                this.assertMatch(command, event, "activityId", commandAttributes.getActivityId(), eventAttributes.getActivityId());
                this.assertMatch(command, event, "activityType", commandAttributes.getActivityType(), eventAttributes.getActivityType());
                break;
            }
            case COMMAND_TYPE_START_CHILD_WORKFLOW_EXECUTION: {
                StartChildWorkflowExecutionCommandAttributes commandAttributes = command.getStartChildWorkflowExecutionCommandAttributes();
                StartChildWorkflowExecutionInitiatedEventAttributes eventAttributes = event.getStartChildWorkflowExecutionInitiatedEventAttributes();
                this.assertMatch(command, event, "workflowId", commandAttributes.getWorkflowId(), eventAttributes.getWorkflowId());
                this.assertMatch(command, event, "workflowType", commandAttributes.getWorkflowType(), eventAttributes.getWorkflowType());
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_ACTIVITY_TASK: 
            case COMMAND_TYPE_START_TIMER: {
                StartTimerCommandAttributes commandAttributes = command.getStartTimerCommandAttributes();
                TimerStartedEventAttributes eventAttributes = event.getTimerStartedEventAttributes();
                this.assertMatch(command, event, "timerId", commandAttributes.getTimerId(), eventAttributes.getTimerId());
                break;
            }
            case COMMAND_TYPE_SCHEDULE_NEXUS_OPERATION: {
                ScheduleNexusOperationCommandAttributes commandAttributes = command.getScheduleNexusOperationCommandAttributes();
                NexusOperationScheduledEventAttributes eventAttributes = event.getNexusOperationScheduledEventAttributes();
                this.assertMatch(command, event, "operation", commandAttributes.getOperation(), eventAttributes.getOperation());
                this.assertMatch(command, event, "service", commandAttributes.getService(), eventAttributes.getService());
                break;
            }
            case COMMAND_TYPE_REQUEST_CANCEL_NEXUS_OPERATION: {
                RequestCancelNexusOperationCommandAttributes commandAttributes = command.getRequestCancelNexusOperationCommandAttributes();
                NexusOperationCancelRequestedEventAttributes eventAttributes = event.getNexusOperationCancelRequestedEventAttributes();
                this.assertMatch(command, event, "scheduleEventId", commandAttributes.getScheduledEventId(), eventAttributes.getScheduledEventId());
                break;
            }
            case COMMAND_TYPE_CANCEL_TIMER: 
            case COMMAND_TYPE_CANCEL_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_RECORD_MARKER: 
            case COMMAND_TYPE_CONTINUE_AS_NEW_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES: 
            case COMMAND_TYPE_COMPLETE_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_FAIL_WORKFLOW_EXECUTION: 
            case COMMAND_TYPE_PROTOCOL_MESSAGE: 
            case COMMAND_TYPE_MODIFY_WORKFLOW_PROPERTIES: {
                break;
            }
            case UNRECOGNIZED: 
            case COMMAND_TYPE_UNSPECIFIED: {
                throw new IllegalArgumentException("Unexpected command type: " + command.getCommandType());
            }
        }
    }

    private void assertMatch(Command command, HistoryEvent event, String checkType, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            String message = String.format("Command %s doesn't match event %s with EventId=%s on check %s with an expected value '%s' and an actual value '%s'", command.getCommandType(), event.getEventType(), event.getEventId(), checkType, expected, actual);
            throw new NonDeterministicException(message);
        }
    }

    private OptionalLong getInitialCommandEventId(HistoryEvent event) {
        switch (event.getEventType()) {
            case EVENT_TYPE_ACTIVITY_TASK_STARTED: {
                return OptionalLong.of(event.getActivityTaskStartedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_ACTIVITY_TASK_COMPLETED: {
                return OptionalLong.of(event.getActivityTaskCompletedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_ACTIVITY_TASK_FAILED: {
                return OptionalLong.of(event.getActivityTaskFailedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_ACTIVITY_TASK_TIMED_OUT: {
                return OptionalLong.of(event.getActivityTaskTimedOutEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_ACTIVITY_TASK_CANCEL_REQUESTED: {
                return OptionalLong.of(event.getActivityTaskCancelRequestedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_ACTIVITY_TASK_CANCELED: {
                return OptionalLong.of(event.getActivityTaskCanceledEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_TIMER_FIRED: {
                return OptionalLong.of(event.getTimerFiredEventAttributes().getStartedEventId());
            }
            case EVENT_TYPE_TIMER_CANCELED: {
                return OptionalLong.of(event.getTimerCanceledEventAttributes().getStartedEventId());
            }
            case EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: {
                return OptionalLong.of(event.getRequestCancelExternalWorkflowExecutionFailedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED: {
                return OptionalLong.of(event.getExternalWorkflowExecutionCancelRequestedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_FAILED: {
                return OptionalLong.of(event.getStartChildWorkflowExecutionFailedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_STARTED: {
                return OptionalLong.of(event.getChildWorkflowExecutionStartedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_COMPLETED: {
                return OptionalLong.of(event.getChildWorkflowExecutionCompletedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_FAILED: {
                return OptionalLong.of(event.getChildWorkflowExecutionFailedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_CANCELED: {
                return OptionalLong.of(event.getChildWorkflowExecutionCanceledEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_TIMED_OUT: {
                return OptionalLong.of(event.getChildWorkflowExecutionTimedOutEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_CHILD_WORKFLOW_EXECUTION_TERMINATED: {
                return OptionalLong.of(event.getChildWorkflowExecutionTerminatedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: {
                return OptionalLong.of(event.getSignalExternalWorkflowExecutionFailedEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_SIGNALED: {
                return OptionalLong.of(event.getExternalWorkflowExecutionSignaledEventAttributes().getInitiatedEventId());
            }
            case EVENT_TYPE_WORKFLOW_TASK_STARTED: {
                return OptionalLong.of(event.getWorkflowTaskStartedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_WORKFLOW_TASK_COMPLETED: {
                return OptionalLong.of(event.getWorkflowTaskCompletedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_WORKFLOW_TASK_TIMED_OUT: {
                return OptionalLong.of(event.getWorkflowTaskTimedOutEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_WORKFLOW_TASK_FAILED: {
                return OptionalLong.of(event.getWorkflowTaskFailedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_NEXUS_OPERATION_STARTED: {
                return OptionalLong.of(event.getNexusOperationStartedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_NEXUS_OPERATION_COMPLETED: {
                return OptionalLong.of(event.getNexusOperationCompletedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_NEXUS_OPERATION_FAILED: {
                return OptionalLong.of(event.getNexusOperationFailedEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_NEXUS_OPERATION_CANCELED: {
                return OptionalLong.of(event.getNexusOperationCanceledEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_NEXUS_OPERATION_TIMED_OUT: {
                return OptionalLong.of(event.getNexusOperationTimedOutEventAttributes().getScheduledEventId());
            }
            case EVENT_TYPE_MARKER_RECORDED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_STARTED: 
            case EVENT_TYPE_WORKFLOW_TASK_SCHEDULED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_SIGNALED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCEL_REQUESTED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_UPDATE_ADMITTED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_TIMED_OUT: 
            case EVENT_TYPE_ACTIVITY_TASK_SCHEDULED: 
            case EVENT_TYPE_TIMER_STARTED: 
            case EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: 
            case EVENT_TYPE_START_CHILD_WORKFLOW_EXECUTION_INITIATED: 
            case EVENT_TYPE_REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_CONTINUED_AS_NEW: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_TERMINATED: 
            case EVENT_TYPE_UPSERT_WORKFLOW_SEARCH_ATTRIBUTES: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_COMPLETED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_FAILED: 
            case EVENT_TYPE_WORKFLOW_EXECUTION_CANCELED: 
            case EVENT_TYPE_WORKFLOW_PROPERTIES_MODIFIED: 
            case EVENT_TYPE_NEXUS_OPERATION_SCHEDULED: 
            case EVENT_TYPE_NEXUS_OPERATION_CANCEL_REQUESTED: {
                return OptionalLong.of(event.getEventId());
            }
        }
        if (event.getWorkerMayIgnore()) {
            return OptionalLong.empty();
        }
        throw new IllegalArgumentException("Unexpected event type: " + event.getEventType());
    }

    private void checkEventLoopExecuting() {
        if (!this.eventLoopExecuting) {
            WorkflowThread.await("kill workflow thread if destroy requested", () -> true);
            throw new IllegalStateException("Operation allowed only while eventLoop is running");
        }
    }

    private String createEventHandlingMessage(HistoryEvent event) {
        return "Failure handling event " + event.getEventId() + " of type '" + event.getEventType() + "' " + (this.isReplaying() ? "during replay" : "during execution");
    }

    private String createShortCurrentStateMessagePostfix() {
        return String.format("{WorkflowTaskStartedEventId=%s, CurrentStartedEventId=%s}", this.workflowTaskStartedEventId, this.lastWFTStartedEventId);
    }

    private class WorkflowTaskCommandsListener
    implements WorkflowTaskStateMachine.Listener {
        private WorkflowTaskCommandsListener() {
        }

        @Override
        public void workflowTaskStarted(long startedEventId, long currentTimeMillis, boolean nonProcessedWorkflowTask, long historySize, boolean isContinueAsNewSuggested) {
            WorkflowStateMachines.this.setCurrentTimeMillis(currentTimeMillis);
            for (CancellableCommand cancellableCommand : WorkflowStateMachines.this.commands) {
                cancellableCommand.handleWorkflowTaskStarted();
            }
            if (nonProcessedWorkflowTask) {
                for (LocalActivityStateMachine value : WorkflowStateMachines.this.localActivityMap.values()) {
                    value.nonReplayWorkflowTaskStarted();
                }
            }
            WorkflowStateMachines.this.lastWFTStartedEventId = startedEventId;
            WorkflowStateMachines.this.historySize = historySize;
            WorkflowStateMachines.this.isContinueAsNewSuggested = isContinueAsNewSuggested;
            WorkflowStateMachines.this.eventLoop();
        }

        @Override
        public void updateRunId(String currentRunId) {
            WorkflowStateMachines.this.currentRunId = currentRunId;
        }
    }

    static enum HandleEventStatus {
        OK,
        NON_MATCHING_EVENT;

    }
}

