/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.failure;

import com.google.common.base.Strings;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.converter.Values;
import io.temporal.failure.ApplicationErrorCategory;
import io.temporal.failure.TemporalFailure;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ApplicationFailure
extends TemporalFailure {
    private final String type;
    private final Values details;
    private boolean nonRetryable;
    private Duration nextRetryDelay;
    private final ApplicationErrorCategory category;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ApplicationFailure options) {
        return new Builder(options);
    }

    public static ApplicationFailure newFailure(String message, String type, Object ... details) {
        return ApplicationFailure.newFailureWithCause(message, type, null, details);
    }

    public static ApplicationFailure newFailureWithCause(String message, String type, @Nullable Throwable cause, Object ... details) {
        return new ApplicationFailure(message, type, false, new EncodedValues(details), cause, null, ApplicationErrorCategory.UNSPECIFIED);
    }

    public static ApplicationFailure newFailureWithCauseAndDelay(String message, String type, @Nullable Throwable cause, Duration nextRetryDelay, Object ... details) {
        return new ApplicationFailure(message, type, false, new EncodedValues(details), cause, nextRetryDelay, ApplicationErrorCategory.UNSPECIFIED);
    }

    public static ApplicationFailure newNonRetryableFailure(String message, String type, Object ... details) {
        return ApplicationFailure.newNonRetryableFailureWithCause(message, type, null, details);
    }

    public static ApplicationFailure newNonRetryableFailureWithCause(String message, String type, @Nullable Throwable cause, Object ... details) {
        return new ApplicationFailure(message, type, true, new EncodedValues(details), cause, null, ApplicationErrorCategory.UNSPECIFIED);
    }

    private ApplicationFailure(String message, String type, boolean nonRetryable, Values details, Throwable cause, Duration nextRetryDelay, ApplicationErrorCategory category) {
        super(ApplicationFailure.getMessage(message, Objects.requireNonNull(type), nonRetryable), message, cause);
        this.type = type;
        this.details = details;
        this.nonRetryable = nonRetryable;
        this.nextRetryDelay = nextRetryDelay;
        this.category = category;
    }

    public String getType() {
        return this.type;
    }

    public Values getDetails() {
        return this.details;
    }

    @Nullable
    public Duration getNextRetryDelay() {
        return this.nextRetryDelay;
    }

    public void setNonRetryable(boolean nonRetryable) {
        this.nonRetryable = nonRetryable;
    }

    public boolean isNonRetryable() {
        return this.nonRetryable;
    }

    @Override
    public void setDataConverter(DataConverter converter) {
        ((EncodedValues)this.details).setDataConverter(converter);
    }

    public void setNextRetryDelay(Duration nextRetryDelay) {
        this.nextRetryDelay = nextRetryDelay;
    }

    public ApplicationErrorCategory getCategory() {
        return this.category;
    }

    private static String getMessage(String message, String type, boolean nonRetryable) {
        return (Strings.isNullOrEmpty((String)message) ? "" : "message='" + message + "', ") + "type='" + type + '\'' + ", nonRetryable=" + nonRetryable;
    }

    public static final class Builder {
        private String message;
        private String type;
        private Values details;
        private boolean nonRetryable;
        private Throwable cause;
        private Duration nextRetryDelay;
        private ApplicationErrorCategory category;

        private Builder() {
        }

        private Builder(ApplicationFailure options) {
            if (options == null) {
                return;
            }
            this.message = options.getOriginalMessage();
            this.type = options.type;
            this.details = options.details;
            this.nonRetryable = options.nonRetryable;
            this.nextRetryDelay = options.nextRetryDelay;
            this.category = options.category;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setDetails(Object ... details) {
            this.details = new EncodedValues(details);
            return this;
        }

        public Builder setDetails(Values details) {
            this.details = details;
            return this;
        }

        public Builder setNonRetryable(boolean nonRetryable) {
            this.nonRetryable = nonRetryable;
            return this;
        }

        public Builder setCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder setNextRetryDelay(Duration nextRetryDelay) {
            this.nextRetryDelay = nextRetryDelay;
            return this;
        }

        public Builder setCategory(ApplicationErrorCategory category) {
            this.category = category;
            return this;
        }

        public ApplicationFailure build() {
            return new ApplicationFailure(this.message, this.type, this.nonRetryable, this.details == null ? new EncodedValues(null) : this.details, this.cause, this.nextRetryDelay, this.category);
        }
    }
}

