/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common;

import io.temporal.common.Experimental;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Experimental
public class WorkerDeploymentVersion {
    private final String deploymentName;
    private final String buildId;

    public WorkerDeploymentVersion(@Nonnull String deploymentName, @Nonnull String buildId) {
        this.deploymentName = deploymentName;
        this.buildId = buildId;
    }

    public static WorkerDeploymentVersion fromCanonicalString(String canonicalString) {
        String[] parts = canonicalString.split("\\.", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid canonical string format. Expected 'deploymentName.buildId'");
        }
        return new WorkerDeploymentVersion(parts[0], parts[1]);
    }

    public String toCanonicalString() {
        return this.deploymentName + "." + this.buildId;
    }

    @Nullable
    public String getDeploymentName() {
        return this.deploymentName;
    }

    @Nullable
    public String getBuildId() {
        return this.buildId;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerDeploymentVersion that = (WorkerDeploymentVersion)o;
        return Objects.equals(this.deploymentName, that.deploymentName) && Objects.equals(this.buildId, that.buildId);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentName, this.buildId);
    }

    public String toString() {
        return "WorkerDeploymentVersion{deploymentName='" + this.deploymentName + '\'' + ", buildId='" + this.buildId + '\'' + '}';
    }
}

