/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.history;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.RecordMarkerCommandAttributes;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.MarkerRecordedEventAttributes;
import io.temporal.common.SearchAttributeKey;
import io.temporal.common.SearchAttributes;
import io.temporal.common.converter.DefaultDataConverter;
import io.temporal.internal.common.SearchAttributesUtil;
import io.temporal.internal.history.MarkerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class VersionMarkerUtils {
    public static final String MARKER_NAME = "Version";
    public static final String MARKER_CHANGE_ID_KEY = "changeId";
    public static final String MARKER_VERSION_KEY = "version";
    public static final String VERSION_SA_UPDATED_KEY = "versionSearchAttributeUpdated";
    @VisibleForTesting
    public static final SearchAttributeKey<List<String>> TEMPORAL_CHANGE_VERSION = SearchAttributeKey.forKeywordList("TemporalChangeVersion");
    public static final int CHANGE_VERSION_SEARCH_ATTRIBUTE_SIZE_LIMIT = 2048;

    @Nullable
    public static String tryGetChangeIdFromVersionMarkerEvent(HistoryEvent event) {
        if (!VersionMarkerUtils.hasVersionMarkerStructure(event)) {
            return null;
        }
        return VersionMarkerUtils.getChangeId(event.getMarkerRecordedEventAttributes());
    }

    public static boolean hasVersionMarkerStructure(HistoryEvent event) {
        return MarkerUtils.verifyMarkerName(event, MARKER_NAME);
    }

    public static boolean hasVersionMarkerStructure(Command command) {
        return MarkerUtils.verifyMarkerName(command, MARKER_NAME);
    }

    @Nullable
    public static String getChangeId(MarkerRecordedEventAttributes markerAttributes) {
        return MarkerUtils.getValueFromMarker(markerAttributes, MARKER_CHANGE_ID_KEY, String.class);
    }

    @Nullable
    public static Integer getVersion(MarkerRecordedEventAttributes markerAttributes) {
        return MarkerUtils.getValueFromMarker(markerAttributes, MARKER_VERSION_KEY, Integer.class);
    }

    @Nullable
    public static boolean getUpsertVersionSA(MarkerRecordedEventAttributes markerAttributes) {
        Boolean versionSearchAttributeUpdated = MarkerUtils.getValueFromMarker(markerAttributes, VERSION_SA_UPDATED_KEY, Boolean.class);
        return versionSearchAttributeUpdated != null && versionSearchAttributeUpdated != false;
    }

    public static RecordMarkerCommandAttributes createMarkerAttributes(String changeId, Integer version, Boolean upsertVersionSA) {
        Preconditions.checkNotNull((Object)version, (Object)MARKER_VERSION_KEY);
        HashMap<String, Payloads> details = new HashMap<String, Payloads>();
        details.put(MARKER_CHANGE_ID_KEY, DefaultDataConverter.STANDARD_INSTANCE.toPayloads(changeId).get());
        details.put(MARKER_VERSION_KEY, DefaultDataConverter.STANDARD_INSTANCE.toPayloads(version).get());
        if (upsertVersionSA.booleanValue()) {
            details.put(VERSION_SA_UPDATED_KEY, DefaultDataConverter.STANDARD_INSTANCE.toPayloads(true).get());
        }
        return RecordMarkerCommandAttributes.newBuilder().setMarkerName(MARKER_NAME).putAllDetails(details).build();
    }

    public static String createChangeId(String changeId, Integer version) {
        return changeId + "-" + version;
    }

    public static io.temporal.api.common.v1.SearchAttributes createVersionMarkerSearchAttributes(String newChangeId, Integer newVersion, Map<String, Integer> existingVersions) {
        ArrayList<String> changeVersions = new ArrayList<String>(existingVersions.size() + 1);
        existingVersions.entrySet().stream().map(entry -> VersionMarkerUtils.createChangeId((String)entry.getKey(), (Integer)entry.getValue())).forEach(changeVersions::add);
        changeVersions.add(VersionMarkerUtils.createChangeId(newChangeId, newVersion));
        io.temporal.api.common.v1.SearchAttributes sa = SearchAttributesUtil.encodeTyped(SearchAttributes.newBuilder().set(TEMPORAL_CHANGE_VERSION, changeVersions).build());
        return sa;
    }
}

