/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import com.google.common.base.Preconditions;
import io.temporal.common.Experimental;
import java.util.Objects;

@Experimental
public class OnConflictOptions {
    private static final OnConflictOptions DEFAULT_INSTANCE = OnConflictOptions.newBuilder().build();
    private final boolean attachRequestId;
    private final boolean attachCompletionCallbacks;
    private final boolean attachLinks;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(OnConflictOptions options) {
        return new Builder(options);
    }

    public static OnConflictOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private OnConflictOptions(boolean attachRequestId, boolean attachCompletionCallbacks, boolean attachLinks) {
        this.attachRequestId = attachRequestId;
        this.attachCompletionCallbacks = attachCompletionCallbacks;
        this.attachLinks = attachLinks;
    }

    public boolean isAttachRequestId() {
        return this.attachRequestId;
    }

    public boolean isAttachCompletionCallbacks() {
        return this.attachCompletionCallbacks;
    }

    public boolean isAttachLinks() {
        return this.attachLinks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnConflictOptions that = (OnConflictOptions)o;
        return this.attachRequestId == that.attachRequestId && this.attachCompletionCallbacks == that.attachCompletionCallbacks && this.attachLinks == that.attachLinks;
    }

    public int hashCode() {
        return Objects.hash(this.attachRequestId, this.attachCompletionCallbacks, this.attachLinks);
    }

    public String toString() {
        return "OnConflictOptions{attachRequestId=" + this.attachRequestId + ", attachCompletionCallbacks=" + this.attachCompletionCallbacks + ", attachLinks=" + this.attachLinks + '}';
    }

    public static final class Builder {
        private boolean attachRequestId;
        private boolean attachCompletionCallbacks;
        private boolean attachLinks;

        public Builder(OnConflictOptions options) {
            this.attachRequestId = options.attachRequestId;
            this.attachCompletionCallbacks = options.attachCompletionCallbacks;
            this.attachLinks = options.attachLinks;
        }

        public Builder() {
        }

        public Builder setAttachRequestId(boolean attachRequestId) {
            this.attachRequestId = attachRequestId;
            return this;
        }

        public Builder setAttachCompletionCallbacks(boolean attachCompletionCallbacks) {
            this.attachCompletionCallbacks = attachCompletionCallbacks;
            return this;
        }

        public Builder setAttachLinks(boolean attachLinks) {
            this.attachLinks = attachLinks;
            return this;
        }

        public OnConflictOptions build() {
            if (this.attachCompletionCallbacks) {
                Preconditions.checkState((boolean)this.attachRequestId, (Object)"AttachRequestId must be true if AttachCompletionCallbacks is true");
            }
            return new OnConflictOptions(this.attachRequestId, this.attachCompletionCallbacks, this.attachLinks);
        }
    }
}

