/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.client;

import io.temporal.api.common.v1.WorkflowExecution;
import java.util.Objects;

public final class WorkflowTargetOptions {
    private static final WorkflowTargetOptions DEFAULT_INSTANCE = WorkflowTargetOptions.newBuilder().build();
    private final String workflowId;
    private final String runId;
    private final String firstExecutionRunId;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(WorkflowTargetOptions options) {
        return new Builder(options);
    }

    public static WorkflowTargetOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private WorkflowTargetOptions(String workflowId, String runId, String firstExecutionRunId) {
        this.workflowId = workflowId;
        this.runId = runId;
        this.firstExecutionRunId = firstExecutionRunId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getFirstExecutionRunId() {
        return this.firstExecutionRunId;
    }

    public String toString() {
        return "WorkflowTargetOptions{workflowId='" + this.workflowId + '\'' + ", runId='" + this.runId + '\'' + ", firstExecutionRunId='" + this.firstExecutionRunId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowTargetOptions that = (WorkflowTargetOptions)o;
        return Objects.equals(this.workflowId, that.workflowId) && Objects.equals(this.runId, that.runId) && Objects.equals(this.firstExecutionRunId, that.firstExecutionRunId);
    }

    public int hashCode() {
        return Objects.hash(this.workflowId, this.runId, this.firstExecutionRunId);
    }

    public static final class Builder {
        private String workflowId;
        private String runId;
        private String firstExecutionRunId;

        private Builder() {
        }

        private Builder(WorkflowTargetOptions options) {
            this.workflowId = options.workflowId;
            this.runId = options.runId;
            this.firstExecutionRunId = options.firstExecutionRunId;
        }

        public Builder setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public Builder setRunId(String runId) {
            this.runId = runId;
            return this;
        }

        public Builder setFirstExecutionRunId(String firstExecutionRunId) {
            this.firstExecutionRunId = firstExecutionRunId;
            return this;
        }

        public Builder setWorkflowExecution(WorkflowExecution execution) {
            this.workflowId = execution.getWorkflowId();
            this.runId = execution.getRunId();
            return this;
        }

        public WorkflowTargetOptions build() {
            return new WorkflowTargetOptions(this.workflowId, this.runId, this.firstExecutionRunId);
        }
    }
}

