/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common.converter;

import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.failure.v1.Failure;
import io.temporal.common.Experimental;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.converter.GlobalDataConverter;
import io.temporal.failure.DefaultFailureConverter;
import io.temporal.payload.context.SerializationContext;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface DataConverter {
    @Deprecated
    public static DataConverter getDefaultInstance() {
        return GlobalDataConverter.get();
    }

    public <T> Optional<Payload> toPayload(T var1) throws DataConverterException;

    public <T> T fromPayload(Payload var1, Class<T> var2, Type var3) throws DataConverterException;

    public Optional<Payloads> toPayloads(Object ... var1) throws DataConverterException;

    public <T> T fromPayloads(int var1, Optional<Payloads> var2, Class<T> var3, Type var4) throws DataConverterException;

    default public Object[] fromPayloads(Optional<Payloads> content, Class<?>[] parameterTypes, Type[] genericParameterTypes) throws DataConverterException {
        if (parameterTypes != null && (genericParameterTypes == null || parameterTypes.length != genericParameterTypes.length)) {
            throw new IllegalArgumentException("parameterTypes don't match length of valueTypes: " + Arrays.toString(parameterTypes) + "<>" + Arrays.toString(genericParameterTypes));
        }
        int totalLength = parameterTypes.length;
        Object[] result = new Object[totalLength];
        if (!content.isPresent()) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                result[i] = Defaults.defaultValue((Class)TypeToken.of((Type)genericParameterTypes[i]).getRawType());
            }
            return result;
        }
        Payloads payloads = content.get();
        int count = payloads.getPayloadsCount();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> pt = parameterTypes[i];
            Type gt = genericParameterTypes[i];
            result[i] = i >= count ? Defaults.defaultValue((Class)TypeToken.of((Type)gt).getRawType()) : this.fromPayload(payloads.getPayloads(i), pt, gt);
        }
        return result;
    }

    @Nonnull
    default public RuntimeException failureToException(@Nonnull Failure failure) {
        Preconditions.checkNotNull((Object)failure, (Object)"failure");
        return new DefaultFailureConverter().failureToException(failure, this);
    }

    @Nonnull
    default public Failure exceptionToFailure(@Nonnull Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable, (Object)"throwable");
        return new DefaultFailureConverter().exceptionToFailure(throwable, this);
    }

    @Experimental
    @Nonnull
    default public DataConverter withContext(@Nonnull SerializationContext context) {
        return this;
    }

    @Deprecated
    public static Object[] arrayFromPayloads(DataConverter converter, Optional<Payloads> content, Class<?>[] parameterTypes, Type[] genericParameterTypes) throws DataConverterException {
        return converter.fromPayloads(content, parameterTypes, genericParameterTypes);
    }
}

