/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.context;

import io.temporal.common.context.ContextPropagator;
import io.temporal.workflow.WorkflowThreadLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ContextThreadLocal {
    private static final WorkflowThreadLocal<List<ContextPropagator>> contextPropagators = WorkflowThreadLocal.withCachedInitial(new Supplier<List<ContextPropagator>>(){

        @Override
        public List<ContextPropagator> get() {
            return new ArrayList<ContextPropagator>();
        }
    });

    public static void setContextPropagators(List<ContextPropagator> propagators) {
        if (propagators == null || propagators.isEmpty()) {
            return;
        }
        contextPropagators.set(propagators);
    }

    public static List<ContextPropagator> getContextPropagators() {
        return contextPropagators.get();
    }

    public static Map<String, Object> getCurrentContextForPropagation() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (ContextPropagator propagator : contextPropagators.get()) {
            contextData.put(propagator.getName(), propagator.getCurrentContext());
        }
        return contextData;
    }

    public static void propagateContextToCurrentThread(Map<String, Object> contextData) {
        if (contextData == null || contextData.isEmpty()) {
            return;
        }
        for (ContextPropagator propagator : contextPropagators.get()) {
            if (!contextData.containsKey(propagator.getName())) continue;
            propagator.setCurrentContext(contextData.get(propagator.getName()));
        }
    }
}

