/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.command.v1.Command;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.CommandType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.failure.v1.ApplicationFailureInfo;
import io.temporal.api.failure.v1.CanceledFailureInfo;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.history.v1.SignalExternalWorkflowExecutionFailedEventAttributes;
import io.temporal.internal.statemachines.CancellableCommand;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachine;
import io.temporal.internal.statemachines.StateMachineDefinition;
import io.temporal.workflow.Functions;

final class SignalExternalStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, SignalExternalStateMachine> {
    private SignalExternalWorkflowExecutionCommandAttributes signalAttributes;
    private final Functions.Proc2<Void, Failure> completionCallback;
    private WorkflowExecution execution;
    public static final StateMachineDefinition<State, ExplicitEvent, SignalExternalStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("SignalExternal", State.CREATED, State.SIGNALED, State.FAILED, State.CANCELED).add(State.CREATED, ExplicitEvent.SCHEDULE, State.SIGNAL_EXTERNAL_COMMAND_CREATED, SignalExternalStateMachine::createSignalExternalCommand).add(State.SIGNAL_EXTERNAL_COMMAND_CREATED, CommandType.COMMAND_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION, State.SIGNAL_EXTERNAL_COMMAND_CREATED).add(State.SIGNAL_EXTERNAL_COMMAND_CREATED, ExplicitEvent.CANCEL, State.CANCELED, SignalExternalStateMachine::cancelSignalExternalCommand).add(State.SIGNAL_EXTERNAL_COMMAND_CREATED, EventType.EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED, State.SIGNAL_EXTERNAL_COMMAND_RECORDED, EntityStateMachineInitialCommand::setInitialCommandEventId).add(State.SIGNAL_EXTERNAL_COMMAND_RECORDED, ExplicitEvent.CANCEL, State.SIGNAL_EXTERNAL_COMMAND_RECORDED).add(State.SIGNAL_EXTERNAL_COMMAND_RECORDED, EventType.EVENT_TYPE_EXTERNAL_WORKFLOW_EXECUTION_SIGNALED, State.SIGNALED, SignalExternalStateMachine::notifyCompleted).add(State.SIGNAL_EXTERNAL_COMMAND_RECORDED, EventType.EVENT_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED, State.FAILED, SignalExternalStateMachine::notifyFailed);

    public static Functions.Proc newInstance(SignalExternalWorkflowExecutionCommandAttributes signalAttributes, Functions.Proc2<Void, Failure> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        SignalExternalStateMachine commands = new SignalExternalStateMachine(signalAttributes, completionCallback, commandSink, stateMachineSink);
        return commands::cancel;
    }

    private SignalExternalStateMachine(SignalExternalWorkflowExecutionCommandAttributes signalAttributes, Functions.Proc2<Void, Failure> completionCallback, Functions.Proc1<CancellableCommand> commandSink, Functions.Proc1<StateMachine> stateMachineSink) {
        super(STATE_MACHINE_DEFINITION, commandSink, stateMachineSink);
        this.signalAttributes = signalAttributes;
        this.execution = signalAttributes.getExecution();
        this.completionCallback = completionCallback;
        this.explicitEvent(ExplicitEvent.SCHEDULE);
    }

    private void createSignalExternalCommand() {
        this.addCommand(Command.newBuilder().setCommandType(CommandType.COMMAND_TYPE_SIGNAL_EXTERNAL_WORKFLOW_EXECUTION).setSignalExternalWorkflowExecutionCommandAttributes(this.signalAttributes).build());
        this.signalAttributes = null;
    }

    public void cancel() {
        if (!this.isFinalState()) {
            this.explicitEvent(ExplicitEvent.CANCEL);
        }
    }

    private void notifyCompleted() {
        this.completionCallback.apply(null, null);
    }

    private void notifyFailed() {
        SignalExternalWorkflowExecutionFailedEventAttributes attributes = this.currentEvent.getSignalExternalWorkflowExecutionFailedEventAttributes();
        Failure failure = Failure.newBuilder().setApplicationFailureInfo(ApplicationFailureInfo.newBuilder().setType(attributes.getCause().name()).build()).setMessage("SignalExternalWorkflowExecution failed with NOT_FOUND. WorkflowId=" + this.execution.getWorkflowId() + ", runId=" + this.execution.getRunId()).build();
        this.completionCallback.apply(null, failure);
    }

    private void cancelSignalExternalCommand() {
        this.cancelCommand();
        Failure failure = Failure.newBuilder().setMessage("Signal external workflow execution canceled").setCanceledFailureInfo(CanceledFailureInfo.newBuilder().build()).build();
        this.completionCallback.apply(null, failure);
    }

    static enum State {
        CREATED,
        SIGNAL_EXTERNAL_COMMAND_CREATED,
        SIGNAL_EXTERNAL_COMMAND_RECORDED,
        SIGNALED,
        FAILED,
        CANCELED;

    }

    static enum ExplicitEvent {
        SCHEDULE,
        CANCEL;

    }
}

