/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.ResourceBasedController;
import io.temporal.worker.tuning.ResourceBasedSlotOptions;
import io.temporal.worker.tuning.ResourceBasedTuner;
import io.temporal.worker.tuning.SlotInfo;
import io.temporal.worker.tuning.SlotMarkUsedContext;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseContext;
import io.temporal.worker.tuning.SlotReserveContext;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.SlotSupplierFuture;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ResourceBasedSlotSupplier<SI extends SlotInfo>
implements SlotSupplier<SI> {
    private final ResourceBasedController resourceController;
    private final ResourceBasedSlotOptions options;
    private Instant lastSlotIssuedAt = Instant.EPOCH;
    private final ScheduledExecutorService scheduler;
    private static ScheduledExecutorService defaultScheduler;

    public static ResourceBasedSlotSupplier<WorkflowSlotInfo> createForWorkflow(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<WorkflowSlotInfo>(WorkflowSlotInfo.class, resourceBasedController, options, null);
    }

    public static ResourceBasedSlotSupplier<WorkflowSlotInfo> createForWorkflow(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options, ScheduledExecutorService scheduler) {
        return new ResourceBasedSlotSupplier<WorkflowSlotInfo>(WorkflowSlotInfo.class, resourceBasedController, options, scheduler);
    }

    public static ResourceBasedSlotSupplier<ActivitySlotInfo> createForActivity(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<ActivitySlotInfo>(ActivitySlotInfo.class, resourceBasedController, options, null);
    }

    public static ResourceBasedSlotSupplier<ActivitySlotInfo> createForActivity(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options, ScheduledExecutorService scheduler) {
        return new ResourceBasedSlotSupplier<ActivitySlotInfo>(ActivitySlotInfo.class, resourceBasedController, options, scheduler);
    }

    public static ResourceBasedSlotSupplier<LocalActivitySlotInfo> createForLocalActivity(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<LocalActivitySlotInfo>(LocalActivitySlotInfo.class, resourceBasedController, options, null);
    }

    public static ResourceBasedSlotSupplier<LocalActivitySlotInfo> createForLocalActivity(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options, ScheduledExecutorService scheduler) {
        return new ResourceBasedSlotSupplier<LocalActivitySlotInfo>(LocalActivitySlotInfo.class, resourceBasedController, options, scheduler);
    }

    public static ResourceBasedSlotSupplier<NexusSlotInfo> createForNexus(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options) {
        return new ResourceBasedSlotSupplier<NexusSlotInfo>(NexusSlotInfo.class, resourceBasedController, options, null);
    }

    public static ResourceBasedSlotSupplier<NexusSlotInfo> createForNexus(ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options, ScheduledExecutorService scheduler) {
        return new ResourceBasedSlotSupplier<NexusSlotInfo>(NexusSlotInfo.class, resourceBasedController, options, scheduler);
    }

    private ResourceBasedSlotSupplier(Class<SI> clazz, ResourceBasedController resourceBasedController, ResourceBasedSlotOptions options, ScheduledExecutorService scheduler) {
        this.resourceController = resourceBasedController;
        this.scheduler = scheduler == null ? ResourceBasedSlotSupplier.getDefaultScheduler() : scheduler;
        this.options = WorkflowSlotInfo.class.isAssignableFrom(clazz) ? ResourceBasedSlotOptions.newBuilder().setMinimumSlots(options.getMinimumSlots() == 0 ? ResourceBasedTuner.DEFAULT_WORKFLOW_SLOT_OPTIONS.getMinimumSlots() : options.getMinimumSlots()).setMaximumSlots(options.getMaximumSlots() == 0 ? ResourceBasedTuner.DEFAULT_WORKFLOW_SLOT_OPTIONS.getMaximumSlots() : options.getMaximumSlots()).setRampThrottle(options.getRampThrottle() == null ? ResourceBasedTuner.DEFAULT_WORKFLOW_SLOT_OPTIONS.getRampThrottle() : options.getRampThrottle()).build() : (ActivitySlotInfo.class.isAssignableFrom(clazz) || LocalActivitySlotInfo.class.isAssignableFrom(clazz) ? ResourceBasedSlotOptions.newBuilder().setMinimumSlots(options.getMinimumSlots() == 0 ? ResourceBasedTuner.DEFAULT_ACTIVITY_SLOT_OPTIONS.getMinimumSlots() : options.getMinimumSlots()).setMaximumSlots(options.getMaximumSlots() == 0 ? ResourceBasedTuner.DEFAULT_ACTIVITY_SLOT_OPTIONS.getMaximumSlots() : options.getMaximumSlots()).setRampThrottle(options.getRampThrottle() == null ? ResourceBasedTuner.DEFAULT_ACTIVITY_SLOT_OPTIONS.getRampThrottle() : options.getRampThrottle()).build() : ResourceBasedSlotOptions.newBuilder().setMinimumSlots(options.getMinimumSlots() == 0 ? ResourceBasedTuner.DEFAULT_NEXUS_SLOT_OPTIONS.getMinimumSlots() : options.getMinimumSlots()).setMaximumSlots(options.getMaximumSlots() == 0 ? ResourceBasedTuner.DEFAULT_NEXUS_SLOT_OPTIONS.getMaximumSlots() : options.getMaximumSlots()).setRampThrottle(options.getRampThrottle() == null ? ResourceBasedTuner.DEFAULT_NEXUS_SLOT_OPTIONS.getRampThrottle() : options.getRampThrottle()).build());
    }

    @Override
    public SlotSupplierFuture reserveSlot(SlotReserveContext<SI> ctx) throws Exception {
        if (ctx.getNumIssuedSlots() < this.options.getMinimumSlots()) {
            return SlotSupplierFuture.completedFuture(new SlotPermit());
        }
        return this.tryReserveSlot(ctx).map(SlotSupplierFuture::completedFuture).orElseGet(() -> this.scheduleSlotAcquisition(ctx));
    }

    private SlotSupplierFuture scheduleSlotAcquisition(SlotReserveContext<SI> ctx) {
        Duration mustWaitFor;
        try {
            mustWaitFor = this.options.getRampThrottle().minus(this.timeSinceLastSlotIssued());
        }
        catch (ArithmeticException e) {
            mustWaitFor = Duration.ZERO;
        }
        CompletableFuture<Object> permitFuture = mustWaitFor.compareTo(Duration.ZERO) > 0 ? CompletableFuture.supplyAsync(() -> null, this.delayedExecutor(mustWaitFor.toMillis())) : CompletableFuture.completedFuture(null);
        return SlotSupplierFuture.fromCompletableFuture((CompletableFuture<SlotPermit>)permitFuture.thenCompose(ignored -> {
            Optional<SlotPermit> permit = this.tryReserveSlot(ctx);
            return permit.map(CompletableFuture::completedFuture).orElseGet(() -> CompletableFuture.supplyAsync(() -> null, this.delayedExecutor(10L)).thenCompose(ig -> this.scheduleSlotAcquisition(ctx)));
        }), () -> permitFuture.cancel(true));
    }

    @Override
    public Optional<SlotPermit> tryReserveSlot(SlotReserveContext<SI> ctx) {
        int numIssued = ctx.getNumIssuedSlots();
        if (numIssued < this.options.getMinimumSlots() || this.timeSinceLastSlotIssued().compareTo(this.options.getRampThrottle()) > 0 && numIssued < this.options.getMaximumSlots() && this.resourceController.pidDecision()) {
            this.lastSlotIssuedAt = Instant.now();
            return Optional.of(new SlotPermit());
        }
        return Optional.empty();
    }

    @Override
    public void markSlotUsed(SlotMarkUsedContext<SI> ctx) {
    }

    @Override
    public void releaseSlot(SlotReleaseContext<SI> ctx) {
    }

    public ResourceBasedController getResourceController() {
        return this.resourceController;
    }

    private Duration timeSinceLastSlotIssued() {
        return Duration.between(this.lastSlotIssuedAt, Instant.now());
    }

    private Executor delayedExecutor(long delay) {
        return r -> this.scheduler.schedule(() -> this.scheduler.execute(r), delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScheduledExecutorService getDefaultScheduler() {
        Class<ResourceBasedSlotSupplier> clazz = ResourceBasedSlotSupplier.class;
        synchronized (ResourceBasedSlotSupplier.class) {
            if (defaultScheduler == null) {
                defaultScheduler = Executors.newScheduledThreadPool(2, r -> {
                    Thread t = new Thread(r);
                    t.setName("ResourceBasedSlotSupplier.scheduler");
                    t.setDaemon(true);
                    return t;
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultScheduler;
        }
    }
}

