/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.worker.tuning.SlotPermit;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public abstract class SlotSupplierFuture
extends CompletableFuture<SlotPermit> {
    @Nullable
    @CheckReturnValue
    public abstract SlotPermit abortReservation();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Do not call cancel on SlotSupplierFuture, use abortReservation");
    }

    public static SlotSupplierFuture completedFuture(final SlotPermit permit) {
        return new SlotSupplierFuture(){
            {
                this.complete(permit);
            }

            @Override
            public SlotPermit abortReservation() {
                return permit;
            }
        };
    }

    public static SlotSupplierFuture fromCompletableFuture(final CompletableFuture<SlotPermit> future, final Runnable abortHandler) {
        SlotSupplierFuture wrapper = new SlotSupplierFuture(){

            @Override
            public SlotPermit abortReservation() {
                boolean abortedNow = this.completeExceptionally(new CancellationException("Reservation aborted"));
                if (abortedNow) {
                    abortHandler.run();
                    future.cancel(true);
                    return null;
                }
                return (SlotPermit)this.join();
            }
        };
        future.whenComplete((result, throwable) -> {
            if (!wrapper.isDone()) {
                if (throwable != null) {
                    wrapper.completeExceptionally((Throwable)throwable);
                } else {
                    wrapper.complete(result);
                }
            }
        });
        return wrapper;
    }
}

