/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import io.temporal.common.Experimental;
import io.temporal.workflow.NexusOperationCancellationType;
import java.time.Duration;
import java.util.Objects;

public final class NexusOperationOptions {
    private static final NexusOperationOptions DEFAULT_INSTANCE = NexusOperationOptions.newBuilder().build();
    private final Duration scheduleToCloseTimeout;
    private final NexusOperationCancellationType cancellationType;
    private final String summary;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(NexusOperationOptions options) {
        return new Builder(options);
    }

    public static NexusOperationOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private NexusOperationOptions(Duration scheduleToCloseTimeout, NexusOperationCancellationType cancellationType, String summary) {
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        this.cancellationType = cancellationType;
        this.summary = summary;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Duration getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public NexusOperationCancellationType getCancellationType() {
        return this.cancellationType;
    }

    @Experimental
    public String getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NexusOperationOptions that = (NexusOperationOptions)o;
        return Objects.equals(this.scheduleToCloseTimeout, that.scheduleToCloseTimeout) && Objects.equals((Object)this.cancellationType, (Object)that.cancellationType) && Objects.equals(this.summary, that.summary);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheduleToCloseTimeout, this.cancellationType, this.summary});
    }

    public String toString() {
        return "NexusOperationOptions{scheduleToCloseTimeout=" + this.scheduleToCloseTimeout + ", cancellationType=" + (Object)((Object)this.cancellationType) + ", summary='" + this.summary + '\'' + '}';
    }

    public static final class Builder {
        private Duration scheduleToCloseTimeout;
        private NexusOperationCancellationType cancellationType;
        private String summary;

        public Builder setScheduleToCloseTimeout(Duration scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        @Experimental
        public Builder setCancellationType(NexusOperationCancellationType cancellationType) {
            this.cancellationType = cancellationType;
            return this;
        }

        @Experimental
        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        private Builder() {
        }

        private Builder(NexusOperationOptions options) {
            if (options == null) {
                return;
            }
            this.scheduleToCloseTimeout = options.getScheduleToCloseTimeout();
            this.cancellationType = options.getCancellationType();
            this.summary = options.getSummary();
        }

        public NexusOperationOptions build() {
            return new NexusOperationOptions(this.scheduleToCloseTimeout, this.cancellationType, this.summary);
        }

        public Builder mergeNexusOperationOptions(NexusOperationOptions override) {
            if (override == null) {
                return this;
            }
            this.scheduleToCloseTimeout = override.scheduleToCloseTimeout == null ? this.scheduleToCloseTimeout : override.scheduleToCloseTimeout;
            this.cancellationType = override.cancellationType == null ? this.cancellationType : override.cancellationType;
            this.summary = override.summary == null ? this.summary : override.summary;
            return this;
        }
    }
}

