/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.common;

import io.temporal.common.Experimental;
import java.util.Objects;

@Experimental
public class Priority {
    private static final Priority DEFAULT_INSTANCE = Priority.newBuilder().build();
    private final int priorityKey;
    private final String fairnessKey;
    private final float fairnessWeight;

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public static Priority getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private Priority(int priorityKey, String fairnessKey, float fairnessWeight) {
        this.priorityKey = priorityKey;
        this.fairnessKey = fairnessKey;
        this.fairnessWeight = fairnessWeight;
    }

    public int getPriorityKey() {
        return this.priorityKey;
    }

    public String getFairnessKey() {
        return this.fairnessKey;
    }

    public float getFairnessWeight() {
        return this.fairnessWeight;
    }

    public String toString() {
        return "Priority{priorityKey=" + this.priorityKey + ", fairnessKey='" + this.fairnessKey + '\'' + ", fairnessWeight=" + this.fairnessWeight + '}';
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Priority priority = (Priority)o;
        return this.priorityKey == priority.priorityKey && Float.compare(priority.fairnessWeight, this.fairnessWeight) == 0 && Objects.equals(this.fairnessKey, priority.fairnessKey);
    }

    public int hashCode() {
        return Objects.hash(this.priorityKey, this.fairnessKey, Float.valueOf(this.fairnessWeight));
    }

    public static final class Builder {
        private int priorityKey;
        private String fairnessKey;
        private float fairnessWeight;

        private Builder(Priority options) {
            if (options == null) {
                return;
            }
            this.priorityKey = options.getPriorityKey();
            this.fairnessKey = options.getFairnessKey();
            this.fairnessWeight = options.getFairnessWeight();
        }

        public Builder setPriorityKey(int priorityKey) {
            this.priorityKey = priorityKey;
            return this;
        }

        public Builder setFairnessKey(String fairnessKey) {
            this.fairnessKey = fairnessKey;
            return this;
        }

        public Builder setFairnessWeight(float fairnessWeight) {
            this.fairnessWeight = fairnessWeight;
            return this;
        }

        public Priority build() {
            return new Priority(this.priorityKey, this.fairnessKey, this.fairnessWeight);
        }
    }
}

