/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker;

import com.google.common.base.Preconditions;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.internal.worker.TrackingSlotSupplier;
import io.temporal.internal.worker.WorkflowTask;
import io.temporal.worker.WorkerDeploymentOptions;
import io.temporal.worker.tuning.SlotPermit;
import io.temporal.worker.tuning.SlotReleaseReason;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowTaskDispatchHandle
implements Closeable {
    private final AtomicBoolean completed = new AtomicBoolean();
    private final Function<WorkflowTask, Boolean> dispatchCallback;
    private final TrackingSlotSupplier<WorkflowSlotInfo> slotSupplier;
    private final SlotPermit permit;
    private final WorkerDeploymentOptions deploymentOptions;

    public WorkflowTaskDispatchHandle(DispatchCallback dispatchCallback, TrackingSlotSupplier<WorkflowSlotInfo> slotSupplier, SlotPermit permit, @Nullable WorkerDeploymentOptions deploymentOptions) {
        this.dispatchCallback = dispatchCallback;
        this.slotSupplier = slotSupplier;
        this.permit = permit;
        this.deploymentOptions = deploymentOptions;
    }

    public boolean dispatch(@Nonnull PollWorkflowTaskQueueResponse workflowTask) {
        Preconditions.checkNotNull((Object)workflowTask, (Object)"workflowTask");
        if (this.completed.compareAndSet(false, true)) {
            return this.dispatchCallback.apply(new WorkflowTask(workflowTask, rr -> this.slotSupplier.releaseSlot((SlotReleaseReason)rr, this.permit)));
        }
        return false;
    }

    @Nullable
    public WorkerDeploymentOptions getDeploymentOptions() {
        return this.deploymentOptions;
    }

    @Override
    public void close() {
        if (this.completed.compareAndSet(false, true)) {
            this.slotSupplier.releaseSlot(SlotReleaseReason.neverUsed(), this.permit);
        }
    }

    @FunctionalInterface
    public static interface DispatchCallback
    extends Function<WorkflowTask, Boolean> {
        @Override
        public Boolean apply(WorkflowTask var1) throws IllegalArgumentException;
    }
}

