/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import com.sun.management.OperatingSystemMXBean;
import io.temporal.worker.tuning.SystemResourceInfo;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class JVMSystemResourceInfo
implements SystemResourceInfo {
    OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private final Lock refreshLock = new ReentrantLock();
    private SystemInfo lastSystemInfo;

    @Override
    public double getCPUUsagePercent() {
        return this.refresh().cpuUsagePercent;
    }

    @Override
    public double getMemoryUsagePercent() {
        return this.refresh().memoryUsagePercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemInfo refresh() {
        this.refreshLock.lock();
        try {
            if (this.lastSystemInfo == null || Instant.now().isAfter(this.lastSystemInfo.refreshed.plusMillis(100L))) {
                double lastCpuUsage = this.osBean.getSystemCpuLoad();
                if (lastCpuUsage < 0.0 || Double.isNaN(lastCpuUsage)) {
                    lastCpuUsage = 0.0;
                }
                Runtime runtime = Runtime.getRuntime();
                long jvmUsedMemory = runtime.totalMemory() - runtime.freeMemory();
                long jvmMaxMemory = runtime.maxMemory();
                double lastMemUsage = (double)jvmUsedMemory / (double)jvmMaxMemory;
                Instant lastRefresh = Instant.now();
                this.lastSystemInfo = new SystemInfo(lastRefresh, lastCpuUsage, lastMemUsage);
            }
        }
        finally {
            this.refreshLock.unlock();
        }
        return this.lastSystemInfo;
    }

    private static class SystemInfo {
        private final Instant refreshed;
        private final double cpuUsagePercent;
        private final double memoryUsagePercent;

        private SystemInfo(Instant refreshed, double cpuUsagePercent, double memoryUsagePercent) {
            this.refreshed = refreshed;
            this.cpuUsagePercent = cpuUsagePercent;
            this.memoryUsagePercent = memoryUsagePercent;
        }
    }
}

