/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class AsyncBackoffThrottler {
    private static final ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(1);
    private final Duration initialSleep;
    private final Duration maxSleep;
    private final double backoffCoefficient;
    private final AtomicLong failureCount = new AtomicLong();

    public AsyncBackoffThrottler(Duration initialSleep, Duration maxSleep, double backoffCoefficient) {
        Objects.requireNonNull(initialSleep, "initialSleep");
        if (backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("backoff coefficient less than 1.0: " + backoffCoefficient);
        }
        this.initialSleep = initialSleep;
        this.maxSleep = maxSleep;
        this.backoffCoefficient = backoffCoefficient;
    }

    private long calculateSleepTime() {
        double sleepMillis = Math.pow(this.backoffCoefficient, this.failureCount.get() - 1L) * (double)this.initialSleep.toMillis();
        if (this.maxSleep != null) {
            return Math.min((long)sleepMillis, this.maxSleep.toMillis());
        }
        return (long)sleepMillis;
    }

    public CompletableFuture<Void> throttle() {
        if (this.failureCount.get() == 0L) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        long delay = this.calculateSleepTime();
        ScheduledFuture<Boolean> ignored = executor.schedule(() -> result.complete(null), delay, TimeUnit.MILLISECONDS);
        return result;
    }

    public void success() {
        this.failureCount.set(0L);
    }

    public void failure() {
        this.failureCount.incrementAndGet();
    }
}

