/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.Defaults;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import io.temporal.api.errordetails.v1.QueryFailedFailure;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class RpcRetryOptions {
    public static final RpcRetryOptions DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS;
    private static final Duration RETRY_SERVICE_OPERATION_INITIAL_INTERVAL;
    private static final Duration RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL;
    private static final double RETRY_SERVICE_OPERATION_BACKOFF = 1.2;
    private static final RpcRetryOptions DEFAULT_INSTANCE;
    private final Duration initialInterval;
    private final double backoffCoefficient;
    private final Duration expiration;
    private final int maximumAttempts;
    private final Duration maximumInterval;
    private final List<DoNotRetryPair> doNotRetry;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(RpcRetryOptions options) {
        return new Builder(options);
    }

    public static RpcRetryOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private RpcRetryOptions(Duration initialInterval, double backoffCoefficient, Duration expiration, int maximumAttempts, Duration maximumInterval, List<DoNotRetryPair> doNotRetry) {
        this.initialInterval = initialInterval;
        this.backoffCoefficient = backoffCoefficient;
        this.expiration = expiration;
        this.maximumAttempts = maximumAttempts;
        this.maximumInterval = maximumInterval;
        this.doNotRetry = doNotRetry != null ? Collections.unmodifiableList(doNotRetry) : null;
    }

    public Duration getInitialInterval() {
        return this.initialInterval;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public Duration getExpiration() {
        return this.expiration;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public Duration getMaximumInterval() {
        return this.maximumInterval;
    }

    public void validate() {
        if (this.initialInterval == null) {
            throw new IllegalStateException("required property initialInterval not set");
        }
        if (this.expiration == null && this.maximumAttempts <= 0) {
            throw new IllegalArgumentException("both MaximumAttempts and Expiration on retry policy are not set, at least one of them must be set");
        }
        if (this.maximumInterval != null && this.maximumInterval.compareTo(this.initialInterval) < 0) {
            throw new IllegalStateException("maximumInterval(" + this.maximumInterval + ") cannot be smaller than initialInterval(" + this.initialInterval);
        }
        if (this.backoffCoefficient != 0.0 && this.backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("coefficient less than 1");
        }
        if (this.maximumAttempts != 0 && this.maximumAttempts < 0) {
            throw new IllegalArgumentException("negative maximum attempts");
        }
    }

    public List<DoNotRetryPair> getDoNotRetry() {
        return this.doNotRetry;
    }

    public String toString() {
        return "RetryOptions{initialInterval=" + this.initialInterval + ", backoffCoefficient=" + this.backoffCoefficient + ", expiration=" + this.expiration + ", maximumAttempts=" + this.maximumAttempts + ", maximumInterval=" + this.maximumInterval + ", doNotRetry=" + this.doNotRetry + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcRetryOptions that = (RpcRetryOptions)o;
        return Double.compare(that.backoffCoefficient, this.backoffCoefficient) == 0 && this.maximumAttempts == that.maximumAttempts && Objects.equals(this.initialInterval, that.initialInterval) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.maximumInterval, that.maximumInterval) && Objects.equals(this.doNotRetry, that.doNotRetry);
    }

    public int hashCode() {
        return Objects.hash(this.initialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
    }

    static {
        RETRY_SERVICE_OPERATION_INITIAL_INTERVAL = Duration.ofMillis(20L);
        RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL = Duration.ofMinutes(1L);
        Builder roBuilder = RpcRetryOptions.newBuilder().setInitialInterval(RETRY_SERVICE_OPERATION_INITIAL_INTERVAL).setExpiration(RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL).setBackoffCoefficient(1.2);
        Duration maxInterval = RETRY_SERVICE_OPERATION_EXPIRATION_INTERVAL.dividedBy(10L);
        if (maxInterval.compareTo(RETRY_SERVICE_OPERATION_INITIAL_INTERVAL) < 0) {
            maxInterval = RETRY_SERVICE_OPERATION_INITIAL_INTERVAL;
        }
        roBuilder.setMaximumInterval(maxInterval);
        roBuilder.addDoNotRetry(Status.Code.INVALID_ARGUMENT, null).addDoNotRetry(Status.Code.NOT_FOUND, null).addDoNotRetry(Status.Code.ALREADY_EXISTS, null).addDoNotRetry(Status.Code.FAILED_PRECONDITION, null).addDoNotRetry(Status.Code.PERMISSION_DENIED, null).addDoNotRetry(Status.Code.UNAUTHENTICATED, null).addDoNotRetry(Status.Code.UNIMPLEMENTED, null).addDoNotRetry(Status.Code.CANCELLED, null).addDoNotRetry(Status.Code.INTERNAL, QueryFailedFailure.class);
        DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS = roBuilder.validateBuildWithDefaults();
        DEFAULT_INSTANCE = RpcRetryOptions.newBuilder().build();
    }

    public static final class Builder {
        private Duration initialInterval;
        private Duration expiration;
        private double backoffCoefficient;
        private int maximumAttempts;
        private Duration maximumInterval;
        private List<DoNotRetryPair> doNotRetry = new ArrayList<DoNotRetryPair>();

        private Builder() {
        }

        private Builder(RpcRetryOptions options) {
            if (options == null) {
                return;
            }
            this.backoffCoefficient = options.getBackoffCoefficient();
            this.maximumAttempts = options.getMaximumAttempts();
            this.expiration = options.getExpiration();
            this.initialInterval = options.getInitialInterval();
            this.maximumInterval = options.getMaximumInterval();
            this.doNotRetry = options.getDoNotRetry();
        }

        public Builder setInitialInterval(Duration initialInterval) {
            Objects.requireNonNull(initialInterval);
            if (initialInterval.isNegative() || initialInterval.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + initialInterval);
            }
            this.initialInterval = initialInterval;
            return this;
        }

        public Builder setExpiration(Duration expiration) {
            Objects.requireNonNull(expiration);
            if (expiration.isNegative() || expiration.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + expiration);
            }
            this.expiration = expiration;
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            if (backoffCoefficient < 1.0) {
                throw new IllegalArgumentException("coefficient less than 1.0: " + backoffCoefficient);
            }
            this.backoffCoefficient = backoffCoefficient;
            return this;
        }

        public Builder setMaximumAttempts(int maximumAttempts) {
            if (maximumAttempts < 1) {
                throw new IllegalArgumentException("Invalid maximumAttempts: " + maximumAttempts);
            }
            this.maximumAttempts = maximumAttempts;
            return this;
        }

        public Builder setMaximumInterval(Duration maximumInterval) {
            Objects.requireNonNull(maximumInterval);
            if (maximumInterval.isNegative() || maximumInterval.isZero()) {
                throw new IllegalArgumentException("Invalid interval: " + maximumInterval);
            }
            this.maximumInterval = maximumInterval;
            return this;
        }

        public Builder addDoNotRetry(Status.Code code, Class<? extends GeneratedMessageV3> detailsClass) {
            this.doNotRetry.add(new DoNotRetryPair(code, detailsClass));
            return this;
        }

        Builder setDoNotRetry(List<DoNotRetryPair> pairs) {
            this.doNotRetry = pairs;
            return this;
        }

        public Builder setRetryOptions(RpcRetryOptions o) {
            if (o == null) {
                return this;
            }
            this.setInitialInterval(Builder.merge(this.initialInterval, o.getInitialInterval(), Duration.class));
            this.setExpiration(Builder.merge(this.expiration, o.getExpiration(), Duration.class));
            this.setMaximumInterval(Builder.merge(this.maximumInterval, o.getMaximumInterval(), Duration.class));
            this.setBackoffCoefficient(Builder.merge(this.backoffCoefficient, o.getBackoffCoefficient(), Double.TYPE));
            this.setMaximumAttempts(Builder.merge(this.maximumAttempts, o.getMaximumAttempts(), Integer.TYPE));
            this.setDoNotRetry(this.merge(this.doNotRetry, o.getDoNotRetry()));
            this.validateBuildWithDefaults();
            return this;
        }

        private static <G> G merge(G annotation, G options, Class<G> type) {
            if (!Defaults.defaultValue(type).equals(options)) {
                return options;
            }
            return annotation;
        }

        private List<DoNotRetryPair> merge(List<DoNotRetryPair> o1, List<DoNotRetryPair> o2) {
            if (o2 != null) {
                return new ArrayList<DoNotRetryPair>(o2);
            }
            if (o1.size() > 0) {
                return new ArrayList<DoNotRetryPair>(o1);
            }
            return null;
        }

        public RpcRetryOptions build() {
            return new RpcRetryOptions(this.initialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
        }

        public RpcRetryOptions buildWithDefaultsFrom(RpcRetryOptions rpcRetryOptions) {
            return RpcRetryOptions.newBuilder().setRetryOptions(rpcRetryOptions).validateBuildWithDefaults();
        }

        public RpcRetryOptions validateBuildWithDefaults() {
            double backoff = this.backoffCoefficient;
            if (backoff == 0.0) {
                backoff = DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS.backoffCoefficient;
            }
            if (this.initialInterval == null || this.initialInterval.isZero() || this.initialInterval.isNegative()) {
                this.initialInterval = DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS.initialInterval;
            }
            if (this.expiration == null || this.expiration.isZero() || this.expiration.isNegative()) {
                this.expiration = DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS.expiration;
            }
            if (this.maximumInterval == null || this.maximumInterval.isZero() || this.maximumInterval.isNegative()) {
                this.maximumInterval = DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS.maximumInterval;
            }
            if (this.doNotRetry == null || this.doNotRetry.size() == 0) {
                this.doNotRetry = DEFAULT_SERVICE_OPERATION_RETRY_OPTIONS.doNotRetry;
            }
            RpcRetryOptions result = new RpcRetryOptions(this.initialInterval, backoff, this.expiration, this.maximumAttempts, this.maximumInterval, this.doNotRetry);
            result.validate();
            return result;
        }
    }

    public static class DoNotRetryPair {
        private final Status.Code code;
        private final Class<? extends GeneratedMessageV3> detailsClass;

        private DoNotRetryPair(Status.Code code, Class<? extends GeneratedMessageV3> detailsClass) {
            this.code = code;
            this.detailsClass = detailsClass;
        }

        public Status.Code getCode() {
            return this.code;
        }

        public Class<? extends GeneratedMessageV3> getDetailsClass() {
            return this.detailsClass;
        }
    }
}

