package io.temporal.api.operatorservice.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
 * to perform administrative functions like registering a search attribute or a namespace.
 * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
 * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.34.0)",
    comments = "Source: temporal/api/operatorservice/v1/service.proto")
public final class OperatorServiceGrpc {

  private OperatorServiceGrpc() {}

  public static final String SERVICE_NAME = "temporal.api.operatorservice.v1.OperatorService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "AddSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.AddSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.AddSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest, io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> getAddSearchAttributesMethod;
    if ((getAddSearchAttributesMethod = OperatorServiceGrpc.getAddSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getAddSearchAttributesMethod = OperatorServiceGrpc.getAddSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getAddSearchAttributesMethod = getAddSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.AddSearchAttributesRequest, io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "AddSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.AddSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("AddSearchAttributes"))
              .build();
        }
      }
    }
    return getAddSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RemoveSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest, io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> getRemoveSearchAttributesMethod;
    if ((getRemoveSearchAttributesMethod = OperatorServiceGrpc.getRemoveSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getRemoveSearchAttributesMethod = OperatorServiceGrpc.getRemoveSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getRemoveSearchAttributesMethod = getRemoveSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest, io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RemoveSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("RemoveSearchAttributes"))
              .build();
        }
      }
    }
    return getRemoveSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ListSearchAttributes",
      requestType = io.temporal.api.operatorservice.v1.ListSearchAttributesRequest.class,
      responseType = io.temporal.api.operatorservice.v1.ListSearchAttributesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
      io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest, io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> getListSearchAttributesMethod;
    if ((getListSearchAttributesMethod = OperatorServiceGrpc.getListSearchAttributesMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getListSearchAttributesMethod = OperatorServiceGrpc.getListSearchAttributesMethod) == null) {
          OperatorServiceGrpc.getListSearchAttributesMethod = getListSearchAttributesMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.ListSearchAttributesRequest, io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ListSearchAttributes"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListSearchAttributesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.ListSearchAttributesResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("ListSearchAttributes"))
              .build();
        }
      }
    }
    return getListSearchAttributesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
      io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteNamespace",
      requestType = io.temporal.api.operatorservice.v1.DeleteNamespaceRequest.class,
      responseType = io.temporal.api.operatorservice.v1.DeleteNamespaceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
      io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest, io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> getDeleteNamespaceMethod;
    if ((getDeleteNamespaceMethod = OperatorServiceGrpc.getDeleteNamespaceMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getDeleteNamespaceMethod = OperatorServiceGrpc.getDeleteNamespaceMethod) == null) {
          OperatorServiceGrpc.getDeleteNamespaceMethod = getDeleteNamespaceMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.DeleteNamespaceRequest, io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteNamespace"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNamespaceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteNamespaceResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("DeleteNamespace"))
              .build();
        }
      }
    }
    return getDeleteNamespaceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest,
      io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse> getDeleteWorkflowExecutionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeleteWorkflowExecution",
      requestType = io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest.class,
      responseType = io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest,
      io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse> getDeleteWorkflowExecutionMethod() {
    io.grpc.MethodDescriptor<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest, io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse> getDeleteWorkflowExecutionMethod;
    if ((getDeleteWorkflowExecutionMethod = OperatorServiceGrpc.getDeleteWorkflowExecutionMethod) == null) {
      synchronized (OperatorServiceGrpc.class) {
        if ((getDeleteWorkflowExecutionMethod = OperatorServiceGrpc.getDeleteWorkflowExecutionMethod) == null) {
          OperatorServiceGrpc.getDeleteWorkflowExecutionMethod = getDeleteWorkflowExecutionMethod =
              io.grpc.MethodDescriptor.<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest, io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "DeleteWorkflowExecution"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OperatorServiceMethodDescriptorSupplier("DeleteWorkflowExecution"))
              .build();
        }
      }
    }
    return getDeleteWorkflowExecutionMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static OperatorServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceStub>() {
        @java.lang.Override
        public OperatorServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceStub(channel, callOptions);
        }
      };
    return OperatorServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static OperatorServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceBlockingStub>() {
        @java.lang.Override
        public OperatorServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceBlockingStub(channel, callOptions);
        }
      };
    return OperatorServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static OperatorServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OperatorServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OperatorServiceFutureStub>() {
        @java.lang.Override
        public OperatorServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OperatorServiceFutureStub(channel, callOptions);
        }
      };
    return OperatorServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static abstract class OperatorServiceImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public void addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getAddSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public void removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getRemoveSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public void listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getListSearchAttributesMethod(), responseObserver);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public void deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteNamespaceMethod(), responseObserver);
    }

    /**
     * <pre>
     * DeleteWorkflowExecution deletes a closed workflow execution asynchronously (workflow must be completed or terminated before).
     * This method is EXPERIMENTAL and may be changed or removed in a later release.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public void deleteWorkflowExecution(io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeleteWorkflowExecutionMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getAddSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.AddSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>(
                  this, METHODID_ADD_SEARCH_ATTRIBUTES)))
          .addMethod(
            getRemoveSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>(
                  this, METHODID_REMOVE_SEARCH_ATTRIBUTES)))
          .addMethod(
            getListSearchAttributesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.ListSearchAttributesRequest,
                io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>(
                  this, METHODID_LIST_SEARCH_ATTRIBUTES)))
          .addMethod(
            getDeleteNamespaceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.DeleteNamespaceRequest,
                io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>(
                  this, METHODID_DELETE_NAMESPACE)))
          .addMethod(
            getDeleteWorkflowExecutionMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest,
                io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse>(
                  this, METHODID_DELETE_WORKFLOW_EXECUTION)))
          .build();
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceStub extends io.grpc.stub.AbstractAsyncStub<OperatorServiceStub> {
    private OperatorServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public void addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getAddSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public void removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getRemoveSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public void listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getListSearchAttributesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public void deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteNamespaceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * DeleteWorkflowExecution deletes a closed workflow execution asynchronously (workflow must be completed or terminated before).
     * This method is EXPERIMENTAL and may be changed or removed in a later release.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public void deleteWorkflowExecution(io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest request,
        io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeleteWorkflowExecutionMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<OperatorServiceBlockingStub> {
    private OperatorServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.AddSearchAttributesResponse addSearchAttributes(io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getAddSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse removeSearchAttributes(io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getRemoveSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.ListSearchAttributesResponse listSearchAttributes(io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request) {
      return blockingUnaryCall(
          getChannel(), getListSearchAttributesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.DeleteNamespaceResponse deleteNamespace(io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteNamespaceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * DeleteWorkflowExecution deletes a closed workflow execution asynchronously (workflow must be completed or terminated before).
     * This method is EXPERIMENTAL and may be changed or removed in a later release.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse deleteWorkflowExecution(io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeleteWorkflowExecutionMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * OperatorService API defines how Temporal SDKs and other clients interact with the Temporal server
   * to perform administrative functions like registering a search attribute or a namespace.
   * APIs in this file could be not compatible with Temporal Cloud, hence it's usage in SDKs should be limited by
   * designated APIs that clearly state that they shouldn't be used by the main Application (Workflows &amp; Activities) framework.
   * </pre>
   */
  public static final class OperatorServiceFutureStub extends io.grpc.stub.AbstractFutureStub<OperatorServiceFutureStub> {
    private OperatorServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OperatorServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OperatorServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * AddSearchAttributes add custom search attributes.
     * Returns ALREADY_EXISTS status code if a Search Attribute with any of the specified names already exists
     * Returns INTERNAL status code with temporal.api.errordetails.v1.SystemWorkflowFailure in Error Details if registration process fails,
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse> addSearchAttributes(
        io.temporal.api.operatorservice.v1.AddSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getAddSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * RemoveSearchAttributes removes custom search attributes.
     * Returns NOT_FOUND status code if a Search Attribute with any of the specified names is not registered
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse> removeSearchAttributes(
        io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getRemoveSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * ListSearchAttributes returns comprehensive information about search attributes.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse> listSearchAttributes(
        io.temporal.api.operatorservice.v1.ListSearchAttributesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getListSearchAttributesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * DeleteNamespace synchronously deletes a namespace and asynchronously reclaims all namespace resources.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse> deleteNamespace(
        io.temporal.api.operatorservice.v1.DeleteNamespaceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteNamespaceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * DeleteWorkflowExecution deletes a closed workflow execution asynchronously (workflow must be completed or terminated before).
     * This method is EXPERIMENTAL and may be changed or removed in a later release.
     * (-- api-linter: core::0135::method-signature=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * (-- api-linter: core::0135::response-message-name=disabled
     *     aip.dev/not-precedent: DeleteNamespace RPC doesn't follow Google API format. --)
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse> deleteWorkflowExecution(
        io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeleteWorkflowExecutionMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ADD_SEARCH_ATTRIBUTES = 0;
  private static final int METHODID_REMOVE_SEARCH_ATTRIBUTES = 1;
  private static final int METHODID_LIST_SEARCH_ATTRIBUTES = 2;
  private static final int METHODID_DELETE_NAMESPACE = 3;
  private static final int METHODID_DELETE_WORKFLOW_EXECUTION = 4;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final OperatorServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(OperatorServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ADD_SEARCH_ATTRIBUTES:
          serviceImpl.addSearchAttributes((io.temporal.api.operatorservice.v1.AddSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.AddSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_REMOVE_SEARCH_ATTRIBUTES:
          serviceImpl.removeSearchAttributes((io.temporal.api.operatorservice.v1.RemoveSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.RemoveSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_LIST_SEARCH_ATTRIBUTES:
          serviceImpl.listSearchAttributes((io.temporal.api.operatorservice.v1.ListSearchAttributesRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.ListSearchAttributesResponse>) responseObserver);
          break;
        case METHODID_DELETE_NAMESPACE:
          serviceImpl.deleteNamespace((io.temporal.api.operatorservice.v1.DeleteNamespaceRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteNamespaceResponse>) responseObserver);
          break;
        case METHODID_DELETE_WORKFLOW_EXECUTION:
          serviceImpl.deleteWorkflowExecution((io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionRequest) request,
              (io.grpc.stub.StreamObserver<io.temporal.api.operatorservice.v1.DeleteWorkflowExecutionResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class OperatorServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    OperatorServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.temporal.api.operatorservice.v1.ServiceProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("OperatorService");
    }
  }

  private static final class OperatorServiceFileDescriptorSupplier
      extends OperatorServiceBaseDescriptorSupplier {
    OperatorServiceFileDescriptorSupplier() {}
  }

  private static final class OperatorServiceMethodDescriptorSupplier
      extends OperatorServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    OperatorServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (OperatorServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new OperatorServiceFileDescriptorSupplier())
              .addMethod(getAddSearchAttributesMethod())
              .addMethod(getRemoveSearchAttributesMethod())
              .addMethod(getListSearchAttributesMethod())
              .addMethod(getDeleteNamespaceMethod())
              .addMethod(getDeleteWorkflowExecutionMethod())
              .build();
        }
      }
    }
    return result;
  }
}
